<?php
/**
 * Woocommerce Trigger Cart when Product added Options.
 *
 * @package Base Pro
 */

namespace BasePro;

use Base\Theme_Customizer;
use function Base\webapp;
Theme_Customizer::add_settings(
	array(
		'cart_pop_show_on_add' => array(
			'control_type' => 'base_switch_control',
			'section'      => 'cart_behavior',
			'priority'     => 11,
			'default'      => webapp()->default( 'cart_pop_show_on_add' ),
			'label'        => esc_html__( 'Show the cart popout on add to cart?', 'templatemela-core' ),
			'transport'    => 'refresh',
		),
		'ajax_add_single_products' => array(
			'control_type' => 'base_switch_control',
			'section'      => 'cart_behavior',
			'priority'     => 11,
			'default'      => webapp()->default( 'ajax_add_single_products' ),
			'label'        => esc_html__( 'Single Product Ajax Add to Cart', 'templatemela-core' ),
			'transport'    => 'refresh',
		),
	)
);
