<?php
/**
 * Dark Mode Options.
 *
 * @package Base Pro
 */

namespace BasePro;

use Base\Theme_Customizer;
use function Base\webapp;
Theme_Customizer::add_settings(
	array(
		'info_mobile_dark_mode_switch' => array(
			'control_type' => 'base_title_control',
			'section'      => 'mobile_dark_mode',
			'priority'     => 1,
			'label'        => esc_html__( '*You must Enable Dark Mode', 'templatemela-core' ),
			'description'  => esc_html__( 'To view the color switcher you must enable dark mode under General then Color Switch (Dark Mode)', 'templatemela-core' ),
			'settings'     => false,
			'context'      => array(
				array(
					'setting'  => 'dark_mode_enable',
					'operator' => '!=',
					'value'    => true,
				),
			),
		),
		'mobile_dark_mode_switch_type' => array(
			'control_type' => 'base_select_control',
			'section'      => 'mobile_dark_mode',
			'priority'     => 11,
			'default'      => webapp()->default( 'mobile_dark_mode_switch_type' ),
			'label'        => esc_html__( 'Switch Type', 'templatemela-core' ),
			'input_attrs'  => array(
				'options' => array(
					'icon' => array(
						'name' => __( 'Icons', 'templatemela-core' ),
					),
					'text' => array(
						'name' => __( 'Text', 'templatemela-core' ),
					),
					'both' => array(
						'name' => __( 'Icons and Text', 'templatemela-core' ),
					),
				),
			),
			'partial'      => array(
				'selector'            => '.base-color-palette-mobile-switcher',
				'container_inclusive' => true,
				'render_callback'     => 'BasePro\mobile_color_switcher',
			),
		),
		'mobile_dark_mode_switch_style' => array(
			'control_type' => 'base_select_control',
			'section'      => 'mobile_dark_mode',
			'priority'     => 11,
			'default'      => webapp()->default( 'mobile_dark_mode_switch_style' ),
			'label'        => esc_html__( 'Switch Style', 'templatemela-core' ),
			'input_attrs'  => array(
				'options' => array(
					'button' => array(
						'name' => __( 'Button', 'templatemela-core' ),
					),
					'switch' => array(
						'name' => __( 'Switch', 'templatemela-core' ),
					),
				),
			),
			'live_method'     => array(
				array(
					'type'     => 'class',
					'selector' => '.base-color-palette-mobile-switcher .base-color-palette-switcher',
					'pattern'  => 'kcps-style-$',
					'key'      => '',
				),
			),
		),
		'mobile_dark_mode_light_icon' => array(
			'control_type' => 'base_radio_icon_control',
			'section'      => 'mobile_dark_mode',
			'priority'     => 12,
			'default'      => webapp()->default( 'mobile_dark_mode_light_icon' ),
			'label'        => esc_html__( 'Light Mode Icon', 'templatemela-core' ),
			'input_attrs'  => array(
				'layout' => array(
					'sun' => array(
						'icon' => 'sun',
					),
					'sunAlt' => array(
						'icon' => 'sunAlt',
					),
					'sunrise' => array(
						'icon' => 'sunrise',
					),
				),
				'responsive' => false,
			),
			'partial'      => array(
				'selector'            => '.base-color-palette-mobile-switcher',
				'container_inclusive' => true,
				'render_callback'     => 'BasePro\mobile_color_switcher',
			),
		),
		'mobile_dark_mode_dark_icon' => array(
			'control_type' => 'base_radio_icon_control',
			'section'      => 'mobile_dark_mode',
			'priority'     => 12,
			'default'      => webapp()->default( 'mobile_dark_mode_dark_icon' ),
			'label'        => esc_html__( 'Dark Mode Icon', 'templatemela-core' ),
			'input_attrs'  => array(
				'layout' => array(
					'moon' => array(
						'icon' => 'moon',
					),
					'moonAlt' => array(
						'icon' => 'moonAlt',
					),
					'sunset' => array(
						'icon' => 'sunset',
					),
				),
				'responsive' => false,
			),
			'partial'      => array(
				'selector'            => '.base-color-palette-mobile-switcher',
				'container_inclusive' => true,
				'render_callback'     => 'BasePro\mobile_color_switcher',
			),
		),
		'mobile_dark_mode_icon_size' => array(
			'control_type' => 'base_range_control',
			'section'      => 'mobile_dark_mode',
			'priority'     => 12,
			'label'        => esc_html__( 'Icon Size', 'templatemela-core' ),
			'live_method'     => array(
				array(
					'type'     => 'css',
					'selector' => '.base-color-palette-mobile-switcher .base-color-palette-switcher button.base-color-palette-toggle .base-color-palette-icon',
					'property' => 'font-size',
					'pattern'  => '$',
					'key'      => 'size',
				),
			),
			'default'      => webapp()->default( 'mobile_dark_mode_icon_size' ),
			'input_attrs'  => array(
				'min'        => array(
					'px'  => 0,
					'em'  => 0,
					'rem' => 0,
				),
				'max'        => array(
					'px'  => 200,
					'em'  => 12,
					'rem' => 12,
				),
				'step'       => array(
					'px'  => 1,
					'em'  => 0.01,
					'rem' => 0.01,
				),
				'units'      => array( 'px', 'em', 'rem' ),
				'responsive' => true,
			),
		),
		'mobile_dark_mode_colors' => array(
			'control_type' => 'base_color_control',
			'section'      => 'mobile_dark_mode',
			'priority'     => 12,
			'label'        => esc_html__( 'Switch Colors', 'templatemela-core' ),
			'default'      => webapp()->default( 'mobile_dark_mode_colors' ),
			'live_method'     => array(
				array(
					'type'     => 'css',
					'selector' => '.base-color-palette-mobile-switcher',
					'property' => '--global-light-toggle-switch',
					'pattern'  => '$',
					'key'      => 'light',
				),
				array(
					'type'     => 'css',
					'selector' => '.base-color-palette-mobile-switcher',
					'property' => '--global-dark-toggle-switch',
					'pattern'  => '$',
					'key'      => 'dark',
				),
			),
			'input_attrs'  => array(
				'colors' => array(
					'light' => array(
						'tooltip' => __( 'Light Color', 'templatemela-core' ),
						'palette' => false,
					),
					'dark' => array(
						'tooltip' => __( 'Dark Color', 'templatemela-core' ),
						'palette' => false,
					),
				),
			),
		),
		'mobile_dark_mode_typography' => array(
			'control_type' => 'base_typography_control',
			'section'      => 'mobile_dark_mode',
			'priority'     => 12,
			'label'        => esc_html__( 'Text Label Font', 'templatemela-core' ),
			'default'      => webapp()->default( 'mobile_dark_mode_typography' ),
			'context'      => array(
				array(
					'setting'    => 'mobile_dark_mode_switch_type',
					'operator'   => '!=',
					'value'      => 'icon',
				),
			),
			'live_method'     => array(
				array(
					'type'     => 'css_typography',
					'selector' => '.base-color-palette-mobile-switcher .base-color-palette-switcher button.base-color-palette-toggle .base-color-palette-label',
					'pattern'  => array(
						'desktop' => '$',
						'tablet'  => '$',
						'mobile'  => '$',
					),
					'property' => 'font',
					'key'      => 'typography',
				),
			),
			'input_attrs'  => array(
				'id'      => 'mobile_dark_mode_typography',
				'options' => 'no-color',
			),
		),
		'mobile_dark_mode_light_switch_title' => array(
			'control_type' => 'base_text_control',
			'sanitize'     => 'sanitize_text_field',
			'section'      => 'mobile_dark_mode',
			'priority'     => 20,
			'label'        => esc_html__( 'Light Palette Title', 'templatemela-core' ),
			'default'      => webapp()->default( 'mobile_dark_mode_light_switch_title' ),
			'partial'      => array(
				'selector'            => '.base-color-palette-mobile-switcher',
				'container_inclusive' => true,
				'render_callback'     => 'BasePro\mobile_color_switcher',
			),
		),
		'mobile_dark_mode_dark_switch_title' => array(
			'control_type' => 'base_text_control',
			'sanitize'     => 'sanitize_text_field',
			'section'      => 'mobile_dark_mode',
			'priority'     => 20,
			'label'        => esc_html__( 'Dark Palette Title', 'templatemela-core' ),
			'default'      => webapp()->default( 'mobile_dark_mode_dark_switch_title' ),
			'partial'      => array(
				'selector'            => '.base-color-palette-mobile-switcher',
				'container_inclusive' => true,
				'render_callback'     => 'BasePro\mobile_color_switcher',
			),
		),
		'mobile_dark_mode_switch_margin' => array(
			'control_type' => 'base_measure_control',
			'section'      => 'mobile_dark_mode',
			'priority'     => 20,
			'default'      => webapp()->default( 'mobile_dark_mode_switch_margin' ),
			'label'        => esc_html__( 'Margin', 'templatemela-core' ),
			'live_method'     => array(
				array(
					'type'     => 'css',
					'selector' => '.base-color-palette-mobile-switcher .base-color-palette-switcher',
					'property' => 'margin',
					'pattern'  => '$',
					'key'      => 'measure',
				),
			),
			'input_attrs'  => array(
				'responsive' => false,
			),
		),
	)
);
