<?php
/**
 * Dark Mode Options.
 *
 * @package Base Pro
 */

namespace BasePro;

use Base\Theme_Customizer;
use function Base\webapp;
Theme_Customizer::add_settings(
	array(
		'dark_mode_learndash_enable' => array(
			'control_type' => 'base_switch_control',
			'section'      => 'sfwd_lesson_layout',
			'priority'     => 10,
			'default'      => webapp()->default( 'dark_mode_learndash_enable' ),
			'label'        => esc_html__( 'Enable Dark Mode Switch in LearnDash Focus Mode Header?', 'templatemela-core' ),
			'transport'    => 'refresh',
		),
		'dark_mode_learndash_lesson_only' => array(
			'control_type' => 'base_switch_control',
			'section'      => 'sfwd_lesson_layout',
			'priority'     => 10,
			'default'      => webapp()->default( 'dark_mode_learndash_lesson_only' ),
			'label'        => esc_html__( 'Only show dark mode in Lessons?', 'templatemela-core' ),
			'transport'    => 'refresh',
			'context'      => array(
				array(
					'setting'  => 'dark_mode_learndash_enable',
					'operator' => '=',
					'value'    => true,
				),
			),
		),
		'dark_mode_learndash_lesson_logo' => array(
			'control_type' => 'media',
			'section'      => 'sfwd_lesson_layout',
			'priority'     => 10,
			'transport'    => 'refresh',
			'mime_type'    => 'image',
			'default'      => '',
			'label'        => esc_html__( 'LearnDash Focus Mode Dark Mode Logo', 'templatemela-core' ),
			'context'      => array(
				array(
					'setting'  => 'dark_mode_learndash_enable',
					'operator' => '=',
					'value'    => true,
				),
			),
		),
	)
);

