<?php
/**
 * Header Builder Options
 *
 * @package Base
 */

 namespace TemplateMela;

use Base\Theme_Customizer;
use function Base\webapp;

$settings = array(
	'header_wishlist_tabs' => array(
		'control_type' => 'base_tab_control',
		'section'      => 'wishlist',
		'settings'     => false,
		'priority'     => 1,
		'input_attrs'  => array(
			'general' => array(
				'label'  => __( 'General', 'avanam' ),
				'target' => 'wishlist',
			),
			'design' => array(
				'label'  => __( 'Design', 'avanam' ),
				'target' => 'wishlist_design',
			),
			'active' => 'general',
		),
	),
	'header_wishlist_tabs_design' => array(
		'control_type' => 'base_tab_control',
		'section'      => 'wishlist_design',
		'settings'     => false,
		'priority'     => 1,
		'input_attrs'  => array(
			'general' => array(
				'label'  => __( 'General', 'avanam' ),
				'target' => 'wishlist',
			),
			'design' => array(
				'label'  => __( 'Design', 'avanam' ),
				'target' => 'wishlist_design',
			),
			'active' => 'design',
		),
	),
	'header_wishlist_title' => array(
		'control_type' => 'base_text_control',
		'section'      => 'wishlist',
		'sanitize'     => 'sanitize_text_field',
		'priority'     => 6,
		'default'      => webapp()->default( 'header_wishlist_title' ),
		'label'        => esc_html__( 'Wishlist Title', 'avanam' ),
		'live_method'     => array(
			array(
				'type'     => 'html',
				'selector' => '.header-mobile-wishlist-wrap .header-wishlist-title',
				'pattern'  => '$',
				'key'      => '',
			),
		),
	),
	'header_wishlist_label' => array(
		'control_type' => 'base_text_control',
		'section'      => 'wishlist',
		'sanitize'     => 'sanitize_text_field',
		'priority'     => 6,
		'default'      => webapp()->default( 'header_wishlist_label' ),
		'label'        => esc_html__( 'Wishlist Label', 'avanam' ),
		'live_method'     => array(
			array(
				'type'     => 'html',
				'selector' => '.header-mobile-wishlist-wrap .header-wishlist-label',
				'pattern'  => '$',
				'key'      => '',
			),
		),
	),
	'header_wishlist_show_total' => array(
		'control_type' => 'base_switch_control',
		'sanitize'     => 'base_sanitize_toggle',
		'section'      => 'wishlist',
		'priority'     => 6,
		'partial'      => array(
			'selector'            => '.header-wishlist-wrap',
			'container_inclusive' => true,
			'render_callback'     => 'TemplateMela\header_wishlist',
		),
		'default'      => webapp()->default( 'header_wishlist_show_total' ),
		'label'        => esc_html__( 'Show Item Total Indicator', 'avanam' ),
	),
	'header_wishlist_icon_size' => array(
		'control_type' => 'base_range_control',
		'section'      => 'wishlist_design',
		'label'        => esc_html__( 'Icon Size', 'avanam' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.header-wishlist-wrap .base-svg-iconset',
				'property' => 'font-size',
				'pattern'  => '$',
				'key'      => 'size',
			),
		),
		'default'      => webapp()->default( 'header_wishlist_icon_size' ),
		'input_attrs'  => array(
			'min'        => array(
				'px'  => 0,
				'em'  => 0,
				'rem' => 0,
			),
			'max'        => array(
				'px'  => 100,
				'em'  => 12,
				'rem' => 12,
			),
			'step'       => array(
				'px'  => 1,
				'em'  => 0.01,
				'rem' => 0.01,
			),
			'units'      => array( 'px', 'em', 'rem' ),
			'responsive' => true,
		),
	),
	'header_wishlist_color' => array(
		'control_type' => 'base_color_control',
		'section'      => 'wishlist_design',
		'label'        => esc_html__( 'Wishlist Colors', 'avanam' ),
		'default'      => webapp()->default( 'header_wishlist_color' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.site-header-item .header-wishlist-wrap .header-wishlist-inner-wrap',
				'property' => 'color',
				'pattern'  => '$',
				'key'      => 'color',
			),
			array(
				'type'     => 'css',
				'selector' => '.site-header-item .header-wishlist-wrap .header-wishlist-inner-wrap',
				'property' => 'color',
				'pattern'  => '$',
				'key'      => 'hover',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Color', 'avanam' ),
					'palette' => true,
				),
				'hover' => array(
					'tooltip' => __( 'Hover Color', 'avanam' ),
					'palette' => true,
				),
			),
		),
	),
	'header_wishlist_background' => array(
		'control_type' => 'base_color_control',
		'section'      => 'wishlist_design',
		'label'        => esc_html__( 'Wishlist Background', 'avanam' ),
		'default'      => webapp()->default( 'header_wishlist_background' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.site-header-item .header-wishlist-wrap .header-wishlist-inner-wrap',
				'property' => 'background',
				'pattern'  => '$',
				'key'      => 'color',
			),
			array(
				'type'     => 'css',
				'selector' => '.site-header-item .header-wishlist-wrap .header-wishlist-inner-wrap',
				'property' => 'background',
				'pattern'  => '$',
				'key'      => 'hover',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Background', 'avanam' ),
					'palette' => true,
				),
				'hover' => array(
					'tooltip' => __( 'Hover Background', 'avanam' ),
					'palette' => true,
				),
			),
		),
	),
	'header_wishlist_total_color' => array(
		'control_type' => 'base_color_control',
		'section'      => 'wishlist_design',
		'label'        => esc_html__( 'Wishlist Total Colors', 'avanam' ),
		'default'      => webapp()->default( 'header_wishlist_total_color' ),
		'context'      => array(
			array(
				'setting'  => 'header_wishlist_show_total',
				'operator' => '=',
				'value'    => true,
			),
		),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.header-wishlist-wrap .header-wishlist-total',
				'property' => 'color',
				'pattern'  => '$',
				'key'      => 'color',
			),
			array(
				'type'     => 'css',
				'selector' => '.header-wishlist-wrap .header-wishlist-total',
				'property' => 'color',
				'pattern'  => '$',
				'key'      => 'hover',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Color', 'avanam' ),
					'palette' => true,
				),
				'hover' => array(
					'tooltip' => __( 'Hover Color', 'avanam' ),
					'palette' => true,
				),
			),
		),
	),
	'header_wishlist_total_background' => array(
		'control_type' => 'base_color_control',
		'section'      => 'wishlist_design',
		'label'        => esc_html__( 'Wishlist Total Background', 'avanam' ),
		'default'      => webapp()->default( 'header_wishlist_total_background' ),
		'context'      => array(
			array(
				'setting'  => 'header_wishlist_show_total',
				'operator' => '=',
				'value'    => true,
			),
		),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.header-wishlist-wrap .header-wishlist-total',
				'property' => 'background',
				'pattern'  => '$',
				'key'      => 'color',
			),
			array(
				'type'     => 'css',
				'selector' => '.header-wishlist-wrap .header-wishlist-total',
				'property' => 'background',
				'pattern'  => '$',
				'key'      => 'hover',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Background', 'avanam' ),
					'palette' => true,
				),
				'hover' => array(
					'tooltip' => __( 'Hover Background', 'avanam' ),
					'palette' => true,
				),
			),
		),
	),
	'header_wishlist_title_typography' => array(
		'control_type' => 'base_typography_control',
		'section'      => 'wishlist_design',
		'label'        => esc_html__( 'Wishlist Title Font', 'avanam' ),
		'context'      => array(
			array(
				'setting'  => 'header_wishlist_title',
				'operator' => '!empty',
				'value'    => '',
			),
		),
		'default'      => webapp()->default( 'header_wishlist_title_typography' ),
		'live_method'     => array(
			array(
				'type'     => 'css_typography',
				'selector' => '.header-wishlist-wrap .header-wishlist-title',
				'pattern'  => array(
					'desktop' => '$',
					'tablet'  => '$',
					'mobile'  => '$',
				),
				'property' => 'font',
				'key'      => 'typography',
			),
		),
		'input_attrs'  => array(
			'id'      => 'header_wishlist_title_typography',
			'options' => 'no-color',
		),
	),
	'header_wishlist_title_color' => array(
		'control_type' => 'base_color_control',
		'section'      => 'wishlist_design',
		'label'        => esc_html__( 'Wishlist Title Color', 'avanam' ),
		'default'      => webapp()->default( 'header_wishlist_title_color' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.header-wishlist-wrap .header-wishlist-title',
				'property' => 'color',
				'pattern'  => '$',
				'key'      => 'color',
			),
			array(
				'type'     => 'css',
				'selector' => '.header-wishlist-wrap .header-wishlist-title',
				'property' => 'color',
				'pattern'  => '$',
				'key'      => 'hover',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Color', 'avanam' ),
					'palette' => true,
				),
				'hover' => array(
					'tooltip' => __( 'Hover Color', 'avanam' ),
					'palette' => true,
				),
			),
		),
	),
	'header_wishlist_label_typography' => array(
		'control_type' => 'base_typography_control',
		'section'      => 'wishlist_design',
		'label'        => esc_html__( 'Wishlist Label Font', 'avanam' ),
		'context'      => array(
			array(
				'setting'  => 'header_wishlist_label',
				'operator' => '!empty',
				'value'    => '',
			),
		),
		'default'      => webapp()->default( 'header_wishlist_label_typography' ),
		'live_method'     => array(
			array(
				'type'     => 'css_typography',
				'selector' => '.header-wishlist-wrap .header-wishlist-label',
				'pattern'  => array(
					'desktop' => '$',
					'tablet'  => '$',
					'mobile'  => '$',
				),
				'property' => 'font',
				'key'      => 'typography',
			),
		),
		'input_attrs'  => array(
			'id'      => 'header_wishlist_label_typography',
			'options' => 'no-color',
		),
	),
	'header_wishlist_label_color' => array(
		'control_type' => 'base_color_control',
		'section'      => 'wishlist_design',
		'label'        => esc_html__( 'Wishlist Label Color', 'avanam' ),
		'default'      => webapp()->default( 'header_wishlist_label_color' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.header-wishlist-wrap .header-wishlist-label',
				'property' => 'color',
				'pattern'  => '$',
				'key'      => 'color',
			),
			array(
				'type'     => 'css',
				'selector' => '.header-wishlist-wrap .header-wishlist-label',
				'property' => 'color',
				'pattern'  => '$',
				'key'      => 'hover',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Color', 'avanam' ),
					'palette' => true,
				),
				'hover' => array(
					'tooltip' => __( 'Hover Color', 'avanam' ),
					'palette' => true,
				),
			),
		),
	),
	'header_wishlist_padding' => array(
		'control_type' => 'base_measure_control',
		'section'      => 'wishlist_design',
		'priority'     => 10,
		'default'      => webapp()->default( 'header_wishlist_padding' ),
		'label'        => esc_html__( 'Wishlist Padding', 'avanam' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.site-header-item .header-wishlist-wrap .header-wishlist-inner-wrap',
				'property' => 'padding',
				'pattern'  => '$',
				'key'      => 'measure',
			),
		),
		'input_attrs'  => array(
			'responsive' => false,
		),
	),
	'header_wishlist_popup_side' => array(
		'control_type' => 'base_radio_icon_control',
		'section'      => 'wishlist',
		'priority'     => 20,
		'default'      => webapp()->default( 'header_wishlist_popup_side' ),
		'label'        => esc_html__( 'Slide-Out Side', 'avanam' ),
		'context'      => array(
			array(
				'setting'    => 'header_wishlist_style',
				'operator'   => '=',
				'value'      => 'slide',
			),
		),
		'live_method'     => array(
			array(
				'type'     => 'class',
				'selector' => '#wishlist-drawer',
				'pattern'  => 'popup-drawer-side-$',
				'key'      => '',
			),
		),
		'input_attrs'  => array(
			'layout' => array(
				'left' => array(
					'tooltip' => __( 'Reveal from Left', 'avanam' ),
					'name'    => __( 'Left', 'avanam' ),
					'icon'    => '',
				),
				'right' => array(
					'tooltip' => __( 'Reveal from Right', 'avanam' ),
					'name'    => __( 'Right', 'avanam' ),
					'icon'    => '',
				),
			),
			'responsive' => false,
		),
	),
);
Theme_Customizer::add_settings( $settings );
