<?php
/**
 * Class for the Customizer
 *
 * @package Base
 */

namespace BasePro;

use function Base\webapp;
use Base\Base_CSS;
use WP_Query;
/**
 * Main plugin class
 */
class Additional_Addons {
	/**
	 * Instance Control
	 *
	 * @var null
	 */
	private static $instance = null;

	/**
	 * Associative array of Google Fonts to load.
	 *
	 * Do not access this property directly, instead use the `get_google_fonts()` method.
	 *
	 * @var array
	 */
	protected static $google_fonts = array();

	/**
	 * Holds theme settings array sections.
	 *
	 * @var the theme settings sections.
	 */
	public static $settings_sections = array(
		'header-vertical-navigation',
		'header-search-advanced',
		'footer-widget7',
		'footer-widget8',
		'footer-widget9',
		'header-wishlist',
		// 'header-html3',
		// 'header-mobile-html3',
		// 'header-button3',
		// 'header-mobile-button3',
	);

	/**
	 * Instance Control.
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Throw error on object clone.
	 *
	 * The whole idea of the singleton design pattern is that there is a single
	 * object therefore, we don't want the object to be cloned.
	 *
	 * @return void
	 */
	public function __clone() {
		// Cloning instances of the class is forbidden.
		_doing_it_wrong( __FUNCTION__, esc_html__( 'Cloning instances of the class is Forbidden', 'templatemela-core' ), '1.0' );
	}

	/**
	 * Disable un-serializing of the class.
	 *
	 * @return void
	 */
	public function __wakeup() {
		// Unserializing instances of the class is forbidden.
		_doing_it_wrong( __FUNCTION__, esc_html__( 'Unserializing instances of the class is forbidden', 'templatemela-core' ), '1.0' );
	}

	/**
	 * Constructor function.
	 */
	public function __construct() {
		add_filter( 'base_theme_options_defaults', array( $this, 'add_option_defaults' ), 10 );
		add_filter( 'base_theme_customizer_sections', array( $this, 'add_customizer_sections' ), 10 );
		add_filter( 'base_theme_customizer_control_choices', array( $this, 'add_customizer_item_choices' ), 10 );
		add_action( 'customize_register', array( $this, 'create_pro_settings_array' ), 1 );
		add_action( 'wp_enqueue_scripts', array( $this, 'action_vertical_menu_enqueue_scripts' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'action_search_advanced_enqueue_scripts' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'action_header_wishlist_options_enqueue_scripts' ) );
		add_action( 'wp_footer', array( $this, 'trigger_ajax_search_results_on_type' ) );
		add_action( 'get_template_part_template-parts/header/vertical-menu', array( $this, 'header_vertical_navigation_output' ), 10 );
		add_action( 'get_template_part_template-parts/header/search-advanced', array( $this, 'header_search_advanced_output' ), 10 );
		add_action( 'get_template_part_template-parts/header/wishlist', array( $this, 'header_wishlist_output' ), 10 );
		add_action( 'get_template_part_template-parts/footer/footer-widget7', array( $this, 'footer_widget7_output' ), 10 );
		add_action( 'get_template_part_template-parts/footer/footer-widget8', array( $this, 'footer_widget8_output' ), 10 );
		add_action( 'get_template_part_template-parts/footer/footer-widget9', array( $this, 'footer_widget9_output' ), 10 );
		add_action( 'after_setup_theme', array( $this, 'load_actions' ), 20 );
		add_action( 'after_setup_theme', array( $this, 'action_register_nav_menus' ), 20 );
		add_filter( 'base_dynamic_css', array( $this, 'dynamic_css' ), 20 );
		add_action('wp_ajax_search_data_fetch' , array( $this, 'search_data_fetch') );
		add_action('wp_ajax_nopriv_search_data_fetch',array( $this, 'search_data_fetch') );

		add_action( 'widgets_init', array( $this, 'action_register_sidebars' ) );
	}
	
	
	/**
	 * Generates the dynamic css based on customizer options.
	 *
	 * @param string $css any custom css.
	 * @return string
	 */
	public function dynamic_css( $css ) {
		$generated_css = $this->generate_pro_additional_css();
		if ( ! empty( $generated_css ) ) {
			$css .= "\n/* TemplateMela Core More CSS */\n" . $generated_css;
		}
		return $css;
	}
	/**
	 * Generates the dynamic css based on page options.
	 *
	 * @return string
	 */
	public function generate_pro_additional_css() {
		$css                    = new Base_CSS();
		$media_query            = array();
		$media_query['mobile']  = apply_filters( 'base_mobile_media_query', '(max-width: 767px)' );
		$media_query['tablet']  = apply_filters( 'base_tablet_media_query', '(max-width: 1024px)' );
		$media_query['desktop'] = apply_filters( 'base_tablet_media_query', '(min-width: 1025px)' );
		
		// Vertical Navigation.
		$css->set_selector( '.vertical-navigation .vertical-navigation-header' );
		$css->add_property( 'padding-left', $css->render_half_size( webapp()->option( 'vertical_heading_spacing' ) ) );
		$css->add_property( 'padding-right', $css->render_half_size( webapp()->option( 'vertical_heading_spacing' ) ) );
		$css->add_property( 'padding-top', webapp()->sub_option( 'vertical_heading_vertical_spacing', 'size' ) . webapp()->sub_option( 'vertical_heading_vertical_spacing', 'unit' ) );
		$css->add_property( 'padding-bottom', webapp()->sub_option( 'vertical_heading_vertical_spacing', 'size' ) . webapp()->sub_option( 'vertical_heading_vertical_spacing', 'unit' ) );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'vertical_heading_color', 'color' ) ) );
		$css->add_property( 'background', $css->render_color( webapp()->sub_option( 'vertical_heading_background', 'color' ) ) );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'vertical_heading_color', 'hover' ) ) );
		$css->add_property( 'background', $css->render_color( webapp()->sub_option( 'vertical_heading_background', 'hover' ) ) );

		$css->set_selector( '.vertical-navigation .vertical-navigation-header .base-svg-iconset' );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'vertical_heading_icon_color', 'color' ) ) );
		$css->add_property( 'background', $css->render_color( webapp()->sub_option( 'vertical_heading_icon_background', 'color' ) ) );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'vertical_heading_icon_color', 'hover' ) ) );
		$css->add_property( 'background', $css->render_color( webapp()->sub_option( 'vertical_heading_icon_background', 'hover' ) ) );
		$css->add_property( 'padding', $css->render_half_size( webapp()->option( 'vertical_heading_icon_padding' ) ) );
		$css->add_property( 'font-size', webapp()->sub_option( 'vertical_heading_icon_size', 'size' ) . webapp()->sub_option( 'vertical_heading_icon_size', 'unit' ) );

		$css->set_selector( '.vertical-navigation .vertical-menu-container > ul > li.menu-item > a' );
		$css->add_property( 'padding-left', $css->render_half_size( webapp()->option( 'vertical_navigation_spacing' ) ) );
		$css->add_property( 'padding-right', $css->render_half_size( webapp()->option( 'vertical_navigation_spacing' ) ) );
		$css->add_property( 'padding-top', webapp()->sub_option( 'vertical_navigation_vertical_spacing', 'size' ) . webapp()->sub_option( 'vertical_navigation_vertical_spacing', 'unit' ) );
		$css->add_property( 'padding-bottom', webapp()->sub_option( 'vertical_navigation_vertical_spacing', 'size' ) . webapp()->sub_option( 'vertical_navigation_vertical_spacing', 'unit' ) );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'vertical_navigation_color', 'color' ) ) );
		$css->add_property( 'background', $css->render_color( webapp()->sub_option( 'vertical_navigation_background', 'color' ) ) );
		$css->render_font( webapp()->option( 'vertical_navigation_typography' ), $css );
		$css->set_selector( '.vertical-navigation .vertical-menu-container > ul > li.menu-item > a:hover' );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'vertical_navigation_color', 'hover' ) ) );
		$css->add_property( 'background', $css->render_color( webapp()->sub_option( 'vertical_navigation_background', 'hover' ) ) );
		$css->set_selector( '.vertical-navigation .vertical-menu-container > ul.menu' );
		$css->add_property( 'border', $css->render_border( webapp()->option( 'vertical_navigation_border' ) ) );
		$css->set_selector( '.vertical-navigation .vertical-menu-container > ul.menu > li.menu-item' );
		$css->add_property( 'border-bottom', $css->render_border( webapp()->option( 'vertical_navigation_item_border' ) ) );
		$css->set_selector( '.vertical-navigation .vertical-menu-container > ul > li.menu-item.current-menu-item > a' );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'vertical_navigation_color', 'active' ) ) );
		$css->add_property( 'background', $css->render_color( webapp()->sub_option( 'vertical_navigation_background', 'active' ) ) );

		// Header Wishlist.
		$css->set_selector( '.site-header-item .header-wishlist-wrap .header-wishlist-inner-wrap .header-wishlist-button' );
		$css->add_property( 'background', $css->render_color( webapp()->sub_option( 'header_wishlist_background', 'color' ) ) );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'header_wishlist_color', 'color' ) ) );
		$css->add_property( 'padding', $css->render_measure( webapp()->option( 'header_wishlist_padding' ) ) );
		$css->set_selector( '.header-wishlist-wrap .header-wishlist-button .header-wishlist-total' );
		$css->add_property( 'background', $css->render_color( webapp()->sub_option( 'header_wishlist_total_background', 'color' ) ) );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'header_wishlist_total_color', 'color' ) ) );
		$css->set_selector( '.site-header-item .header-wishlist-wrap .header-wishlist-inner-wrap .header-wishlist-button:hover' );
		$css->add_property( 'background', $css->render_color( webapp()->sub_option( 'header_wishlist_background', 'hover' ) ) );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'header_wishlist_color', 'hover' ) ) );
		$css->set_selector( '.header-wishlist-wrap .header-wishlist-button:hover .header-wishlist-total' );
		$css->add_property( 'background', $css->render_color( webapp()->sub_option( 'header_wishlist_total_background', 'hover' ) ) );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'header_wishlist_total_color', 'hover' ) ) );
		$css->set_selector( '.header-wishlist-wrap .header-wishlist-button .header-wishlist-label' );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'header_wishlist_label_color', 'color' ) ) );
		$css->render_font( webapp()->option( 'header_wishlist_label_typography' ), $css );
		if ( ! empty( webapp()->sub_option( 'header_wishlist_icon_size', 'size' ) ) ) {
			$css->set_selector( '.header-wishlist-wrap .header-wishlist-button .base-svg-iconset' );
			$css->add_property( 'font-size', $css->render_range( webapp()->sub_option( 'header_wishlist_icon_size' ), 'desktop' ) );
			$css->start_media_query( $media_query['tablet'] );
			$css->set_selector( '.header-wishlist-wrap .header-wishlist-button .base-svg-iconset' );
			$css->add_property( 'font-size', $css->render_range( webapp()->sub_option( 'header_wishlist_icon_size' ), 'tablet' ) );
			$css->stop_media_query();
			$css->start_media_query( $media_query['mobile'] );
			$css->set_selector( '.header-wishlist-wrap .header-wishlist-button .base-svg-iconset' );
			$css->add_property( 'font-size', $css->render_range( webapp()->sub_option( 'header_wishlist_icon_size' ), 'mobile' ) );
			$css->stop_media_query();
		}
		$css->set_selector( '.header-wishlist-wrap .header-wishlist-button:hover .header-wishlist-label' );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'header_wishlist_label_color', 'hover' ) ) );
		$css->set_selector( '.header-wishlist-wrap .header-wishlist-button .header-wishlist-title' );
		$css->render_font( webapp()->option( 'header_wishlist_title_typography' ), $css );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'header_wishlist_title_color', 'color' ) ) );
		$css->set_selector( '.header-wishlist-wrap .header-wishlist-button:hover .header-wishlist-title' );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'header_wishlist_title_color', 'hover' ) ) );

		// Header Search Advanced.
		$css->set_selector( '.header-item-search-advanced form ::-webkit-input-placeholder' );
		$css->add_property( 'color', 'currentColor' );
		$css->add_property( 'opacity', '0.5' );
		$css->set_selector( '.header-item-search-advanced form ::placeholder' );
		$css->add_property( 'color', 'currentColor' );
		$css->add_property( 'opacity', '0.5' );
		$css->set_selector( '.header-search-advanced form.search-form' );
		$css->add_property( 'max-width', '100%' );
		$css->add_property( 'width', $css->render_range( webapp()->sub_option( 'header_search_advanced_width' ), 'desktop' ) );
		$css->start_media_query( $media_query['tablet'] );
		$css->set_selector( '.header-search-advanced form.search-form' );
		$css->add_property( 'width', $css->render_range( webapp()->sub_option( 'header_search_advanced_width' ), 'tablet' ) );
		$css->stop_media_query();
		$css->start_media_query( $media_query['mobile'] );
		$css->set_selector( '.header-search-advanced form.search-form' );
		$css->add_property( 'width', $css->render_range( webapp()->sub_option( 'header_search_advanced_width' ), 'mobile' ) );
		$css->stop_media_query();

		// Search-Box Margin
		$css->set_selector( '.header-search-advanced' );
		$css->add_property( 'margin', $css->render_measure( webapp()->option( 'header_search_advanced_margin' ) ) );

		// Search-Box
		$css->set_selector( '.header-search-advanced form.search-form' );
		$css->add_property( 'background', $css->render_color( webapp()->sub_option( 'header_search_advanced_background', 'color' ) ) );
		$css->add_property( 'border', $css->render_border( webapp()->option( 'header_search_advanced_border' ) ) );
		$css->add_property( 'border-color', $css->render_color( webapp()->sub_option( 'header_search_advanced_border_color', 'color' ) ) );
		$css->add_property( 'border-radius', $css->render_measure( webapp()->option( 'header_search_advanced_border_radius' ) ) );

		// Search Button
		$css->set_selector( '.header-search-advanced form.search-form .search-submit' );
		$css->add_property( 'background', $css->render_color( webapp()->sub_option( 'header_search_advanced_buttons_background', 'color' ) ) );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'header_search_advanced_buttons_color', 'color' ) ) );
		$css->render_font( webapp()->option( 'header_search_advanced_button_typography' ), $css );
		$css->add_property( 'padding', $css->render_measure( webapp()->option( 'header_search_advanced_button_padding' ) ) );
		$css->add_property( 'border-radius', $css->render_measure( webapp()->option( 'header_search_advanced_button_radius' ) ) );
		// Search Button Hover
		$css->set_selector( '.header-search-advanced form.search-form .search-submit:hover,.header-search-advanced form.search-form .search-submit:focus' );
		$css->add_property( 'background', $css->render_color( webapp()->sub_option( 'header_search_advanced_buttons_background', 'hover' ) ) );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'header_search_advanced_buttons_color', 'hover' ) ) );

		// Search Input Box
		$css->set_selector( '.header-search-advanced form.search-form input.search-field' );
		$css->render_font( webapp()->option( 'header_search_advanced_typography' ), $css );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'header_search_advanced_color', 'color' ) ) );
		$css->add_property( 'padding', $css->render_measure( webapp()->option( 'header_search_advanced_input_padding' ) ) );
		$css->set_selector( '.header-search-advanced form.search-form input.search-field:focus' );
		// $css->add_property( 'background', $css->render_color( webapp()->sub_option( 'header_search_advanced_background', 'hover' ) ) );
		// $css->add_property( 'border-color', $css->render_color( webapp()->sub_option( 'header_search_advanced_border_color', 'hover' ) ) );
		$css->set_selector( '.header-search-advanced form.search-form input.search-field:focus' );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'header_search_advanced_color', 'hover' ) ) );

		$css->set_selector( '.transparent-header .header-search-advanced form.search-form input.search-field' );
		// $css->add_property( 'background', $css->render_color( webapp()->sub_option( 'transparent_header_search_advanced_background', 'color' ) ) );
		// $css->add_property( 'border-color', $css->render_color( webapp()->sub_option( 'transparent_header_search_advanced_border', 'color' ) ) );
		$css->set_selector( '.transparent-header .header-search-advanced form.search-form input.search-field, .transparent-header .header-search-advanced form.search-form .base-search-icon-wrap' );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'transparent_header_search_advanced_color', 'color' ) ) );
		$css->set_selector( '.transparent-header .header-search-advanced form.search-form input.search-field:focus' );
		// $css->add_property( 'background', $css->render_color( webapp()->sub_option( 'transparent_header_search_advanced_background', 'hover' ) ) );
		// $css->add_property( 'border-color', $css->render_color( webapp()->sub_option( 'transparent_header_search_advanced_border', 'hover' ) ) );
		$css->set_selector( '.transparent-header .header-search-advanced form.search-form input.search-field:focus, .transparent-header .header-search-advanced form.search-form input.search-submit:hover ~ .base-search-icon-wrap, .transparent-header #main-header .header-search-advanced form.search-form button[type="submit"]:hover ~ .base-search-icon-wrap' );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'transparent_header_search_advanced_color', 'hover' ) ) );

		$css->set_selector( '.header-search-advanced form.search-form .search-category-field .search-select' );
		$css->add_property( 'background-color', $css->render_color( webapp()->sub_option( 'header_search_advanced_category_background', 'color' ) ) );
		$css->add_property( 'color', $css->render_color( webapp()->sub_option( 'header_search_advanced_category_color', 'color' ) ) );
		$css->render_font( webapp()->option( 'header_search_advanced_category_typography' ), $css );
 
	
		return $css->css_output();
	}
	/**
	 * Generates the size output.
	 *
	 * @param array $size an array of size settings.
	 * @return string
	 */
	public function render_negative_half_size( $size ) {
		if ( empty( $size ) ) {
			return false;
		}
		if ( ! is_array( $size ) ) {
			return false;
		}
		$size_number = ( isset( $size['size'] ) && ! empty( $size['size'] ) ? $size['size'] : '0' );
		$size_unit   = ( isset( $size['unit'] ) && ! empty( $size['unit'] ) ? $size['unit'] : 'em' );

		$size_string = 'calc(-' . $size_number . $size_unit . ' / 2)';
		return $size_string;
	}
	/**
	 * Generates the size output.
	 *
	 * @param array $size an array of size settings.
	 * @return string
	 */
	public function render_negative_size( $size ) {
		if ( empty( $size ) ) {
			return false;
		}
		if ( ! is_array( $size ) ) {
			return false;
		}
		$size_number = ( isset( $size['size'] ) && ! empty( $size['size'] ) ? $size['size'] : '0' );
		$size_unit   = ( isset( $size['unit'] ) && ! empty( $size['unit'] ) ? $size['unit'] : 'em' );

		$size_string = '-' . $size_number . $size_unit;
		return $size_string;
	}
	/**
	 * Registers the navigation menus.
	 */
	public function action_register_nav_menus() {
		register_nav_menus(
			array(
				'vertical'         => esc_html__( 'Vertical', 'templatemela-core' ),
			)
		);
	}
	/**
	 * Get header html2 template.
	 */
	public function load_actions() {
		require_once TMCORE_PATH . '/includes/addons/additional/hooks.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
	}
	
	/**
	 * Get header search advanced template.
	 */
	public function header_search_advanced_output() {
		$this->locate_output_template( 'search-advanced.php' );
	}
	/**
	 * Get header vertical-menu template.
	 */
	public function header_vertical_navigation_output() {
		$this->locate_output_template( 'vertical-menu.php' );
	}

	/**
	 * Get header search advanced template.
	 */
	public function header_wishlist_output() {
		$this->locate_output_template( 'wishlist.php' );
	}

	/**
	 * Get footer widget 7 template.
	 */
	public function footer_widget7_output() {
		$this->locate_output_template( 'footer-widget7.php' );
	}
	/**
	 * Get footer widget 8 template.
	 */
	public function footer_widget8_output() {
		$this->locate_output_template( 'footer-widget8.php' );
	}
	/**
	 * Get footer widget 8 template.
	 */
	public function footer_widget9_output() {
		$this->locate_output_template( 'footer-widget9.php' );
	}
	
	/**
	 * Output template.
	 *
	 * @param string $template_name the name of the template.
	 */
	public function locate_output_template( $template_name ) {
		$template_path = 'templatemela/';
		$default_path  = TMCORE_PATH . '/includes/addons/additional/templates/';

		// Look within passed path within the theme - this is priority.
		$template = locate_template(
			array(
				trailingslashit( $template_path ) . $template_name,
				$template_name,
			)
		);
		// Get default template/.
		if ( ! $template ) {
			$template = $default_path . $template_name;
		}

		// Allow 3rd party plugin filter template file from their plugin.
		$filter_template = apply_filters( 'templatemela_get_template', $template, $template_name, $template_path, $default_path );

		if ( $filter_template !== $template ) {
			if ( ! file_exists( $filter_template ) ) {
				return;
			}
			$template = $filter_template;
		}

		include $template;
	}
	/**
	 * Add Defaults
	 *
	 * @access public
	 * @param array $defaults registered option defaults with base theme.
	 * @return array
	 */
	public function add_option_defaults( $defaults ) {
		$more_addons = array(
			// Vertical Navigation.
			'vertical_heading_spacing'          => array(
				'size' => 1.2,
				'unit' => 'em',
			),
			'vertical_heading_vertical_spacing' => array(
				'size' => 0.6,
				'unit' => 'em',
			),
			'vertical_heading_color'            => array(
				'color'  => 'palette3',
				'hover'  => 'palette3',
				'active' => 'palette3',
			),
			'vertical_heading_background'       => array(
				'color'  => '',
				'hover'  => '',
				'active' => '',
			),
			'vertical_navigation_typography'        => array(
				'size' => array(
					'desktop' => '',
				),
				'lineHeight' => array(
					'desktop' => '',
				),
				'family'  => 'inherit',
				'google'  => false,
				'weight'  => '',
				'variant' => '',
			),
			'vertical_navigation_spacing'          => array(
				'size' => 1.2,
				'unit' => 'em',
			),
			'vertical_navigation_vertical_spacing' => array(
				'size' => 0.6,
				'unit' => 'em',
			),
			// Icon
			'vertical_heading_icon_background'       => array(
				'color'  => '',
				'hover'  => '',
				'active' => '',
			),
			'vertical_heading_icon_color'            => array(
				'color'  => '',
				'hover'  => '',
				'active' => '',
			),
			'vertical_heading_icon_padding'          => array(
				'size' => '',
				'unit' => 'em',
			),
			'vertical_heading_icon_size'               => array(
				'size' => '',
				'unit' => 'em',
			),
			'vertical_navigation_opened'           => false,
			//'vertical_navigation_style'            => 'standard',
			'vertical_navigation_color'            => array(
				'color'  => 'palette5',
				'hover'  => 'palette-highlight',
				'active' => 'palette3',
			),
			'vertical_navigation_background'       => array(
				'color'  => '',
				'hover'  => '',
				'active' => '',
			),
			'vertical_navigation_border' => array(
				'width' => 0,
				'unit'  => 'px',
				'style' => 'solid',
				'color' => 'palette1',
			),
			'vertical_navigation_item_border' => array(
				'width' => 1,
				'unit'  => 'px',
				'style' => 'solid',
				'color' => 'palette7',
			),
			// Header Search Advanced.
			'header_search_advanced_woo' => true,
			'header_search_advanced_categories' => true,
			'header_search_advanced_categories_label' => esc_html__( 'All Categories', 'templatemela-core' ),
			'header_search_advanced_label_visiblity' => array(
				'desktop' => true,
				'tablet'  => true,
				'mobile'  => false,
			),
			'header_search_advanced_label' => '',
			'header_search_advanced_width' => array(
				'size' => array(
					'mobile'  => 290,
					'tablet'  => '',
					'desktop' => 450,
				),
				'unit' => array(
					'mobile'  => 'px',
					'tablet'  => 'px',
					'desktop' => 'px',
				),
			),
			'header_search_advanced_icon'   => 'search2',
			// Search-Box
			'header_search_advanced_border' => array(
				'width' => '',
				'unit'  => '',
				'style' => '',
			),
			'header_search_advanced_border_color'       => array(
				'color'  => '',
			),
			'header_search_advanced_border_radius' => array(
				'size'   => array( '', '', '', '' ),
				'unit'   => 'px',
				'locked' => true,
			),
			'header_search_advanced_margin' => array(
				'size'   => array( '', '', '', '' ),
				'unit'   => 'px',
				'locked' => false,
			), 
			// Category-Box
			'header_search_advanced_category_background' => array(
				'color'  => '',
				'hover'  => '',
			),
			'header_search_advanced_category_color' => array(
				'color'  => '',
				'hover'  => '',
			),
			'header_search_advanced_category_typography' => array(
				'size' => array(
					'desktop' => '',
				),
				'lineHeight' => array(
					'desktop' => '',
				),
				'family'  => 'inherit',
				'google'  => false,
				'weight'  => '',
				'variant' => '',
			),
			// Input
			'header_search_advanced_background'       => array(
				'color'  => '',
			),
			'header_search_advanced_color'       => array(
				'color'  => '',
				'hover'  => '',
			),
			'header_search_advanced_typography'        => array(
				'size' => array(
					'desktop' => '',
				),
				'lineHeight' => array(
					'desktop' => '',
				),
				'family'  => 'inherit',
				'google'  => false,
				'weight'  => '',
				'variant' => '',
			),
			'header_search_advanced_input_padding' => array(
				'size'   => array( '', '', '', '' ),
				'unit'   => 'em',
				'locked' => false,
			),
			// Button
			'header_search_advanced_buttons_background' => array(
				'color'  => 'palette1',
				'hover'  => 'palette2',
			),
			'header_search_advanced_buttons_color' => array(
				'color'  => 'palette9',
				'hover'  => 'palette9',
			),
			'header_search_advanced_button_typography'        => array(
				'size' => array(
					'desktop' => '',
				),
				'lineHeight' => array(
					'desktop' => '',
				),
				'family'  => 'inherit',
				'google'  => false,
				'weight'  => '',
				'variant' => '',
			),
			'header_search_advanced_button_padding' => array(
				'size'   => array( '', '', '', '' ),
				'unit'   => 'em',
				'locked' => false,
			),
			'header_search_advanced_button_radius' => array(
				'size'   => array( '', '', '', '' ),
				'unit'   => 'px',
				'locked' => true,
			),

			// Header Wishlist.
			'header_wishlist_title' => '',
			'header_wishlist_label' => '',
			'header_wishlist_show_total' => true,
			'header_wishlist_icon_size'   => array(
				'size' => array(
					'mobile'  => '',
					'tablet'  => '',
					'desktop' => '1.4',
				),
				'unit' => array(
					'mobile'  => 'em',
					'tablet'  => 'em',
					'desktop' => 'em',
				),
			),
			'header_wishlist_color'              => array(
				'color' => '',
				'hover' => '',
			),
			'header_wishlist_background'              => array(
				'color' => '',
				'hover' => '',
			),
			'header_wishlist_total_color'              => array(
				'color' => '',
				'hover' => '',
			),
			'header_wishlist_total_background'              => array(
				'color' => '',
				'hover' => '',
			),
			'header_wishlist_title_typography'            => array(
				'size' => array(
					'desktop' => '',
				),
				'lineHeight' => array(
					'desktop' => '',
				),
				'family'  => 'inherit',
				'google'  => false,
				'weight'  => '',
				'variant' => '',
			),
			'header_wishlist_title_color'              => array(
				'color' => '',
				'hover' => '',
			),
			'header_wishlist_label_typography'         => array(
				'size' => array(
					'desktop' => '',
				),
				'lineHeight' => array(
					'desktop' => '',
				),
				'family'  => 'inherit',
				'google'  => false,
				'weight'  => '',
				'variant' => '',
			),
			'header_wishlist_label_color'              => array(
				'color' => '',
				'hover' => '',
			),
			'header_wishlist_padding' => array(
				'size'   => array( '', '', '', '' ),
				'unit'   => 'em',
				'locked' => false,
			),

			// Transparent
			'transparent_header_search_advanced_color' => array(
				'color' => '',
				'hover'  => '',
			),
			'transparent_header_search_advanced_background' => array(
				'color' => '',
			),
			'transparent_header_search_advanced_border' => array(
				'color' => '',
				'hover'  => '',
			),
			'sticky_header_search_advanced_color' => array(
				'color' => '',
				'hover'  => '',
			),
			'sticky_header_search_advanced_background' => array(
				'color' => '',
			),
			'sticky_header_search_advanced_border' => array(
				'color' => '',
				'hover'  => '',
			),
			// Footer Widget 7.
			'footer_widget7_align'         => array(
				'mobile'  => '',
				'tablet'  => '',
				'desktop' => '',
			),
			'footer_widget7_vertical_align'         => array(
				'mobile'  => '',
				'tablet'  => '',
				'desktop' => '',
			),
			// Footer Widget 8.
			'footer_widget8_align'         => array(
				'mobile'  => '',
				'tablet'  => '',
				'desktop' => '',
			),
			'footer_widget8_vertical_align'         => array(
				'mobile'  => '',
				'tablet'  => '',
				'desktop' => '',
			),
			// Footer Widget 9.
			'footer_widget9_align'         => array(
				'mobile'  => '',
				'tablet'  => '',
				'desktop' => '',
			),
			'footer_widget9_vertical_align'         => array(
				'mobile'  => '',
				'tablet'  => '',
				'desktop' => '',
			),

		);
		$defaults = array_merge(
			$defaults,
			$more_addons
		);
		return $defaults;
	}
	/**
	 * Add Choices
	 *
	 * @access public
	 * @param array $choices registered choices with base theme.
	 * @return array
	 */
	public function add_customizer_item_choices( $choices ) {
		$choices['header_desktop_items']['vertical-menu'] = array(
			'name'    => esc_html__( 'Vertical Menu', 'templatemela-core' ),
			'section' => 'base_customizer_vertical_navigation',
		);
		$choices['header_desktop_items']['search-advanced'] = array(
			'name'    => esc_html__( 'Search Advanced', 'templatemela-core' ),
			'section' => 'base_customizer_header_search_advanced',
		);
		$choices['header_mobile_items']['search-advanced'] = array(
			'name'    => esc_html__( 'Search Advanced', 'templatemela-core' ),
			'section' => 'base_customizer_header_search_advanced',
		);
		$choices['header_desktop_items']['wishlist'] = array(
			'name'    => esc_html__( 'Wishlist', 'templatemela-core' ),
			'section' => 'base_customizer_wishlist',
		);
		$choices['header_mobile_items']['wishlist'] = array(
			'name'    => esc_html__( 'Wishlist', 'templatemela-core' ),
			'section' => 'base_customizer_wishlist',
		);
		$choices['footer_items']['footer-widget7'] = array(
			'name'    => esc_html__( 'Widget 7', 'templatemela-core' ),
			'section' => 'sidebar-widgets-footer7',
		);
		$choices['footer_items']['footer-widget8'] = array(
			'name'    => esc_html__( 'Widget 8', 'templatemela-core' ),
			'section' => 'sidebar-widgets-footer8',
		);
		$choices['footer_items']['footer-widget9'] = array(
			'name'    => esc_html__( 'Widget 9', 'templatemela-core' ),
			'section' => 'sidebar-widgets-footer9',
		);
		
		return $choices;
	}
	/**
	 * Add Sections
	 *
	 * @access public
	 * @param array $sections registered sections with base theme.
	 * @return array
	 */
	public function add_customizer_sections( $sections ) {
		$sections['vertical_navigation']        = array(
			'title'    => __( 'Vertical Navigation', 'templatemela-core' ),
			'panel'    => 'header',
			'priority' => 20,
		);
		$sections['vertical_navigation_design'] = array(
			'title'    => __( 'Vertical Navigation Design', 'templatemela-core' ),
			'panel'    => 'header',
			'priority' => 20,
		);
		$sections['header_search_advanced'] = array(
			'title'    => __( 'Search Advanced', 'templatemela-core' ),
			'panel'    => 'header',
			'priority' => 20,
		);
		$sections['header_search_advanced_design'] = array(
			'title'    => __( 'Search Advanced Design', 'templatemela-core' ),
			'panel'    => 'header',
			'priority' => 20,
		);
		$sections['wishlist'] = array(
			'title'    => __( 'Wishlist', 'templatemela-core' ),
			'panel'    => 'header',
			'priority' => 20,
		);
		$sections['wishlist_design'] = array(
			'title'    => __( 'Wishlist Design', 'templatemela-core' ),
			'panel'    => 'header',
			'priority' => 20,
		);
		$sections['sidebar-widgets-footer7'] = array(
			'title'    => __( 'Widget Footer 7 Settings', 'avanam' ),
			'panel'    => 'footer',
			'priority' => 10,
		);
		$sections['sidebar-widgets-footer8'] = array(
			'title'    => __( 'Widget Footer 8 Settings', 'avanam' ),
			'panel'    => 'footer',
			'priority' => 10,
		);
		$sections['sidebar-widgets-footer9'] = array(
			'title'    => __( 'Widget Footer 9 Settings', 'avanam' ),
			'panel'    => 'footer',
			'priority' => 10,
		);
		return $sections;
	}
	
	/**
	 * Registers the sidebars.
	 */
	public function action_register_sidebars() {
		$widgets = array(
			'footer7'           => __( 'Footer 7', 'templatemela-core' ),
			'footer8'           => __( 'Footer 8', 'templatemela-core' ),
			'footer9'           => __( 'Footer 9', 'templatemela-core' ),
		);

		foreach ( $widgets as $id => $name ) {
			register_sidebar(
				apply_filters(
					'base_pro_additional_widget_area_args',
					array(
						'name'          => $name,
						'id'            => $id,
						'description'   => esc_html__( 'Add widgets here.', 'templatemela-core' ),
						'before_widget' => '<section id="%1$s" class="widget %2$s">',
						'after_widget'  => '</section>',
						'before_title'  => '<h2 class="widget-title">',
						'after_title'   => '</h2>',
					)
				)
			);
		}
	}
	/**
	 * Add settings
	 *
	 * @access public
	 * @param object $wp_customize the customizer object.
	 * @return void
	 */
	public function create_pro_settings_array( $wp_customize ) {
		// Load Settings files.
		foreach ( self::$settings_sections as $key ) {
			require_once TMCORE_PATH . '/includes/addons/additional/' . $key . '-options.php'; // phpcs:ignore WPThemeReview.CoreFunctionality.FileInclude.FileIncludeFound
		}
	}

	/**
	 * Adds the snippet of js to trigger the cart open on add to cart.
	 */
	public function trigger_ajax_search_results_on_type() {
		if ( is_admin() ) {
			//return;
		}
		/* $open_cart = false;
		if ( ! is_cart() && ! is_checkout() && ( isset( $_POST['add-to-cart'] ) || isset( $_GET['add-to-cart'] ) ) ) {
			$open_cart = true;
		} */
		wp_enqueue_script( 'search-advanced' );
		wp_localize_script(
			'search-advanced',
			'searchAdvancedConfig',
			array(
				'ajaxURL' => admin_url('admin-ajax.php'),
			)
		);
	}

	/**
	 * Enqueues a script that improves navigation menu accessibility as well as sticky header etc.
	 */
	public function action_vertical_menu_enqueue_scripts() {

		// If the AMP plugin is active, return early.
		if ( webapp()->is_amp() ) {
			return;
		}
		// If not enabled then bail.
		/* if ( ! webapp()->option( 'cart_pop_show_on_add' ) ) {
			return;
		} */

		// Enqueue the vertical-navigation script.
		wp_enqueue_style( 'vertical-navigation-style', TMCORE_URL . 'includes/addons/additional/vertical-navigation.css', array(), TMCORE_VERSION );
		wp_register_script(
			'vertical-navigation',
			TMCORE_URL . 'includes/addons/additional/vertical-navigation.min.js',
			array(),
			TMCORE_VERSION,
			true
		);
		wp_script_add_data( 'vertical-navigation', 'async', true );
		wp_script_add_data( 'vertical-navigation', 'precache', true );

	}

	/**
	 * Enqueues a script that improves navigation menu accessibility as well as sticky header etc.
	 */
	public function action_search_advanced_enqueue_scripts() {

		// If the AMP plugin is active, return early.
		if ( webapp()->is_amp() ) {
			return;
		}
		// If not enabled then bail.
		/* if ( ! webapp()->option( 'cart_pop_show_on_add' ) ) {
			return;
		} */

		// Enqueue the search-advanced script.
		wp_enqueue_style( 'search-advanced-style', TMCORE_URL . 'includes/addons/additional/search-advanced.css', array(), TMCORE_VERSION );
		wp_register_script(
			'search-advanced',
			TMCORE_URL . 'includes/addons/additional/search-advanced.min.js',
			array( 'jquery' ),
			TMCORE_VERSION,
			true
		);
		
		wp_script_add_data( 'search-advanced', 'async', true );
		wp_script_add_data( 'search-advanced', 'precache', true );

	}

	/**
	 * Enqueues a script for header wishlist style.
	 */
	public function action_header_wishlist_options_enqueue_scripts() {

		// If the AMP plugin is active, return early.
		if ( webapp()->is_amp() ) {
			return;
		}
		// If not enabled then bail.
		/* if ( ! webapp()->option( 'cart_pop_show_on_add' ) ) {
			return;
		} */

		// Enqueue the header-wishlist script.
		wp_enqueue_style( 'header-wishlist-style', TMCORE_URL . 'includes/addons/additional/header-wishlist.css', array(), TMCORE_VERSION );
		
		wp_script_add_data( 'header-wishlist', 'async', true );
		wp_script_add_data( 'header-wishlist', 'precache', true );

	}

	/**
	 * AJAX Search Results.
	 */
	public static function search_data_fetch(){
		ob_start();
		
		//$the_query = new WP_Query( array( 'posts_per_page' => -1, 's' => esc_attr( $_POST['keyword'] ), 'post_type' => 'product' ) );

		if( !empty($_POST['keyword']) ) {

			if( !empty($_POST['category']) && '0' != $_POST['category'] ) {
				
				$args = array(      
					'post_type' => 'product',
					'post_status' => 'publish',
					'posts_per_page' => -1,
					's' => esc_attr( $_POST['keyword'] ),
					'tax_query' => array(
						'relation'  => 'AND',
						array(
							'taxonomy' => 'product_cat',
							'field'    => 'name',
							'terms'    => esc_attr( $_POST['category'] ),
						),
					),
				);
			} else {
				$args = array(      
					'post_type' => 'product',
					'post_status' => 'publish',
					'posts_per_page' => -1,
					's' => esc_attr( $_POST['keyword'] ),
					/* 'meta_query' => array(
						'relation' => 'OR',
						array(
							'key'     => '_sku',
							'value'   => esc_attr( $_POST['keyword'] ),
							'compare' => 'LIKE',
						),
					), */
				);
			}
		
			$the_query = new WP_Query($args);

			if( $the_query->have_posts() ) : ?>
					<?php while( $the_query->have_posts() ): $the_query->the_post(); 
					$product = wc_get_product( get_the_ID() );
					$terms = get_the_terms( $product->get_id(), 'product_cat' );
					$cat_name = $terms[0]->name;
					$image =  wp_get_attachment_image_src( get_post_thumbnail_id(), 'woocommerce_thumbnail' );
					?>
					<div class="tmc-suggestion tmc-selectable">
						<div class="tmc-product-search-item">
							<div class="tmc-product-search-image">
								<a href="<?php echo esc_url( get_permalink() ); ?>" class="img"><img src="<?php echo $image[0]; ?>" width="80px" alt="<?php the_title();?>" /></a>
							</div>
							<div class="tmc-product-search-item-content">
								<div class="tmc-product-search-item-cat"><?php echo $cat_name; ?></div>
								<h5 class="tmc-product-search-title"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php the_title();?></a></h5>
								<div class="tmc-product-search-price"><?php echo $product->get_price_html();?></div>
							</div>
						</div>
					</div>
					<?php endwhile;
					wp_reset_postdata(); ?>
			<?php 
			/* else:
				echo '<h6>'.esc_attr__('No result found', 'templatemela-core').'</h6>'; */
			endif;
			die();

		}
	}

}

Additional_Addons::get_instance();
