
(function ($) {
    'use strict';

    //tooltip();
    //ajax_wishlist_count();
    //ajax_live_search();
    $( document ).ready( function() {
        singleProductAddToCart();
        liveViewsVisitors();
        
        if ($('.check-incart-sold .tmcore-scroll').length) {
            lastProductSold();
        }
    } );

    function singleProductAddToCart() {
        // wc_add_to_cart_params is required to continue, ensure the object exists.
        if ( typeof wc_add_to_cart_params === 'undefined' ) {
            return false;
        }

        /**
         * Ajax add to cart.
         * button query selector to compatible with Lumise add on.
         */
        $( document ).on( 'click', 'button.single_add_to_cart_button.ajax_add_to_cart.button-buy-now', function( evt ) {
            evt.preventDefault();

            var $thisButton = $( this );

            if ( $thisButton.hasClass( 'disabled' ) ) { // Variation select required.
                return false;
            }

            if ( $thisButton.hasClass( 'woosb-disabled' ) ) { // Smart Bundle select required.
                return false;
            }

            var $variationsForm = $thisButton.closest( 'form.cart' ),
                productID       = $variationsForm.find( '[name=add-to-cart]' ).val(),
                variationID     = $variationsForm.find( 'input[name=variation_id]' ).val(),
                quantity        = $variationsForm.find( '.quantity .qty[name=quantity]' ).val();

            if ( 'add-to-cart' === $thisButton.attr( 'name' ) ) {
                productID = $thisButton.val();
            }

            if ( 0 === productID ) {
                return;
            }

            var data = {
                product_id: productID,
                variation_id: variationID,
            };

            $variationsForm.serializeArray().map( function( attr ) {
                if ( attr.name !== 'add-to-cart' ) {
                    if ( attr.name.endsWith( '[]' ) ) {
                        let name = attr.name.substring( 0, attr.name.length - 2 );
                        if ( ! (
                            name in data
                        ) ) {
                            data[name] = [];
                        }
                        data[name].push( attr.value );
                    } else {
                        data[attr.name] = attr.value;
                    }
                }
            } );

            // Custom quantity per button.
            if ( $thisButton.attr( 'data-qty' ) ) {
                quantity = parseInt( $thisButton.attr( 'data-qty' ) );
            }
            data.quantity = quantity;

            $thisButton.removeClass( 'added' ).addClass( 'loading updating-icon' );

            // Trigger event.
            $( 'body' ).trigger( 'adding_to_cart', [ $thisButton, data ] );

            // Ajax action.
            $.post( wc_add_to_cart_params.wc_ajax_url.toString().replace( '%%endpoint%%', 'tmcore_add_to_cart' ), data, function( response ) {
                if ( ! response ) {
                    return;
                }

                if ( response.error && response.product_url ) {
                    window.location = response.product_url;
                    return;
                }

                // Redirect to checkout for Buy Now button.
                var redirect = $thisButton.data( 'redirect' );
                if ( redirect && '' !== redirect ) {
                    window.location = redirect;
                    return;
                }

                // Redirect to cart option.
                if ( wc_add_to_cart_params.cart_redirect_after_add === 'yes' ) {
                    window.location = wc_add_to_cart_params.cart_url;
                    return;
                }

                // Trigger event so themes can refresh other areas.
                $( document.body ).trigger( 'added_to_cart', [
                    response.fragments, response.cart_hash, $thisButton
                ] );

            } ).always( function() {
                $thisButton.addClass( 'added' ).removeClass( 'loading updating-icon' );
            } );
        } );
    }

    function liveViewsVisitors() {
		var $wrap = $( '#tmcore-live-viewing-visitors' );

		if ( 0 >= $wrap.length ) {
			return;
		}
		var {
			    min,
			    max,
			    duration,
			    labels
		    }     = $wrap.data( 'settings' );
		var $text = $wrap.find( '.text-wrapper' );
		min       = parseInt( min );
		max       = parseInt( max );

		setInterval( function() {
			var current = Math.floor( Math.random() * (max - min + 1) ) + min,
			    text    = current > 1 ? labels.plural : labels.singular;
			text        = text.replace( '%s', '<span class="count">' + current + '</span>' );
			$text.html( text );
		}, duration );
	}

    function lastProductSold() {

        var last_sold_interval = false;
        if ($('.tmcore-last-sold').length && $('.tmcore-in-cart').length) {
            var last_sold_area = $('.tmcore-last-sold');
            var in_cart_area = $('.tmcore-in-cart');
            
            var _wrap = $('.check-incart-sold');
            var item_scroll = $(_wrap).find('.tmcore-scroll');
            
            $(last_sold_area).addClass('tmcore-show');
            $(in_cart_area).addClass('tmcore-show');
            
            if (last_sold_interval) {
                clearInterval(last_sold_interval);
            }
    
            last_sold_interval = setInterval(function() {
                var first_item = $(item_scroll).find('> div:first-child');
                var second_item = $(item_scroll).find('> div:nth-child(2)');
                
                var h = $(first_item).height();
                var h2 = $(second_item).height();
                var i = 0;
    
                $(_wrap).css({'height': h2});
    
                var last_sold_var = setInterval(function() {
                    i++;
                    
                    $(item_scroll).css({
                        '-webkit-transform': 'translateY(-' + i + 'px)',
                        '-moz-transform': 'translateY(-' + i + 'px)',
                        '-o-transform': 'translateY(-' + i + 'px)',
                        '-ms-transform': 'translateY(-' + i + 'px)',
                        'transform': 'translateY(-' + i + 'px)'
                    });
    
                    if (i >= h) {
                        clearInterval(last_sold_var);
                        $(item_scroll).append(first_item);
                        $(item_scroll).removeAttr('style');
                    }
                }, 10);
    
            }, 6000);
        }else {
            $('.single-product').find('.tmcore-last-sold, .tmcore-in-cart').addClass('tmcore-show');
        }
    
    }

    
    $('body').on('woosw_change_count', function(event, count) {
        $('.header-wishlist-total').html(count);
    });

    $(".tm-sticky-parent .product_image").on('scroll',function(e) {
        $('html, body').animate({
            scrollTop: $(".entry-summary").offset().top-150
        }, 1000);
    });

})(jQuery);
