<?php

if ( ! class_exists( 'TMSetup' ) ) {
	return;
}

global $wizard;
/**
 * Set directory locations, text strings, and settings.
 */
$wizard = new TMSetup(

	$config = array(
		'directory'            => 'setup', // Location / directory where TM Setup is placed in your theme.
		'tmsetup_url'          => 'templatemela-setup', // The wp-admin page slug where TM Setup loads.
		'parent_slug'          => 'templatemela', // The wp-admin parent page slug for the admin menu item.
		'capability'           => 'manage_options', // The capability required for this menu to be displayed to the user.
		'child_action_btn_url' => 'https://developer.wordpress.org/themes/advanced-topics/child-themes/', // URL for the 'child-action-link'.
		'dev_mode'             => true, // Enable development mode for testing.
		'license_step'         => true, // License activation step.
		'license_required'     => false, // Require the license activation step.
		'license_help_url'     => 'https://templatemela.com/find-your-purchase-code', // URL for the 'license-tooltip'.
		'edd_remote_api_url'   => '', // EDD_Theme_Updater_Admin remote_api_url.
		'edd_item_name'        => '', // EDD_Theme_Updater_Admin item_name.
		'edd_theme_slug'       => '', // EDD_Theme_Updater_Admin item_slug.
		'ready_big_button_url' => site_url(), // Link for the big button on the ready step.
	),
	$strings = array(
		'admin-menu'               => esc_html__( 'Getting Started', 'templatemela-core' ),

		/* translators: 1: Title Tag 2: Theme Name 3: Closing Title Tag */
		'title%s%s%s%s'            => esc_html__( '%1$s%2$s Themes &lsaquo; Theme Setup: %3$s%4$s', 'templatemela-core' ),
		'return-to-dashboard'      => esc_html__( 'Return to the dashboard', 'templatemela-core' ),
		'ignore'                   => esc_html__( 'Disable this wizard', 'templatemela-core' ),

		'btn-skip'                 => esc_html__( 'Skip', 'templatemela-core' ),
		'btn-next'                 => esc_html__( 'Next', 'templatemela-core' ),
		'btn-start'                => esc_html__( 'Start', 'templatemela-core' ),
		'btn-no'                   => esc_html__( 'Cancel', 'templatemela-core' ),
		'btn-plugins-install'      => esc_html__( 'Install', 'templatemela-core' ),
		'btn-child-install'        => esc_html__( 'Install', 'templatemela-core' ),
		'btn-content-install'      => esc_html__( 'Install', 'templatemela-core' ),
		'btn-import'               => esc_html__( 'Import', 'templatemela-core' ),
		'btn-license-activate'     => esc_html__( 'Activate', 'templatemela-core' ),
		'btn-license-skip'         => esc_html__( 'Later', 'templatemela-core' ),

		/* translators: Theme Name */
		'license-header%s'         => esc_html__( 'Activate License', 'templatemela-core' ),
		/* translators: Theme Name */
		'license-header-success%s' => esc_html__( 'License is Activated', 'templatemela-core' ),
		/* translators: Theme Name */
		'license%s'                => esc_html__( 'Enter your purchase code to enable remote updates and theme support.', 'templatemela-core' ),
		'license-label'            => esc_html__( 'License key', 'templatemela-core' ),
		'license-success%s'        => esc_html__( 'The license is already activated, so you can go to the next step!', 'templatemela-core' ),
		'license-json-success%s'   => esc_html__( 'Your license is activated! Remote updates and theme support are enabled.', 'templatemela-core' ),
		'license-tooltip'          => esc_html__( 'Need help?', 'templatemela-core' ),

		/* translators: Theme Name */
		'welcome-header%s'         => esc_html__( 'Welcome to TemplateMela', 'templatemela-core' ),
		'welcome-header-success%s' => esc_html__( 'Hi. Welcome back', 'templatemela-core' ),
		'welcome%s'                => esc_html__( 'This wizard will set up your theme, install plugins, and import content. It is optional & should take only a few minutes.', 'templatemela-core' ),
		'welcome-success%s'        => esc_html__( 'You may have already run this setup wizard. If you would like to proceed anyway, click on the "Start" button below.', 'templatemela-core' ),

		'child-header'             => esc_html__( 'Install Child Theme', 'templatemela-core' ),
		'child-header-success'     => esc_html__( 'You\'re good to go!', 'templatemela-core' ),
		'child'                    => esc_html__( 'Let\'s build & activate a child theme so you may easily make theme changes.', 'templatemela-core' ),
		'child-success%s'          => esc_html__( 'Your child theme has already been installed and is now activated, if it wasn\'t already.', 'templatemela-core' ),
		'child-action-link'        => esc_html__( 'Learn about child themes', 'templatemela-core' ),
		'child-json-success%s'     => esc_html__( 'Awesome. Your child theme has already been installed and is now activated.', 'templatemela-core' ),
		'child-json-already%s'     => esc_html__( 'Awesome. Your child theme has been created and is now activated.', 'templatemela-core' ),

		'plugins-header'           => esc_html__( 'Install Plugins', 'templatemela-core' ),
		'plugins-header-success'   => esc_html__( 'You\'re up to speed!', 'templatemela-core' ),
		'plugins'                  => esc_html__( 'Let\'s install some essential WordPress plugins to get your site up to speed.', 'templatemela-core' ),
		'plugins-success%s'        => esc_html__( 'The required WordPress plugins are all installed and up to date. Press "Next" to continue the setup wizard.', 'templatemela-core' ),
		'plugins-action-link'      => esc_html__( 'Advanced', 'templatemela-core' ),

		'import-header'            => esc_html__( 'Import Content', 'templatemela-core' ),
		'import'                   => esc_html__( 'Let\'s import content to your website, to help you get familiar with the theme.', 'templatemela-core' ),
		'import-action-link'       => esc_html__( 'Advanced', 'templatemela-core' ),

		'ready-header'             => esc_html__( 'All done. Have fun!', 'templatemela-core' ),

		/* translators: Theme Author */
		'ready%s'                  => esc_html__( 'Your theme has been all set up. Enjoy your new theme by TemplateMela', 'templatemela-core' ),
		'ready-action-link'        => esc_html__( 'Extras', 'templatemela-core' ),
		'ready-big-button'         => esc_html__( 'View your website', 'templatemela-core' ),
		'ready-link-1'             => sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://wordpress.org/support/', esc_html__( 'Explore WordPress', 'templatemela-core' ) ),
		'ready-link-2'             => '', // sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://templatemela.com/contact/', esc_html__( 'Get Theme Support', 'templatemela-core' ) ),
		'ready-link-3'             => sprintf( '<a href="%1$s">%2$s</a>', admin_url( 'customize.php' ), esc_html__( 'Start Customizing', 'templatemela-core' ) ),
	)
);
