<?php
/**
 * Layout functions and definitions.
 * by TemplateMela.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 */


use function Base\webapp;
 
/*
 * Import Default Layout Styles
 *
 */
function wooti_spareparts_enqueue_styles() {
    wp_enqueue_style( 'wooti-spareparts-style',
        TMTHEME_URL . 'layouts/spareparts/style.css',
        array(),
        TMTHEME_VERSION
    );
    wp_enqueue_script( 'wooti-spareparts-js',
        TMTHEME_URL . 'layouts/spareparts/custom.js',
        array(),
        TMTHEME_VERSION
    );
}

add_action(  'wp_enqueue_scripts', 'wooti_spareparts_enqueue_styles' , 9999 );

/**
 * Setup Layout Theme Defaults
 *
 * @param array  registered option defaults with base theme.
 * @return array
 */
function wooti_layout_change_option_defaults( $defaults ) {
    $new_defaults = '{
        "post_content_style": "unboxed"
    }';
    $new_defaults = json_decode( $new_defaults, true );
    return wp_parse_args( $new_defaults, $defaults );
}
//add_filter( 'base_theme_options_defaults', 'wooti_layout_change_option_defaults', 20 );

/*
 * Set Default Logo
 * Filter the output of logo to fix Googles Error about itemprop logo
 */
add_filter( 'base_custom_logo', 'wooti_set_default_logo', 10, 2 );
function wooti_set_default_logo( $html, $blog_id ) {

	$custom_logo_id = webapp()->option( 'custom_logo' );
    // if logo is uploaded then return
    if ( ! empty($custom_logo_id) ) {
        return $html;
    }
    
    $custom_logo_path = TMTHEME_URL . 'layouts/spareparts/img/';
	$html = sprintf( '<a href="%1$s" class="custom-logo-link" rel="home" itemprop="url">%2$s</a>',
        esc_url( home_url( '/' ) ),
        '<img decoding="async" width="94" height="28" src="' . $custom_logo_path . 'logo.svg"  class="logo" alt="' . get_bloginfo( 'name' ) . '" loading="lazy" srcset="' . $custom_logo_path . 'logo.svg 479w, ' . $custom_logo_path . 'logo.svg 200w" sizes="(max-width: 479px) 100vw, 479px" data-src="' . $custom_logo_path . 'logo.svg">');
        
        if ( webapp()->option( 'dark_mode_enable' ) && apply_filters( 'base_dark_mode_enable', true ) ) {
            $custom_logo_id = webapp()->option( 'dark_mode_logo' );
            // if dark logo is uploaded then return
            if ( ! empty($custom_logo_id) ) {
                return $html;
            }
            $html .= sprintf( '<a href="%1$s" class="brand" rel="home" itemprop="url">%2$s</a>',
            esc_url( home_url( '/' ) ),
            '<img decoding="async" width="94" height="28" src="' . $custom_logo_path . 'dark-logo.svg"  class="base-dark-mode-logo svg-logo-image logo" alt="' . get_bloginfo( 'name' ) . '" loading="lazy" srcset="' . $custom_logo_path . 'dark-logo.svg 479w, ' . $custom_logo_path . 'dark-logo.svg 200w" sizes="(max-width: 479px) 100vw, 479px" data-src="' . $custom_logo_path . 'dark-logo.svg">');

	    }
    return $html;	
}


// Override default theme icons
add_filter( 'base_svg_icon', 'wooti_override_theme_icons', 10, 4 );
function wooti_override_theme_icons( $output, $icon, $icon_title = '', $base = true, $aria = false ) {
    if ( 'shopping-cart' === $icon ) {
        return '<span class="base-svg-iconset"><svg class="thebase-svg-icon thebase-shopping-cart-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="0.5" viewBox="0 0 480.000000 480.000000"><title>Shopping Cart</title><g transform="translate(0.000000,480.000000) scale(0.100000,-0.100000)"
        fill="currentColor" stroke="none">
        <path d="M112 4793 c-37 -7 -98 -75 -106 -117 -15 -77 20 -146 88 -177 36 -16
        68 -19 253 -19 255 0 291 -9 368 -91 87 -93 79 16 85 -1234 6 -1218 3 -1143
        67 -1304 60 -151 180 -305 308 -396 84 -60 213 -120 315 -147 l85 -23 1225 0
        c1350 0 1265 -4 1429 62 151 60 305 180 396 308 58 81 119 210 147 310 22 80
        23 83 26 985 3 1011 6 963 -66 1018 l-35 27 -1789 3 -1788 2 0 123 c0 229 -49
        358 -184 493 -62 62 -99 90 -158 118 -118 56 -180 66 -428 64 -118 0 -225 -3
        -238 -5z m4368 -1886 c0 -505 -4 -794 -11 -833 -38 -214 -233 -414 -446 -459
        -57 -12 -259 -15 -1219 -15 -773 0 -1170 4 -1210 11 -168 30 -335 159 -412
        319 -22 47 -45 112 -51 144 -7 39 -11 328 -11 833 l0 773 1680 0 1680 0 0
        -773z"/>
        <path d="M2352 3193 c-42 -8 -100 -76 -107 -125 -3 -24 -5 -232 -3 -464 l3
        -421 27 -35 c73 -95 220 -81 268 25 18 39 20 69 20 467 0 393 -2 428 -19 466
        -10 23 -32 51 -49 63 -31 21 -98 33 -140 24z"/>
        <path d="M3152 3193 c-42 -8 -100 -76 -107 -125 -3 -24 -5 -232 -3 -464 l3
        -421 27 -35 c73 -95 220 -81 268 25 18 39 20 69 20 467 0 393 -2 428 -19 466
        -10 23 -32 51 -49 63 -31 21 -98 33 -140 24z"/>
        <path d="M1562 1105 c-431 -98 -586 -625 -277 -939 179 -181 479 -215 691 -78
        169 109 259 273 259 472 0 198 -91 363 -259 472 -114 73 -282 103 -414 73z
        m223 -328 c88 -45 142 -145 132 -242 -6 -62 -25 -101 -68 -144 -43 -43 -82
        -62 -144 -68 -96 -10 -197 44 -242 131 -21 40 -27 123 -13 175 15 55 90 136
        145 157 49 18 148 13 190 -9z"/>
        <path d="M3802 1105 c-431 -98 -586 -625 -277 -939 179 -181 479 -215 691 -78
        169 109 259 273 259 472 0 198 -91 363 -259 472 -114 73 -282 103 -414 73z
        m223 -328 c88 -45 142 -145 132 -242 -6 -62 -25 -101 -68 -144 -43 -43 -82
        -62 -144 -68 -96 -10 -197 44 -242 131 -21 40 -27 123 -13 175 15 55 90 136
        145 157 49 18 148 13 190 -9z"/>
        </g>
        </svg></span>';
    }
    if ( 'account' === $icon ) {
        return '<span class="base-svg-iconset"><svg class="thebase-svg-icon thebase-account-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 428.000000 512.000000"><title>Account</title>
        <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"
        fill="currentColor" stroke="none">
        <path d="M1950 5109 c-272 -30 -510 -148 -715 -354 -216 -216 -325 -445 -356
        -747 -37 -362 88 -719 341 -976 247 -252 534 -373 885 -373 338 0 609 109 851
        343 253 245 374 530 375 885 0 137 -2 158 -28 283 -77 365 -379 718 -736 860
        -191 76 -402 103 -617 79z m395 -318 c182 -48 330 -143 472 -304 195 -222 267
        -548 188 -852 -64 -245 -263 -479 -506 -594 -243 -116 -544 -116 -794 -1 -180
        83 -366 272 -455 461 -58 125 -74 206 -73 389 0 151 2 173 27 255 106 348 400
        610 751 666 88 14 302 3 390 -20z"/>
        <path d="M1030 2639 c-229 -20 -407 -99 -567 -252 -259 -248 -412 -667 -452
        -1237 -15 -198 -13 -318 4 -431 53 -357 286 -605 653 -696 61 -15 195 -17
        1412 -20 1361 -4 1431 -2 1566 33 297 77 521 299 595 589 49 194 31 621 -40
        965 -64 306 -163 529 -324 727 -162 201 -415 319 -694 324 -99 2 -132 -12
        -332 -141 -270 -174 -473 -243 -716 -243 -243 0 -445 69 -713 242 -148 96
        -225 136 -277 143 -16 2 -68 1 -115 -3z m218 -383 c81 -51 172 -107 202 -124
        84 -46 230 -101 359 -135 109 -29 127 -30 311 -31 220 -1 274 7 451 64 164 54
        243 93 433 214 l166 107 53 -7 c387 -47 614 -351 712 -954 35 -214 45 -554 21
        -671 -39 -183 -163 -319 -353 -386 l-78 -28 -1350 -3 c-1497 -3 -1440 -5
        -1583 63 -96 45 -190 138 -232 228 -59 125 -71 253 -50 553 33 481 164 846
        372 1040 100 92 248 152 401 163 10 0 85 -41 165 -93z"/>
        </svg></span>';
    }
    if ( 'phoneAlt2' === $icon ) {
        return '<span class="base-svg-iconset"><svg class="thebase-svg-icon thebase-phone-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 512.000000 512.000000"><title>phone</title>
        <g transform="translate(0.000000,512.000000) scale(0.100000,-0.100000)"
        fill="currentColor" stroke="none">
        <path d="M2771 5102 c-95 -48 -106 -182 -21 -244 14 -10 77 -29 140 -43 490
        -107 881 -317 1229 -658 352 -346 584 -764 686 -1237 30 -138 44 -172 79 -195
        67 -44 142 -36 194 19 27 30 32 43 32 86 0 93 -71 370 -141 551 -135 349 -343
        673 -608 942 -387 396 -860 656 -1401 772 -137 30 -145 30 -189 7z"/>
        <path d="M845 4800 c-75 -24 -124 -51 -196 -107 -75 -58 -457 -455 -507 -527
        -92 -131 -133 -282 -132 -491 0 -268 67 -537 223 -895 97 -225 197 -408 345
        -635 511 -784 1214 -1421 2008 -1818 440 -220 772 -318 1084 -321 170 -1 258
        18 400 86 l105 50 256 257 c200 199 265 271 297 326 59 101 75 167 70 284 -3
        83 -8 106 -36 165 -18 38 -57 99 -87 135 -84 103 -684 695 -740 730 -106 67
        -266 90 -386 55 -104 -31 -157 -70 -371 -282 l-206 -204 -99 51 c-421 218
        -1000 794 -1218 1214 l-57 108 138 132 c76 73 171 170 212 217 170 193 203
        377 105 580 -34 70 -61 99 -407 446 -364 365 -373 372 -458 414 -82 40 -94 43
        -185 47 -78 2 -110 -1 -158 -17z m213 -285 c25 -11 149 -128 375 -353 352
        -350 387 -393 387 -469 0 -75 -32 -118 -265 -348 -122 -121 -230 -235 -240
        -254 -13 -27 -16 -51 -13 -105 4 -63 12 -85 67 -194 269 -526 852 -1114 1393
        -1403 162 -87 203 -98 283 -75 56 17 69 28 289 245 127 126 246 236 265 246
        44 22 118 22 162 0 38 -19 652 -626 704 -695 63 -86 65 -172 5 -253 -16 -22
        -126 -138 -244 -258 -195 -197 -223 -222 -289 -253 -131 -63 -286 -71 -511
        -25 -395 79 -930 342 -1391 684 -817 607 -1492 1541 -1696 2350 -25 96 -32
        149 -36 265 -11 290 3 318 315 632 143 145 252 246 276 258 49 24 113 26 164
        5z"/>
        <path d="M2730 4173 c-91 -47 -107 -168 -31 -237 11 -10 77 -33 150 -52 284
        -72 491 -192 688 -398 180 -188 290 -396 355 -671 17 -72 27 -96 53 -122 81
        -81 223 -35 242 80 6 42 -42 245 -88 362 -191 497 -626 888 -1136 1020 -138
        36 -190 40 -233 18z"/>
        </g>
        </svg></span>';
    }
    return $output;
}


// Woo Gallery Thumbnail Size
/* add_filter( 'woocommerce_get_image_size_gallery_thumbnail', function( $size ) {
    return array(
        'width' => 150,
        'height' => 150,
        'crop' => 0,
    );
}); */