<?php
/**
 * Layout functions and definitions.
 * by TemplateMela.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 */


use function Base\webapp;
 
/*
 * Import Default Layout Styles
 *
 */
function wooti_organic_enqueue_styles() {
    wp_enqueue_style( 'wooti-organic-style',
        TMTHEME_URL . 'layouts/organic/style.css',
        array(),
        TMTHEME_VERSION
    );
    wp_enqueue_script( 'wooti-organic-js',
        TMTHEME_URL . 'layouts/organic/custom.js',
        array(),
        TMTHEME_VERSION
    );
}

add_action(  'wp_enqueue_scripts', 'wooti_organic_enqueue_styles' , 9999 );

/**
 * Setup Layout Theme Defaults
 *
 * @param array  registered option defaults with base theme.
 * @return array
 */
function wooti_layout_change_option_defaults( $defaults ) {
    $new_defaults = '{
        "post_content_style": "unboxed"
    }';
    $new_defaults = json_decode( $new_defaults, true );
    return wp_parse_args( $new_defaults, $defaults );
}
//add_filter( 'base_theme_options_defaults', 'wooti_layout_change_option_defaults', 20 );

/*
 * Set Default Logo
 * Filter the output of logo to fix Googles Error about itemprop logo
 */
add_filter( 'base_custom_logo', 'wooti_set_default_logo', 10, 2 );
function wooti_set_default_logo( $html, $blog_id ) {

	$custom_logo_id = webapp()->option( 'custom_logo' );
    // if logo is uploaded then return
    if ( ! empty($custom_logo_id) ) {
        return $html;
    }
    
    $custom_logo_path = TMTHEME_URL . 'layouts/organic/img/';
	$html = sprintf( '<a href="%1$s" class="custom-logo-link" rel="home" itemprop="url">%2$s</a>',
        esc_url( home_url( '/' ) ),
        '<img decoding="async" width="120" height="34" src="' . $custom_logo_path . 'logo.svg"  class="logo" alt="' . get_bloginfo( 'name' ) . '" loading="lazy" srcset="' . $custom_logo_path . 'logo.svg 479w, ' . $custom_logo_path . 'logo.svg 200w" sizes="(max-width: 479px) 100vw, 479px" data-src="' . $custom_logo_path . 'logo.svg">');
        
        if ( webapp()->option( 'dark_mode_enable' ) && apply_filters( 'base_dark_mode_enable', true ) ) {
            $custom_logo_id = webapp()->option( 'dark_mode_logo' );
            // if dark logo is uploaded then return
            if ( ! empty($custom_logo_id) ) {
                return $html;
            }
            $html .= sprintf( '<a href="%1$s" class="brand" rel="home" itemprop="url">%2$s</a>',
            esc_url( home_url( '/' ) ),
            '<img decoding="async" width="120" height="34" src="' . $custom_logo_path . 'dark-logo.svg"  class="base-dark-mode-logo svg-logo-image logo" alt="' . get_bloginfo( 'name' ) . '" loading="lazy" srcset="' . $custom_logo_path . 'dark-logo.svg 479w, ' . $custom_logo_path . 'dark-logo.svg 200w" sizes="(max-width: 479px) 100vw, 479px" data-src="' . $custom_logo_path . 'dark-logo.svg">');

	    }
    return $html;	
}


// Override default theme icons
add_filter( 'base_svg_icon', 'wooti_override_theme_icons', 10, 4 );
function wooti_override_theme_icons( $output, $icon, $icon_title = '', $base = true, $aria = false ) {
    if ( 'shopping-bag' === $icon ) {
        return '<span class="base-svg-iconset"><svg class="thebase-svg-icon thebase-shopping-cart-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="0.5" viewBox="0 0 432 522"><title>Shopping Cart</title><path d="M412,130h-60.9C343.1,62.5,285.6,0,216,0S88.9,62.5,80.9,130H20c-11,0-20,9-20,20v352c0,11,9,20,20,20h392c11,0,20-9,20-20 V150C432,
        139,423,130,412,130z M216,40c47.5,0,87,44.7,94.7,90H121.3C129,84.7,168.5,40,216,40z M392,482H40V170h40v30 c0,11,9,20,20,20s20-9,
        20-20v-30h192v30c0,11,9,20,20,20s20-9,20-20v-30h40V482z"></path>
        </svg></span>';
    }
    if ( 'account' === $icon ) {
        return '<span class="base-svg-iconset"><svg class="thebase-svg-icon thebase-account-svg" fill="currentColor" stroke-width="0.5px" stroke="#000000" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 64 64"><title>Account</title><path d="M41.2452,33.0349a16,16,0,1,0-18.49,0A26.0412,26.0412,0,0,0,4,58a2,2,0,0,0,2,2H58a2,2,0,0,0,2-2A26.0412,26.0412,0,0,0,41.2452,33.0349ZM20,20A12,12,0,1,1,32,32,12.0137,12.0137,0,0,1,20,20ZM8.09,56A22.0293,22.0293,0,0,1,30,36h4A22.0293,22.0293,0,0,1,55.91,56Z"></path>
        </svg></span>';
    }
    return $output;
}


