<?php
/**
 * Layout functions and definitions.
 * by TemplateMela.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 */


use function Base\webapp;
 
/*
 * Import Default Layout Styles
 *
 */
function wooti_movie_enqueue_styles() {
    wp_enqueue_style( 'wooti-movie-style',
        TMTHEME_URL . 'layouts/movie/style.css',
        array(),
        TMTHEME_VERSION
    );
    wp_enqueue_script( 'wooti-movie-js',
        TMTHEME_URL . 'layouts/movie/custom.js',
        array(),
        TMTHEME_VERSION
    );
}

add_action(  'wp_enqueue_scripts', 'wooti_movie_enqueue_styles' , 9999 );

/**
 * Setup Layout Theme Defaults
 *
 * @param array  registered option defaults with base theme.
 * @return array
 */
function wooti_layout_change_option_defaults( $defaults ) {
    $new_defaults = '{
        "post_content_style": "unboxed"
    }';
    $new_defaults = json_decode( $new_defaults, true );
    return wp_parse_args( $new_defaults, $defaults );
}
//add_filter( 'base_theme_options_defaults', 'wooti_layout_change_option_defaults', 20 );

/*
 * Set Default Logo
 * Filter the output of logo to fix Googles Error about itemprop logo
 */
add_filter( 'base_custom_logo', 'wooti_set_default_logo', 10, 2 );
function wooti_set_default_logo( $html, $blog_id ) {

	$custom_logo_id = webapp()->option( 'custom_logo' );
    // if logo is uploaded then return
    if ( ! empty($custom_logo_id) ) {
        return $html;
    }
    
    $custom_logo_path = TMTHEME_URL . 'layouts/movie/img/';
	$html = sprintf( '<a href="%1$s" class="custom-logo-link" rel="home" itemprop="url">%2$s</a>',
        esc_url( home_url( '/' ) ),
        '<img decoding="async" width="150" height="50" src="' . $custom_logo_path . 'logo.svg"  class="logo" alt="' . get_bloginfo( 'name' ) . '" loading="lazy" srcset="' . $custom_logo_path . 'logo.svg 479w, ' . $custom_logo_path . 'logo.svg 200w" sizes="(max-width: 479px) 100vw, 479px" data-src="' . $custom_logo_path . 'logo.svg">');
        
        if ( webapp()->option( 'dark_mode_enable' ) && apply_filters( 'base_dark_mode_enable', true ) ) {
            $custom_logo_id = webapp()->option( 'dark_mode_logo' );
            // if dark logo is uploaded then return
            if ( ! empty($custom_logo_id) ) {
                return $html;
            }
            $html .= sprintf( '<a href="%1$s" class="brand" rel="home" itemprop="url">%2$s</a>',
            esc_url( home_url( '/' ) ),
            '<img decoding="async" width="150" height="50" src="' . $custom_logo_path . 'dark-logo.svg"  class="base-dark-mode-logo svg-logo-image logo" alt="' . get_bloginfo( 'name' ) . '" loading="lazy" srcset="' . $custom_logo_path . 'dark-logo.svg 479w, ' . $custom_logo_path . 'dark-logo.svg 200w" sizes="(max-width: 479px) 100vw, 479px" data-src="' . $custom_logo_path . 'dark-logo.svg">');

	    }
    return $html;	
}


// Override default theme icons
add_filter( 'base_svg_icon', 'wooti_override_theme_icons', 10, 4 );
function wooti_override_theme_icons( $output, $icon, $icon_title = '', $base = true, $aria = false ) {
    if ( 'shopping-bag' === $icon ) {
        return '<span class="base-svg-iconset"><svg class="base-svg-icon thebase-shopping-bag-svg" storke="currentColor" stroke-width="3px" fill="currentColor" id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 373.82 459.84">
        <defs>
          <style>
            .cls-1 { fill: currentcolor; }
            .cls-2 { fill: currentcolor; }
            .cls-3 { fill: currentcolor; }
          </style>
        </defs>
        <g>
          <path class="cls-1" d="M292,191h11c.37,1.41,1.54.9,2.43,1,32.49,3.36,56.67,19.39,72.59,47.83,9.41,16.81,11.41,35.2,10.63,54.05-.15,3.44.72,4.47,4.3,4.43,17.63-.2,35.27-.18,52.91-.07,18.79.12,33.4,11.38,37.79,28.75.33,1.32-.52,3.1,1.26,4v1c-1.8,1-1,2.65-1,4q0,136.89,0,273.78c0,1.7-.89,3.69.95,5.1v4c-1.76.74-1.31,2.56-1.69,3.84-4.66,15.66-17,25.84-33.22,27.31-1-.05-2-.15-3-.15H153.47c-2.49,0-5,.09-7.47.14-16.23-1.46-28.58-11.67-33.23-27.3-.38-1.28.08-3.11-1.68-3.85v-4c1.83-1.41,1-3.4,1-5.1q.08-136.12,0-272.24c0-1.52.86-3.37-1-4.56v-4c.79-.11.93-.71,1.16-1.37,7.26-21.1,18.9-29.37,41.29-29.37,16.65,0,33.29-.08,49.94.07,3,0,4.08-.7,3.88-3.85-.28-4.47-.14-9,0-13.47,1.1-42.91,30-77.92,71.88-87.34C283.47,192.65,288,193.08,292,191Zm5.63,427.09H443.54c8.1,0,9.12-1.05,9.12-9.25q0-73,0-145.93,0-62.22,0-124.44c0-6.67-1.59-8.25-8.23-8.26-17.16,0-34.32.1-51.47-.1-3.64,0-4.44,1.16-4.33,4.53.23,7.15.19,14.32,0,21.48-.22,9.83-7,16.83-16.09,16.81s-15.73-7.08-15.85-16.91c-.09-7.33-.17-14.67.06-22,.09-3.15-1-3.9-4-3.89q-54.72.14-109.43,0c-3.3,0-4.29.91-4.18,4.2.24,7.15.14,14.32.06,21.49-.11,9.94-6.6,17-15.65,17.1-9.25.14-16.14-7-16.3-17.09-.11-7-.23-14,.06-21,.16-3.69-.8-4.79-4.64-4.74-16.82.23-33.64.09-50.47.1-7.61,0-8.93,1.35-8.94,9.06V609.12c0,7.82,1.14,9,8.91,9Zm-.14-319.88c18,0,36-.19,54,.13,4.64.08,5.74-1.35,5.33-5.59-.36-3.63,0-7.32-.11-11-.73-27.25-18.59-49.82-44.59-56.39-25.19-6.37-51.69,5-65,27.81-7.19,12.32-8.1,25.77-7.95,39.57,0,4.2.74,5.66,5.38,5.58C262.18,298,279.84,298.2,297.49,298.2Z" transform="translate(-111.09 -190.99)"></path>
          <path class="cls-2" d="M450,650a7.93,7.93,0,0,0-.07.84H146.07A7.93,7.93,0,0,0,146,650c2.49-.05,5-.14,7.47-.14H447C448,649.83,449,649.93,450,650Z" transform="translate(-111.09 -190.99)"></path>
          <path class="cls-3" d="M484.9,614.84c-1.84-1.41-.95-3.4-.95-5.1q-.07-136.89,0-273.78c0-1.37-.83-3,1-4Z" transform="translate(-111.09 -190.99)"></path>
          <path class="cls-3" d="M111.09,332.94c1.81,1.19,1,3,1,4.56q.08,136.13,0,272.24c0,1.7.88,3.69-1,5.1Z" transform="translate(-111.09 -190.99)"></path>
        </g>
      </svg></span>';
    }
    if ( 'account' === $icon ) {
        return '<span class="base-svg-iconset"><svg  class="thebase-svg-icon thebase-account-svg" fill="currentColor" id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 380.82 408.62">
        <defs>
          <style>
            .cls-1 { fill: currentcolor; } .cls-2 { fill: currentcolor; }
          </style>
        </defs>
        <g>
          <path class="cls-1" d="M117.82,625.4c-1.43-.86-2.91-1.65-4.27-2.61A14.58,14.58,0,0,1,107,610.22c.15-27.78,4.48-54.7,17.08-79.83,14.84-29.61,38.14-50.22,68-63.83,24.1-11,49.63-16.05,75.82-18.28a337.94,337.94,0,0,1,73.19,1.5c31.41,4.15,61.21,13,87.41,31.56,29.71,21.07,47.08,50.12,54.81,85.33,2.84,12.88,3.81,26,4.47,39.13.47,9.45-2.46,16.19-11.61,19.6Zm179.64-29.77q78,0,156,.07c3.24,0,4-.83,3.64-4A157.74,157.74,0,0,0,450,558.3c-8.92-26.31-25.6-46.15-49.76-59.74-21-11.78-43.85-17.3-67.47-19.89a315.61,315.61,0,0,0-76,.69c-21.86,2.9-43,8.38-62.32,19.26-16.4,9.21-29.83,21.59-39.58,37.82-10.18,16.95-15,35.52-17.17,55-.42,3.8.79,4.28,4.16,4.27Q219.67,595.55,297.46,595.63Z" transform="translate(-107.02 -216.78)"></path>
          <path class="cls-2" d="M396.36,318.8c-1,31.5-11.95,58.39-34.61,80.34C328.85,431,275.33,433.81,240,404.85c-32.75-26.83-45.55-61.93-40-103.47,4.16-31.36,20.18-55.59,47.65-71.6,19.23-11.2,40.23-14.82,62.24-12.19,24.13,2.89,44.66,13.07,61,31.24C388.72,268.78,396.17,292.6,396.36,318.8Zm-168.08-2.38c.48,24.1,7.91,44,24.27,60.14a63.15,63.15,0,0,0,80.7,7.29c26.11-17.85,39-53.27,30.81-85.33-12.25-47.87-63.5-63.73-100.92-43.28C238.78,268.57,229,290.88,228.28,316.42Z" transform="translate(-107.02 -216.78)"></path>
        </g>
      </svg></span>';
    }
    if ( 'search' === $icon ) {
      return '<span class="base-svg-iconset"><svg class="thebase-svg-icon thebase-search-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><title>Search</title> <path d="M16.041 15.856c-0.034 0.026-0.067 0.055-0.099 0.087s-0.060 0.064-0.087 0.099c-1.258 1.213-2.969 1.958-4.855 1.958-1.933 0-3.682-0.782-4.95-2.050s-2.050-3.017-2.050-4.95 0.782-3.682 2.050-4.95 3.017-2.050 4.95-2.050 3.682 0.782 4.95 2.050 2.050 3.017 2.050 4.95c0 1.886-0.745 3.597-1.959 4.856zM21.707 20.293l-3.675-3.675c1.231-1.54 1.968-3.493 1.968-5.618 0-2.485-1.008-4.736-2.636-6.364s-3.879-2.636-6.364-2.636-4.736 1.008-6.364 2.636-2.636 3.879-2.636 6.364 1.008 4.736 2.636 6.364 3.879 2.636 6.364 2.636c2.125 0 4.078-0.737 5.618-1.968l3.675 3.675c0.391 0.391 1.024 0.391 1.414 0s0.391-1.024 0-1.414z"></path>
      </svg></span>';
  }
    return $output;
}


  
  // // All Product Images
  // add_filter( 'woocommerce_get_image_size_thumbnail', function( $size ) {
  //   return array('width' => 342, 'height' => 463, 'crop' => 1, );
  // });