<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Theme
 * @since 1.0
 */

$default_options = array(
	'content_width' => array(
		'size' => 1710,
		'unit' => 'px',
	),
	// Logo
	'logo_layout'     => array(
		'include' => array(
			'mobile'  => 'logo_only',
			'tablet'  => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'family'  => 'Inter',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette4',
	),
	'heading_font'        => array(
		'family' => 'Inter',
	),
	'h1_font' => array(
		'size' => array(
			'desktop' => 34,
		),
		'lineHeight' => array(
			'desktop' => 1.17,
		),
		'letterSpacing' => array(
			'desktop' => 0.15,
		),
		'spacingType'  => 'px',
		'google'  => true,
		'weight'  => '700',
		'variant' => '700',
		'color'   => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'mobile' => 22,
			'desktop' => 28,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '700',
		'variant' => '700',
		'color'   => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'mobile' => 17,
			'tablet' => 22,
			'desktop' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'desktop' => 22,
		),
		'color'   => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'desktop' => 20,
		),
		'color'   => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.75,
		),
		'letterSpacing' => array(
			'desktop' => 0.15,
		),
		'spacingType'  => 'px',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'title_above_font' => array(
		'size' => array(
			'desktop' => '27',
		),
	),
	'title_above_breadcrumb_font' => array(
		'size' => array(
			'desktop' => 14,
		),
	),
	//buttons
	'buttons_color'                     => array(
		'color'  => 'palette9',
		'hover'  => 'palette3',
	),
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => '50',
		),
	),
	'buttons_typography'    => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 2,
		),
		'letterSpacing' => array(
			'desktop' => 0.5,
		),
		'spacingType' => 'px',
		'transform'  => 'capitalize',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'buttons_padding'        => array(
		'size'   => array( 
			'mobile' => array( 6, 15, 6, 15 ),
			'desktop' => array( 8, 27, 8, 27 ),
		),
		'unit'   => array(
			'desktop' => 'px',
		),
		'locked' => array(
			'desktop' => false,
		),
	),
	// Header.
	'header_desktop_items'       => array(
		'top' => array(
			'top_left'         => array( 'navigation-2' ),
			'top_center'       => array( 'html' ),
			'top_right'        => array( 'html2' ),
		),
		'main' => array(
			'main_left'         => array( 'logo', 'search-advanced'),
			'main_right'        => array('contact', 'divider', 'account', 'divider2', 'cart'),
		),
		'bottom' => array(
			'bottom_left'         => array( 'vertical-menu' , 'divider3', 'navigation'),
			'bottom_right'        => array('toggle-widget'),
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_center' => array( 'mobile-html' ),
		),
		'main' => array(
			'main_left'   => array( 'popup-toggle', 'mobile-logo' ),
			'main_right'  => array( 'search', 'mobile-account', 'mobile-cart' ),
		),
		'bottom' => array(
			'bottom_left'   => array(),
		),
	),
	'header_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	// Header Top.
	'header_top_height'       => array(
		'size' => array(
			'mobile' => 30,
			'desktop' => 40,
		),
	),
	'header_top_background'    => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	// Header Main.
	'header_main_height' => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 80,
			'desktop' => 90,
		),
	),
	'header_main_top_border'    => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'rgba(255,255,255,0.1)',
		),
	),
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	),
	// Header Bottom.
	'header_bottom_height'       => array(
		'size' => array(
			'desktop' => 60,
		),
	),
	'header_bottom_background'    => array(
		'desktop' => array(
			'color' => 'palette9',
		),
	),
	'header_bottom_bottom_border'    => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'var(--global-gray-400)',
		),
	),
	// Mobile Trigger.
	'mobile_trigger_icon_size'   => array(
		'size' => 22,
		'unit' => 'px',
	),
	'mobile_trigger_color'              => array(
		'color' => '#ffffff',
		'hover' => 'palette2',
	),
	//header search
	'header_search_icon_size' => array(
		'size' => array(
			'tablet'  => 31,
		),
		'unit' => array(
			'tablet'  => 'px',
		),
	),
	'header_search_color'              => array(
		'color' => '#ffffff',
		'hover' => 'palette2',
	),
	// Header HTML.
	'header_html_content'    =>  __( 'Save up to 20% on all Toys & Accessories with <a> "FLAT26OFF" </a> code', 'templatemela-theme-wooti' ),
	'header_html_typography' => array(
		'color'   => '#ffffff',
	),
	'header_html_wpautop' => false,
	'header_html_link_style' => 'plain',
	'header_html_link_color'              => array(
		'color' => '#ffffff',
		'hover' => 'palette2',
	),
	// html 2 
	'header_html2_content'    =>  __( 'Free Shipping on orders over $100!', 'templatemela-theme-wooti' ),
	'header_html2_typography' => array(
		'color'   => '#ffffff'
	),
	// Mobile Header HTML.
	'mobile_html_typography' => array(
		'color'   => '#ffffff',
	),
	'mobile_html_wpautop' => false,
	// Header Cart.
	'header_cart_title' =>  __( 'Cart', 'templatemela-theme-wooti' ),
	'header_cart_label' =>  __( 'Item', 'templatemela-theme-wooti' ),
	'header_cart_icon' => 'shopping-cart',
	'header_cart_icon_size'   => array(
		'size' => 25,
		'unit' => 'px',
	),
	'header_cart_color'              => array(
		'color' => '#ffffff',
		'hover' => 'palette2',
	),
	'header_cart_total_color'              => array(
		'color' => '#000000',
	),
	'header_cart_total_background'              => array(
		'color' => '#ffffff',
	),
	'header_cart_title_typography'            => array(
		'size' => array(
			'desktop' => 13,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
	),
	'header_cart_typography'            => array(
		'size' => array(
			'desktop' => 16,
		),
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'header_cart_title_color'              => array(
		'color' => '#ffffff',
	),
	// Mobile Header Cart.
	'header_mobile_cart_icon' => 'shopping-cart',
	'header_mobile_cart_icon_size'   => array(	
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_cart_color'              => array(
		'color' => '#ffffff',
		'hover' => 'palette2',
	),
	'header_mobile_cart_total_color'              => array(
		'color' => '#000000',
		'hover' => 'palette2',
	),
	'header_mobile_cart_total_background'              => array(
		'color' => '#ffffff',
		'hover' => '#ffffff',
	),
	// Navigation.
	'primary_navigation_typography'            => array(
		'size' => array(
			'desktop' => 15,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	'primary_navigation_spacing'            => array(
		'size' => 40,
		'unit' => 'px',
	),
	'primary_navigation_vertical_spacing'   => array(
		'size' => 18,
		'unit' => 'px',
	),
	'primary_navigation_color'   => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
		'active' => 'palette3',
	),
	// Secondary Navigation.
	'secondary_navigation_typography'            => array(
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'   => 'px',
		'color'   => '#ffffff',
	),
	'secondary_navigation_spacing'            => array(
		'size' => 36,
		'unit' => 'px',
	),
	'secondary_navigation_color'   => array(
		'color'  => '#ffffff',
		'hover'  => 'palette2',
		'active' => '#ffffff',
	),
	// mobile navigation 
	'mobile_navigation_color'              => array(
		'color'  => 'palette3',
		'hover'  => 'palette3',
		'active' => 'palette3',
	),
	//dropdown
	'dropdown_navigation_typography'        => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.7,
		),
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	// Footer.
	'footer_items'       => array(
		'top' => array(
			'top_1' => array('footer-widget1'),
		),
		'middle' => array(
			'middle_1' => array('footer-widget2'),
			'middle_2' => array('footer-widget3' , 'footer-widget4'),
			'middle_3' => array('footer-widget5'),
		),
		'bottom' => array(
			'bottom_1' => array('footer-html'),
			'bottom_2' => array('footer-widget6'),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	// Footer Widget 1.
	'footer_widget1_vertical_align'         => array(
		'desktop' => 'middle',
	),
	// Footer Widget 6.
	'footer_widget6_align'         => array(
		'mobile'  => 'center',
		'tablet'  => 'center',
		'desktop' => 'right',
	),
	'footer_widget6_vertical_align'         => array(
		'desktop' => 'middle',
	),
	// footer html 
	'footer_html_align'         => array(
		'tablet'  => 'center',
	),
	// Footer Top.
	'footer_top_columns' => '1',
	'footer_top_top_spacing' => array(
		'size' => array(
			'desktop' => 20,
		),
	),
	'footer_top_bottom_spacing' => array(
		'size' => array(
			'desktop' => 20,
		),
	),
	'footer_top_widget_content' => array(
		'lineHeight' => array(
			'mobile' => 12,
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.8,
			'mobile' => 1.5,
		),
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette9',
	),
	// footer middle 
	'footer_middle_column_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'rgba(255,255,255,0.2)',
		),
	),
	'footer_middle_direction'         => array(
		'desktop' => 'row',
		'mobile' => 'row',
	),
	'footer_middle_layout'  => array(
		'mobile'  => 'row',
		'tablet'  => 'row',
		'desktop' => 'equal',
	),
	'footer_middle_widget_spacing' => array(
		'size' => array(
			'desktop' => 0,
		),
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'desktop' => 130,
			'tablet' => 40,
			'mobile' => 30,
		),
	),
	'footer_middle_top_spacing' => array(
		'size' => array(
			'desktop' => 60,
			'tablet'  => 50,
			'mobile'  => 30,
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'desktop' => 60,
			'tablet'  => 50,
			'mobile'  => 30,
		),
	),
	'footer_middle_columns' => '3',
	'footer_middle_widget_title'  => array(
		'size' => array(
			'desktop' => 18,
			'mobile' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'google'  => true,
		'weight'  => '700',
		'variant' => '700',
		'color'   => '#ffffff',
	),
	'footer_middle_widget_content' => array(
		'lineHeight' => array(
			'desktop' => 2,
		),
		'color'   => '#dddddd',
	),
	'footer_middle_link_colors' => array( 
		'color' => '#dddddd',
		'hover' => 'palette2',
	),
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'rgba(255,255,255,0.1)',
		),
	),
	'footer_middle_top_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'rgba(255,255,255,0.1)',
		),
	),
	'footer_middle_link_style' => 'noline',
	// Footer Bottom.
	'footer_bottom_columns' => '2',
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'desktop' => 10,
			'tablet' => 15,
		),
	),
	'footer_bottom_top_spacing' => array(
		'size' => array(
			'desktop' => 15,
		),
	),
	'footer_bottom_widget_content' => array(
		'color'   => '#dddddd',
	),
	'footer_bottom_link_colors' => array( 
		'color' => '#dddddd',
		'hover' => 'palette2',
	),
	'footer_bottom_link_style' => 'noline',
	//sidebar
	'sidebar_link_style' => 'plain',
	'sidebar_width'   => array(
		'size' => '280',
		'unit' => 'px',
	),
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 18,
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'sidebar_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
	//product
	'product_archive_button_style'       => 'button',
	'product_archive_title_font'   => array(
		'size' => array(
			'mobile' => '13',
			'desktop' => '14',
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'product_archive_price_font'   => array(
		'size' => array(
			'mobile' => 15,
			'tablet' => 17,
			'desktop' => 18,
		),
		'letterSapcing' => array(
			'desktop' => '0.5',
		),
		'spacingType'  => 'px',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'product_archive_button_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette9',
	),
	'product_archive_button_background'              => array(
		'color' => 'palette7',
		'hover' => 'palette1',
	),
	'product_archive_title_top_border' => array(
		'tablet' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color' => 'var(--global-gray-400)',
		),
	),
	'product_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'product_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'product_title_top_border' => array(
		'tablet' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color' => 'var(--global-gray-400)',
		),
	),
	'product_title_font'   => array(
		'size' => array(
			'mobile'  => '20',
			'tablet' => '23',
			'desktop' => '27',
		),
	),
	'product_related_columns'    => '6',
	'product_upsell_columns'    => '6',
	//post
	'post_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_archive_title_top_border' => array(
		'tablet' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color' => 'var(--global-gray-400)',
		),
	),
	'post_title_height'       => array(
		'size' => array(
			'desktop' => 130,
		),
	),
	'post_title_top_border' => array(
		'tablet' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color' => 'var(--global-gray-400)',
		),
	),
	//page
	'page_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'page_title_top_border' => array(
		'tablet' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color' => 'var(--global-gray-400)',
		),
	),
	//search
	'search_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'search_archive_title_top_border' => array(
		'tablet' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color' => 'var(--global-gray-400)',
		),
	),
	//links
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);
$header_addons = array(
	// Header Divider.
	'header_divider_border' => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
		'color'  => 'rgba(255,255,255,0.1)',
	),
	'header_divider_margin' => array(
		'size'   => array( 0, 5, 0, 5 ),
		'unit'   => 'px',
		'locked' => false,
	),
	// Header Divider2.
	'header_divider2_border' => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
		'color'  => 'rgba(255,255,255,0.1)',
	),
	'header_divider2_margin' => array(
		'size'   => array( 0, 5, 0, 5 ),
		'unit'   => 'px',
		'locked' => false,
	),
	// Header Divider3.
	'header_divider3_border' => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
		'color'  => 'rgba(0,0,0,0.1)',
	),
	'header_divider3_margin' => array(
		'size'   => array( 0, 5, 0, 5 ),
		'unit'   => 'px',
		'locked' => false,
	),
	// header account
	'header_account_style'                   => 'icon_title_label',
	'header_account_title'                   => __( 'My Account', 'templatemela-theme-wooti' ),
	'header_account_label'                   => __( 'Log In', 'templatemela-theme-wooti' ),
	'header_account_icon_size'               => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette2',
	),
	'header_account_title_typography' => array(
		'size' => array(
			'desktop' => 13,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
	),
	'header_account_title_typography_color' => array(
		'color' => '#ffffff',
	),
	'header_account_typography' => array(
		'size' => array(
			'desktop' => 16,
		),
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'header_account_typography_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette2',
	),
	// hedare account in 
	'header_account_in_style'                   => 'icon_title_label',
	'header_account_in_title'                   => __( 'My Account', 'templatemela-theme-wooti' ),
	'header_account_in_label'                   => __( 'Log Out', 'templatemela-theme-wooti' ),
	'header_account_in_icon_size'               => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette2',
	),
	'header_account_in_title_typography' => array(
		'size' => array(
			'desktop' => 13,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
	),
	'header_account_in_title_typography_color' => array(
		'color' => '#ffffff',
	),
	'header_account_in_typography' => array(
		'size' => array(
			'desktop' => 16,
		),
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'header_account_in_typography_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette2',
	),
	// header mobile account 
	'header_mobile_account_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_account_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette2',
	),
	// header mobile account in 
	'header_mobile_account_in_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_account_in_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette2',
	),
	// Header Contact.
	'header_contact_items' => array(
		'items' => array(
			array(
				'id' => 'phone',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'link' => '',
				'icon' => 'phoneAlt2',
				'title' => 'Need Help?',
				'label' => __( '+00 123-456-789', 'templatemela-theme-wooti' ),
			),
		),
	),
	'header_contact_icon_size' => array(
		'size' => 25,
		'unit' => 'px',
	),
	'header_contact_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette1',
	),
	'header_contact_typography' => array(
		'size' => array(
			'desktop' => 16,
		),
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	// Widget Toggle.
	'header_toggle_widget_label'  => 'Top Offers!',
	'header_toggle_widget_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_toggle_widget_typography'            => array(
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	'header_toggle_widget_close_color'  => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_toggle_widget_padding' => array(
		'size'   => array( 0, 0, 0, 0 ),
		'unit'   => 'em',
		'locked' => false,
	),
	// Header toggle Widget Area.
	'header_widget2_link_colors'       => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
	),
	'header_toggle_widget_pop_background' => array(
		'desktop' => array(
			'color' => 'palette9',
		),
	),
	'header_widget2_title'        => array(
		'size' => array(
			'desktop' => 20,
		),
		'color'   => 'palette3',
	),
	'header_widget2_content'        => array(
		'size' => array(
			'desktop' => 15,
		),
		'weight'  => '500',
		'color'   => 'palette3',
	),
);
$more_addons = array(
	// Vertical Navigation.
	'vertical_navigation_item_border' => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
		'color' => 'var(--global-gray-400)',
	),
	'vertical_navigation_border' => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
		'color' => 'palette1',
	),
	'vertical_heading_color'            => array(
		'color'  => 'palette3',
		'hover'  => 'palette3',
		'active' => 'palette3',
	),
	'vertical_navigation_color'            => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
		'active' => 'palette1',
	),
	'vertical_navigation_background'       => array(
		'color'  => 'palette9',
	),
	'vertical_navigation_typography'        => array(
		'lineHeight' => array(
			'desktop' => 1.75,
		),
	),
	'vertical_navigation_spacing'          => array(
		'size' => 2.2,
		'unit' => 'em',
	),
	'vertical_navigation_vertical_spacing' => array(
		'size' => 9,
		'unit' => 'px',
	),
	// Header Search Advanced.
	'header_search_advanced_width' => array(
		'size' => array(
			'desktop' => 620,
		),
	),
	'header_search_advanced_buttons_background' => array(
		'color'  => 'palette2',
		'hover'  => 'palette2',
	),
	'header_search_advanced_buttons_color' => array(
		'color'  => '#000000',
		'hover'  => '#000000',
	),
	'header_search_advanced_border' => array(
		'width' => 0,
		'unit'  => 'px',
		'style' => 'solid',
	),
	'header_search_advanced_border_radius' => array(
		'size'   => array( 5, 5, 5, 5 ),
		'unit'   => 'px',
		'locked' => true,
	),
	'header_search_advanced_category_color' => array(
		'color'  => 'palette3',
		'hover'  => 'palette3',
	),
	'header_search_advanced_button_typography'        => array(
		'size' => array(
			'desktop' => 20,
		),
	),
	'header_search_advanced_button_radius' => array(
		'size'   => array( 0 , 5 , 5 , 0 ),
		'unit'   => 'px',
		'locked' => true,
	),
	'header_search_advanced_button_padding' => array(
		'size'   => array( 8, 12, 7, 12 ),
		'unit'   => 'px',
		'locked' => false,
	),
);
$woo_addons = array(
	'product_filter_widget_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_filter_widget_title' => array(
		'size' => array(
			'desktop' => 17,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => 'palette3',
	), 
);
$dark_mode_addons = array(
	'dark_mode_custom_logo'        => true,
 );