<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Theme
 * @since 1.0
 */

$default_options = array(
	// container 
	'content_width'   => array(
		'size' => 1430,
		'unit' => 'px',
	),
	// Sidebar.
	'sidebar_width'   => array(
		'size' => 300,
		'unit' => 'px',
	),
	'sidebar_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 16,
		),
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'sidebar_link_style' => 'plain',
	// scroll up
	'scroll_up_icon'          => 'chevron-up',
	'scroll_up_padding' => array(
		'size'   => array( 
			'desktop' => array( 8, 8, 8, 8 ),
		),
		'unit'   => array(
			'desktop' => 'px',
		),
	),
	'scroll_up_icon_size'   => array(
		'size' => array(
			'mobile'  => 16,
			'desktop' =>  20,
		),
		'unit' => array(
			'mobile'  => 'px',
			'desktop' => 'px',
		),
	),
	'scroll_up_color'                     => array(
		'color'  => 'palette9',
		'hover'  => 'palette9',
	),
	'scroll_up_background'                     => array(
		'color'  => 'palette1',
		'hover'  => 'palette2',
	),
	'scroll_up_border_colors'         => array(
		'color'  => 'palette1',
		'hover'  => 'palette2',
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.7,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'=> 'px',
		'family'  => 'Inter',
		'google'  => true,	
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette4',
	),
	'heading_font' => array(
		'family' => 'Inter',
	),
	'h1_font' => array(
		'size' => array(
			'mobile' => 22,
			'tablet' => 28,
			'desktop' => 32,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'desktop' => 30,
			'tablet' => 26,
			'mobile' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.35,
			'mobile' => 1.33,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'desktop' => 26,
			'tablet' => 24,
			'mobile' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.38,
			'mobile' => 1.4,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'desktop' => 24,
			'tablet' => 20,
			'mobile' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
			'mobile' => 1.3,	
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'desktop' => 20,
			'mobile' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
			'mobile' => 1.3,	
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
			'mobile' => 1.3,	
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'title_above_font' => array(
		'size' => array(
			'mobile' => 20,
			'tablet' => 22,
			'desktop' => 28,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'title_above_breadcrumb_font' => array(
		'color'   => 'palette3',
	),
	// Buttons.
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => 50,
		),
	),
	'buttons_typography'    => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 2,
		),
		'transform' => 'capitalize',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'buttons_padding'        => array(
		'size'   => array( 
			'desktop' => array( 8, 38, 8, 38 ),
			'mobile' => array( 5 , 20 , 5 , 20 ),
		),
	),
	// Header.
	'header_desktop_items'       => array(
		'top' => array(
			'top_left'         => array(),
			'top_center'       => array( 'html' ),
			'top_right'        => array(),
		),
		'main' => array(
			'main_left'         => array( 'logo' ),
			'main_center'       => array( 'navigation' ),
			'main_right'        => array( 'search', 'account', 'wishlist', 'cart' ),
		),
		'bottom' => array(
			'bottom_left'         => array( ),
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_center' => array( 'mobile-html' ),
		),
		'main' => array(
			'main_left'   => array( 'popup-toggle', 'mobile-logo'),
			'main_right'  => array('search','mobile-account','wishlist', 'mobile-cart'),
		),
		'bottom' => array(
			'bottom_center'   => array(),
		),
	),
	// Header Top.
	'header_top_height'       => array(
		'size' => array(
			'desktop' => 40,
		),
	),
	'header_top_background'    => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	// Header Main.
	'header_main_height' => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 80,
			'desktop' => 100,
		),
	),
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	),
	// Mobile Trigger.
	'mobile_trigger_icon_size'   => array(
		'size' => 22,
		'unit' => 'px',
	),
	'mobile_trigger_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// Header HTML.
	'header_html_content'    =>  __( 'Free shipping for orders over $ 100! ', 'templatemela-plugin-wooti' ),
	'header_html_typography' => array(
		'size' => array(
			'desktop' => 15,
		),
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette9',
	),
	'header_html_wpautop' => false,
	// Mobile Header HTML.
	'mobile_html_content'    => __( 'Free shipping on orders over $100!', 'templatemela-plugin-wooti' ),
	'mobile_html_typography' => array(
		'size' => array(
			'desktop' => 14,
		),
		'color'   => 'palette9',
	),
	'mobile_html_wpautop' => false,
	// Header Cart.
	'header_cart_icon' => 'shopping-cart',
	'header_cart_icon_size'   => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_cart_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_cart_total_background'              => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	// Mobile Header Cart.
	'header_mobile_cart_icon' => 'shopping-cart',
	'header_mobile_cart_icon_size'   => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_mobile_cart_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_mobile_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_mobile_cart_total_background'              => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	'header_search_icon_size' => array(
		'size' => array(
			'desktop' => 26,
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_search_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// logo 
	'logo_layout'     => array(
		'include' => array(
			'mobile'  => 'logo_only',
			'tablet'  => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	// Navigation.
	'primary_navigation_typography'            => array(
		'size' => array(
			'desktop' => 15,
		),
		'weight'  => '500',
		'variant' => '500',
	),
	'primary_navigation_spacing'            => array(
		'size' => 40,
		'unit' => 'px',
	),
	'primary_navigation_vertical_spacing'   => array(
		'size' => 37,
		'unit' => 'px',
	),
	'primary_navigation_color'   => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
		'active' => 'palette3',
	),
	// Dropdown.
	'dropdown_navigation_typography'            => array(
		'size' => array(
			'desktop' => 14,
		),
	),
	'dropdown_navigation_color'              => array(
		'color'  => 'palette4',
		'hover'  => 'palette1',
		'active' => 'palette1',
	),
	// mobile navigation 
	'mobile_navigation_color'              => array(
		'color'  => 'palette3',
		'hover'  => 'palette3',
		'active' => 'palette3',
	),
	// Footer.
	'footer_items'       => array(
		'top' => array(
			'top_1' => array(),
		),
		'middle' => array(
			'middle_1' => array('footer-widget1'),
			'middle_2' => array('footer-widget2'),
			'middle_3' => array('footer-widget3'),
			'middle_4' => array('footer-widget4' ,  'footer-social'),
		),
		'bottom' => array(
			'bottom_1' => array('footer-html'),
			'bottom_2' => array('footer-widget5'),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	//footer middle
	'footer_middle_columns' => '4',
	'footer_middle_top_spacing' => array(
		'size' => array(
			'mobile' => '20',
			'tablet' => '50',
			'desktop' => '70',
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'mobile' => '40',
			'tablet' => '50',
			'desktop' => '75',
		),
	),
	'footer_middle_layout'  => array(
		'mobile'  => 'row',
		'tablet'  => 'two-grid',
		'desktop' => 'column',
	),
	'footer_middle_direction'         => array(
		'desktop' => 'column',
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'mobile' => '30',
			'tablet' => '40',
			'desktop' => '30',
		),
	),
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit' => 'px',
			'style' => 'dashed',
			'color' => 'rgba(255,255,255,0.2)',
		),
	),
	'footer_middle_widget_title'  => array(
		'size' => array(
			'desktop' => 22,
			'tablet' => 20,
			'mobile' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => '#fff',
	),
	'footer_middle_widget_content' => array(
		'lineHeight' => array(
			'desktop' => 1.7,
		),
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'rgba(255,255,255,0.6)',
	),
	'footer_middle_link_colors' => array( 
		'color' => 'rgba(255,255,255,0.6)',
		'hover' => '#fff',
	),
	'footer_middle_link_style' => 'noline',
	// Footer Bottom.
	'footer_bottom_columns' => '2',
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'desktop' => 0,
			'tablet' => 15,
		),
	),
	'footer_bottom_top_spacing' => array(
		'size' => array(
			'desktop' => 20,
		),
	),
	'footer_bottom_link_style' => 'noline',
	// footer html 
	'footer_html_typography' => array(
		'color'   => 'rgba(255,255,255,0.6)',
	),
	'footer_html_link_color'              => array(
		'color' => 'rgba(255,255,255,0.6)',
		'hover' => '#fff',
	),
	'footer_html_align'         => array(
		'tablet'  => 'center',
	),
	'footer_html_vertical_align'         => array(
		'desktop' => 'middle',
	),
	// footer widget7
	'footer_widget5_align'         => array(
		'desktop'  => 'right',
		'tablet'  => 'center',
	),
	'footer_widget5_vertical_align'         => array(
		'desktop' => 'middle',
	),
	// Footer Social.
	'footer_social_items' => array(
		'items' => array(
			array(
				'id' => 'facebook',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'facebookAlt2',
				'label' => __( 'Facebook', 'templatemela-plugin-wooti' ),
			),
			array(
				'id'      => 'twitter',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'twitterAlt2',
				'label'   =>  __( 'X', 'templatemela-plugin-wooti' ),
			),
			array(
				'id' => 'linkedin',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'linkedin',
				'label' => __( 'linkedin', 'templatemela-plugin-wooti' ),
			),
			array(
				'id' => 'rss',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'rssAlt',
				'label' => __( 'rss', 'templatemela-plugin-wooti' ),
			),
			array(
				'id'      => 'instagram',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'instagram',
				'label' => __( 'Instagram', 'templatemela-plugin-wooti' ),
			),
		),
	),
	'footer_social_style'        => 'filled',
	'footer_social_item_spacing' => array(
		'size' => 0.7,
		'unit' => 'em',
	),
	'footer_social_icon_size' => array(
		'size' => 1.2,
		'unit' => 'em',
	),
	'footer_social_brand' => 'onhover',
	'footer_social_color' => array(
		'color' => 'palette1',
	),
	'footer_social_background' => array(
		'color' => '#fff',
	),
	'footer_social_border_radius' => array(
		'size' => 100,
		'unit' => '%',
	),
	'footer_social_align'         => array(
		'desktop' => 'left',
	),
	'footer_social_margin' => array(
		'size'   => array( 20,0,0,0 ),
		'unit'   => 'px',
		'locked' => false,
	),
	// product 
	'product_archive_button_style' => 'button',
	'product_related_columns'    => '4',
	'product_upsell_columns'    => '4',
	'product_archive_title_font'   => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'lineType' => 'em',
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'=> 'px',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'product_archive_price_font'   => array(
		'size' => array(
			'desktop' => 16,
			'tablet' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
			'mobile' => 1.5,
		),
		'lineType'=> 'em',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'product_title_font'   => array(
		'size' => array(
			'mobile' => 18,
			'tablet' => 20,
			'desktop' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'lineType' => 'em',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	// product archive 
	'product_above_title_font'   => array(
		'size' => array(
			'desktop' => 25,
		),
		'lineHeight' => array(
			'desktop' => 1.36,
		),
		'lineType' => 'em',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	// Breadcrumbs
	'product_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'page_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'search_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);

$header_addons = array(
	// header account
	'header_account_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// hedare account in 
	'header_account_in_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// header mobile account 
	'header_mobile_account_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// header mobile account in 
	'header_mobile_account_in_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);
$more_addons = array(
	'header_wishlist_icon_size'   => array(
		'size' => array(
			'desktop' => '24',
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_wishlist_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_wishlist_total_color'              => array(
		'color' => 'palette9',
	),
	'header_wishlist_total_background'              => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
);
$woo_addons = array(
	'product_filter_widget_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_filter_widget_title' => array(
		'size' => array(
			'desktop' => 16,
			'mobile' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
			'tablet' => 1.7,
		),
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	'product_filter_widget_content'        => array(
		'size' => array(
			'desktop' => 14,
		),
	),
);


$dark_mode_addons = array(
	'dark_mode_custom_logo'        => true,
 );