<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Theme
 * @since 1.0
 */

$default_options = array(
	'content_width' => array(
		'size' => 1430,
		'unit' => 'px',
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'desktop' => 16,
			'mobile' => 15,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'family' => 'Jost',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette4',
	),
	'heading_font' => array(
		'family' => 'Prata',
	),
	'h1_font' => array(
		'size' => array(
			'desktop' => 36,
			'tablet' => 30,
			'mobile' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'letterSpacing' => array(
			'desktop' => 0,
		),
		'spacingType' => 'px',
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'mobile' => 22,
			'desktop' => 28,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'desktop' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'desktop' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'desktop' => 20,
			'tablet' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'letterSpacing' => array(
			'desktop' => 0,
		),
		'spacingType' => 'px',
		'family' => 'inherit',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'title_above_font' => array(
		'size' => array(
			'desktop' => 28,
		),
	),
	'title_above_breadcrumb_font' => array(
		'size' => array(
			'desktop' => 16,
			'mobile' => 15,
		),
		'color' => 'palette3',
	),
	// Buttons.
	'buttons_color' => array(
		'color' => 'palette3',
		'hover' => 'palette9',
	),
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => 5,
		),
	),
	'buttons_typography' => array(
		'size' => array(
			'desktop' => 14,
			'mobile' => 13,
		),
		'lineHeight' => array(
			'desktop' => 1.9,
			'mobile' => 1.8,
		),
		'family' => 'Jost',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'transform' => 'uppercase',
	),
	'buttons_padding' => array(
		'size' => array( 
			'desktop' => array( 8, 30, 8, 30 ),
			'tablet' => array( 8, 20, 8, 20 ),
			'mobile' => array( 8, 15, 8, 15 ),
		),
	),
	// Links.
	'link_color' => array(
		'highlight' => 'palette2',
		'highlight-alt' => 'palette2',
		'highlight-alt2' => 'palette9',
		'style' => 'no-underline',
	),
	// Logo
	'logo_layout' => array(
		'include' => array(
			'mobile' => 'logo_only',
			'tablet' => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	// Header.
	'header_desktop_items' => array(
		'top' => array(
			'top_center' => array('html'),
		),
		'main' => array(
			'main_left' => array( 'search-advanced'),
			'main_center' => array('logo'),
			'main_right' => array( 'wishlist' ,'account', 'cart'),
		),
		'bottom' => array(
			'bottom_center' => array('navigation'),
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_center' => array( 'mobile-html' ),
		),
		'main' => array(
			'main_left' => array( 'popup-toggle', 'mobile-logo' ),
			'main_right' => array( 'wishlist', 'mobile-account', 'mobile-cart'),
		),
		'bottom' => array( 
			'bottom_center' => array( 'search-advanced' ),
		),
	),
	//logo
	'logo_layout' => array(
		'include' => array(
			'mobile' => 'logo',
			'tablet' => 'logo',
			'desktop' => 'logo_only',
		),
	),
	// Header Cart.
	'header_cart_icon' => 'shopping-cart',
	'header_cart_icon_size' => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_cart_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'header_cart_total_color' => array(
		'color' => '#000000',
	),
	'header_cart_total_background' => array(
		'color' => 'palette1',
	),
	'header_cart_padding' => array(
		'size' => array( 0, 0, 0, 5 ),
		'unit' => 'px',
		'locked' => false,
	),
	// Mobile Header Cart.
	'header_mobile_cart_icon' => 'shopping-cart',
	'header_mobile_cart_icon_size' => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_cart_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'header_mobile_cart_total_color' => array(
		'color' => '#000000',
	),
	'header_mobile_cart_total_background' => array(
		'color' => 'palette1',
	),
	// Header Top.
	'header_top_height' => array(
		'size' => array(
			'desktop' => 40,
			'tablet' => 35,
		),
	),
	'header_top_background' => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	// Header Main.
	'header_main_height' => array(
		'size' => array(
			'desktop' => 90,
			'tablet' => 80,
			'mobile' => 70,
		),
	),
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
		'tablet' => array(
			'width' => 1,
			'unit' => 'px',
			'style' => 'solid',
			'color' => 'var(--global-gray-400)',
		),
	 ),
	// Header HTML.
	'header_html_content' => __( 'Free Express Shipping on orders $100!', 'templatemela-theme-wooti' ),
	'header_html_typography' => array(
		'size' => array(
			'desktop' => 15,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => '#000000',
	),
	'header_html_wpautop' => false,
	// mobile html 
	'mobile_html_wpautop' => false,
	'mobile_html_typography' => array(
		'color' => '#000000',
	),
	// primary Navigation.
	'primary_navigation_typography' => array(
		'size' => array(
			'desktop' => 14,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'transform' => 'uppercase',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
	),
	'primary_navigation_spacing' => array(
		'size' => 50,
		'unit' => 'px',
	),
	'primary_navigation_vertical_spacing' => array(
		'size' => 18,
		'unit' => 'px',
	),
	'primary_navigation_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
		'active' => 'palette6',
	),
	// Mobile Trigger.
	'mobile_trigger_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	// header serach 
	'header_search_icon_size' => array(
		'size' => array(
			'desktop' => 22,
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_search_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'header_search_padding' => array(
		'size' => array( 0, 0, 0, 20 ),
		'unit' => 'px',
		'locked' => false,
	),
	//dropdown
	'dropdown_navigation_typography' => array(
		'size' => array(
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'transform' => 'capitalize',
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
	),
	'dropdown_navigation_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
		'active' => 'palette6',
	),
	// Footer.
	'footer_items' => array(
		'top' => array(
			'top_1' => array(),
		),
		'middle' => array(
			'middle_1' => array( 'footer-widget1' ),
			'middle_2' => array( 'footer-widget2' ),
			'middle_3' => array( 'footer-widget3' ),
			'middle_4' => array( 'footer-widget4' ),
		),
		'bottom' => array(
			'bottom_1' => array( 'footer-html' ),
			'bottom_2' => array( 'footer-widget5' ),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette7',
		),
	),
	//footer middle
	'footer_middle_columns' => '4',
	'footer_middle_top_spacing' => array(
		'size' => array(
			'mobile' => '40',
			'tablet' => '50',
			'desktop' => '0',
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'mobile' => '40',
			'tablet' => '50',
			'desktop' => '0',
		),
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'mobile' => '30',
			'tablet' => '60',
			'desktop' => '110',
		),
	),
	'footer_middle_column_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit' => 'px',
			'style' => 'solid',
			'color' => 'var(--global-gray-400)',
		),
		'mobile' => array(
			'width' => 0,
			'unit' => 'px',
			'style' => 'solid',
			'color' => 'var(--global-gray-400)',
		),
	),
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit' => 'px',
			'style' => 'solid',
			'color' => 'var(--global-gray-400)',
		),
	),
	'footer_middle_layout' => array(
		'mobile' => 'row',
		'tablet' => 'two-grid',
		'desktop' => 'center-half',
	),
	'footer_middle_widget_content' => array(
		'color' => 'palette3',
	),
	'footer_middle_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'footer_middle_widget_title' => array(
		'size' => array(
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'family' => 'Jost',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => 'palette3',
	),
	'footer_middle_link_style' => 'noline',
	//footer bottom
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'mobile' => 10,
			'tablet' => 15,
			'desktop' => 30,
		),
	),
	'footer_bottom_top_spacing' => array(
		'size' => array(
			'mobile' => '15',
			'desktop' => '25',	
		),
	),
	'footer_bottom_bottom_spacing' => array(
		'size' => array(
			'mobile' => '',
			'tablet' => '80',
			'desktop' => '90',
		),
	),
	'footer_bottom_widget_content_color' => array(
		'color' => 'palette3',
	),
	'footer_bottom_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'footer_bottom_columns' => '2',
	'footer_bottom_link_style' => 'noline',
	// Footer Widget 5.
	'footer_widget5_align' => array(
		'tablet' => 'center',
		'desktop' => 'right',
	),
	// Footer html.
	'footer_html_align' => array(
		'tablet' => 'center',
	),
	'footer_html_typography' => array(
		'color' => 'palette3',
	),
	//product archive
	'product_archive_button_style' => 'button',
	'product_archive_title_font' => array(
		'size' => array(
			'desktop' => 18,
			'mobile' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'lineType' => 'em',
		'family' => 'Jost',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'product_archive_price_font' => array(
		'size' => array(
			'desktop' => 16,
			'mobile' => 15,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => 'palette3',
	),
	'product_title_font' => array(
		'size' => array(
			'mobile' => 24,
			'desktop' => 25,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
	),
	//post archive
	'post_archive_item_title_font' => array(
		'size' => array(
			'desktop' => 24,
			'tablet' => 20,
			'mobile' => 18,
		),
	),
	// Sidebar.
	'sidebar_width' => array(
		'size' => 270,
		'unit' => 'px',
	),
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => 'palette3',
	),
	'sidebar_link_style' => 'plain',
	'sidebar_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	// Breadcrumbs
	'product_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'page_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'post_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'post_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'search_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
);
$header_addons = array(
	// header account 
	'header_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'header_account_icon_size' => array(
		'size' => 23,
		'unit' => 'px',
	),
	// header account in 
	'header_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'header_account_in_icon_size' => array(
		'size' => 23,
		'unit' => 'px',
	),
	// Mobile Header Account.
	'header_mobile_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'header_mobile_account_icon_size' => array(
		'size' => 21,
		'unit' => 'px',
	),
	// Mobile Header Account in
	'header_mobile_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'header_mobile_account_in_icon_size' => array(
		'size' => 21,
		'unit' => 'px',
	),
);
$more_addons = array(
	// Header Search Advanced.
	'header_search_advanced_width' => array(
		'size' => array(
			'desktop' => 280,
			'tablet' => 500,
		),
	),
	'header_search_advanced_border_radius' => array(
		'size' => array( 5, 5, 5, 5 ),
		'unit' => 'px',
		'locked' => true,
	),
	'header_search_advanced_buttons_background' => array(
		'color' => 'transparent',
		'hover' => 'transparent',
	),
	'header_search_advanced_buttons_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'header_search_advanced_button_typography' => array(
		'size' => array(
			'desktop' => 22,
		),
	),
	'header_search_advanced_border' => array(
		'width' => 1,
		'unit' => 'px',
		'style' => 'solid',
	),
	'header_search_advanced_border_color' => array(
		'color' => 'var(--global-gray-400)',
	),
	'header_search_advanced_background' => array(
		'color' => 'palette9',
	),
	//wishlist
	'header_wishlist_icon_size' => array(
		'size' => array(
			'desktop' => 23,
			'tablet' => 20,
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_wishlist_color' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
	'header_wishlist_total_color' => array(
		'color' => '#000000',
		'hover' => '#000000',
	),
	'header_wishlist_total_background' => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
);
$woo_addons = array(
	'product_filter_widget_title' => array(
		'size' => array(
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
		'color' => 'palette3',
	),
	'product_filter_widget_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette6',
	),
);
$dark_mode_addons = array(
	'dark_mode_custom_logo' => true,
 );