<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Theme
 * @since 1.0
 */

$default_options = array(
	'content_width' => array(
		'size' => 1710,
		'unit' => 'px',
	),
	// Logo
	'logo_layout'     => array(
		'include' => array(
			'mobile'  => 'logo_only',
			'tablet'  => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'mobile' => 1.5,
			'desktop' => 1.7,
		),
		'family'  => 'Inter',
		'google'  => true,	
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette4',
	),
	'heading_font' => array(
		'family' => 'inherit',
	),
	'h1_font' => array(
		'size' => array(
			'mobile' => 22,
			'tablet' => 26,
			'desktop' => 38,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'google'  => true,
		'weight'  => '700',
		'variant' => '700',
		'color'   => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'mobile' => 22,
			'desktop' => 28,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '700',
		'variant' => '700',
		'color'   => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'mobile' => 19,
			'tablet' => 22,
			'desktop' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'desktop' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'mobile' => 18,
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'mobile' => 16,
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'title_above_font' => array(
		'size' => array(
			'mobile' => 24,
			'tablet' => 28,
			'desktop' => 32,
		),
	),
	'title_above_breadcrumb_font' => array(
		'size' => array(
			'desktop' => 14,
		),
	),
	// Buttons.
	'buttons_color'                     => array(
		'color'  => 'palette9',
		'hover'  => 'palette9',
	),
	'buttons_background' => array(
		'color'  => 'palette2',
		'hover'  => 'palette1',
	),
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => 0,
		),
	),
	'buttons_typography'    => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.8,
			'tablet' => 1.9,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'transform' => 'capitalize',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	'buttons_padding'        => array(
		'size'   => array( 
			'mobile' => array( 6, 15, 6, 15 ),
			'tablet' => array( 8, 15, 8, 15 ),
			'desktop' => array( 9, 22, 9, 22 ),
		),
	),
	// Header.
	'header_desktop_items'       => array(
		'top' => array(
			'top_left'         => array( 'navigation-2' ),
			'top_center'       => array( 'html' ),
			'top_right'        => array( 'html2' ),
		),
		'main' => array(
			'main_left'         => array( 'logo', 'search-advanced'),
			'main_right'        => array('contact', 'divider', 'account', 'divider2', 'cart'),
		),
		'bottom' => array(
			'bottom_left'         => array( 'navigation'),
			'bottom_right'        => array('toggle-widget'),
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_center' => array( 'mobile-html' ),
		),
		'main' => array(
			'main_left'   => array( 'popup-toggle', 'mobile-logo'),
			'main_right'  => array('search','mobile-account', 'mobile-cart'),
		),
		'bottom' => array(
			'bottom_center'   => array(),
		),
	),
	// Header Top.
	'header_top_height'       => array(
		'size' => array(
			'mobile' => 30,
			'desktop' => 40,
		),
	),
	'header_top_background'    => array(
		'desktop' => array(
			'color' => 'palette2',
		),
	),
	// Header Main.
	'header_main_height' => array(
		'size' => array(
			'mobile'  => 60,
			'tablet'  => 80,
			'desktop' => 90,
		),
	),
	// Header Bottom.
	'header_bottom_height'       => array(
		'size' => array(
			'desktop' => 60,
		),
	),
	'header_bottom_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'var(--global-gray-400)',
		),
	),
	// Header Search.
	'header_search_label_visiblity' => array(
		'mobile'  => true,
	),
	'header_search_icon_size' => array(
		'size' => array(
			'tablet'  => 20,
			'mobile'  => 20,
		),
		'unit' => array(
			'tablet'  => 'px',
			'mobile'  => 'px',
		),
	),
	'header_search_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// Mobile Trigger.
	'mobile_trigger_icon_size'   => array(
		'size' => 22,
		'unit' => 'px',
	),
	'mobile_trigger_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// Header HTML.
	'header_html_content'    =>  __( 'Save up to 20% on all Toys with “FLAT26OFF” code', 'templatemela-plugin-wooti' ),
	'header_html_typography' => array(
		'color'   => 'palette9',
	),
	'header_html_wpautop' => false,
	// Mobile Header HTML.
	'mobile_html_typography' => array(
		'color'   => 'palette9',
	),
	'mobile_html_wpautop' => false,
	// Header Cart.
	'header_cart_title' =>  __( 'Cart', 'templatemela-plugin-wooti' ),
	'header_cart_label' =>  __( 'Item', 'templatemela-plugin-wooti' ),
	'header_cart_icon' => 'shopping-cart',
	'header_cart_icon_size'   => array(
		'size' => 25,
		'unit' => 'px',
	),
	'header_cart_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_cart_total_background'              => array(
		'color' => 'palette1',
	),
	'header_cart_title_typography'            => array(
		'size' => array(
			'desktop' => 12,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'header_cart_typography'            => array(
		'size' => array(
			'desktop' => 15,
		),
		'weight'  => '600',
		'variant' => '600',
	),
	'header_cart_title_color'              => array(
		'color' => 'palette3',
	),
	// Mobile Header Cart.
	'header_mobile_cart_icon' => 'shopping-cart',
	'header_mobile_cart_icon_size'   => array(
		'size' => 20,
		'unit' => 'px',
	),
	'header_mobile_cart_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_mobile_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_mobile_cart_total_background'              => array(
		'color' => 'palette1',
	),
	// logo 
	'logo_layout'     => array(
		'include' => array(
			'mobile'  => 'logo',
			'tablet'  => 'logo',
			'desktop' => 'logo_only',
		),
	),
	// Navigation.
	'primary_navigation_typography'            => array(
		'size' => array(
			'desktop' => 15,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'primary_navigation_spacing'            => array(
		'size' => 40,
		'unit' => 'px',
	),
	'primary_navigation_vertical_spacing'   => array(
		'size' => 18,
		'unit' => 'px',
	),
	'primary_navigation_color'   => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
		'active' => 'palette3',
	),
	// Secondary Navigation.
	'secondary_navigation_typography'            => array(
		'size' => array(
			'desktop' => 14,
		),
	),
	'secondary_navigation_spacing'            => array(
		'size' => 36,
		'unit' => 'px',
	),
	'secondary_navigation_color'   => array(
		'color'  => 'palette9',
		'hover'  => 'palette9',
		'active' => 'palette9',
	),
	//dropdown
	'dropdown_navigation_color'              => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
		'active' => 'palette3',
	),
	// mobile navigation 
	'mobile_navigation_color'              => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
		'active' => 'palette1',
	),
	// Sidebar.
	'sidebar_width'   => array(
		'size' => 270,
		'unit' => 'px',
	),
	'sidebar_link_style' => 'plain',
	// Footer.
	'footer_items'       => array(
		'top' => array(
			'top_1' => array('footer-widget1'),
		),
		'middle' => array(
			'middle_1' => array('footer-widget2', 'footer-widget3'),
			'middle_2' => array('footer-widget4', 'footer-widget5', 'footer-widget6'),
		),
		'bottom' => array(
			'bottom_1' => array('footer-html'),
			'bottom_2' => array('footer-widget7'),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette9',
		),
	),
	// Footer Top.
	'footer_top_columns' => '1',
	'footer_top_background' => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	'footer_top_top_spacing' => array(
		'size' => array(
			'mobile'  => 20,
			'tablet'  => 30,
			'desktop' => 40,
		),
	),
	'footer_top_bottom_spacing' => array(
		'size' => array(
			'mobile'  => 20,
			'tablet'  => 30,
			'desktop' => 40,
		),
	),
	'footer_top_widget_title'  => array(
		'size' => array(
			'mobile' => '16',
			'tablet' => '20',
			'desktop' => '24',
		),
		'color'   => 'palette9',
	),
	'footer_top_widget_content' => array(
		'lineHeight' => array(
			'desktop' => 1.8,
			'mobile' => 1.5,
		),
		'color'   => 'palette9',
	),
	// footer middle 
	'footer_middle_direction'         => array(
		'desktop' => 'row',
		'mobile' => 'column',
	),
	'footer_middle_layout'  => array(
		'mobile'  => 'row',
		'tablet'  => 'row',
		'desktop' => 'equal',
	),
	'footer_middle_widget_spacing' => array(
		'size' => array(
			'desktop' => 0,
		),
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'desktop' => 100,
			'tablet' => 30,
			'mobile' => 30,
		),
	),
	'footer_middle_top_spacing' => array(
		'size' => array(
			'desktop' => 60,
			'tablet'  => 50,
			'mobile'  => 30,
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'desktop' => 60,
			'tablet'  => 50,
			'mobile'  => 30,
		),
	),
	'footer_middle_columns' => '2',
	'footer_middle_widget_title'  => array(
		'size' => array(
			'mobile' => 18,
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'footer_middle_widget_content' => array(
		'lineHeight' => array(
			'desktop' => 2,
		),
		'color'   => 'palette3',
	),
	'footer_middle_link_colors' => array( 
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	),
	'footer_middle_link_style' => 'noline',
	// Footer Bottom.
	'footer_bottom_background' => array(
		'desktop' => array(
			'color' => 'palette7',
		),
	),
	'footer_bottom_columns' => '2',
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'desktop' => 0,
			'tablet' => 15,
		),
	),
	'footer_bottom_top_spacing' => array(
		'size' => array(
			'desktop' => 20,
		),
	),
	'footer_bottom_link_style' => 'noline',
	// footer html 
	'footer_html_typography' => array(
		'color'   => 'palette3',
	),
	'footer_html_link_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'footer_html_align'         => array(
		'tablet'  => 'center',
	),
	'footer_html_vertical_align'         => array(
		'desktop' => 'middle',
	),
	// footer widget7
	'footer_widget7_align'         => array(
		'desktop'  => 'right',
		'tablet'  => 'center',
	),
	'footer_widget7_vertical_align'         => array(
		'desktop' => 'middle',
	),
	// Product Archive Controls.
	'product_related_columns'    => '6',
	'product_upsell_columns'    => '6',
	'product_archive_button_style'       => 'button',
	'product_archive_title_font'   => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineType' => 'em',
	),
	'product_archive_price_font'   => array(
		'color'   => 'palette3',
	),
	'product_title_font'   => array(
		'size' => array(
			'mobile'  => 20,
			'tablet' => 22,
			'desktop' => 24,
		),
		'weight'  => '500',
		'variant' => '500',
	),
	// Breadcrumbs
	'product_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'page_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'search_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);
$header_addons = array(
	// Header Divider.
	'header_divider_border' => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
		'color' => 'var(--global-gray-400)',
	),
	'header_divider_margin' => array(
		'size'   => array( 0, 5, 0, 5 ),
		'unit'   => 'px',
		'locked' => false,
	),
	// Header Divider2.
	'header_divider2_border' => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
		'color' => 'var(--global-gray-400)',
	),
	'header_divider2_margin' => array(
		'size'   => array( 0, 5, 0, 5 ),
		'unit'   => 'px',
		'locked' => false,
	),
	// header account
	'header_account_style'                   => 'icon_title_label',
	'header_account_title'                   => __( 'My Account', 'templatemela-plugin-wooti' ),
	'header_account_label'                   => __( 'Login', 'templatemela-plugin-wooti' ),
	'header_account_icon_size'               => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_account_title_typography' => array(
		'size' => array(
			'desktop' => 12,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'header_account_title_typography_color' => array(
		'color' => 'palette3',
	),
	'header_account_typography' => array(
		'size' => array(
			'desktop' => 15,
		),
		'weight'  => '600',
		'variant' => '600',
	),
	'header_account_typography_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// hedare account in 
	'header_account_in_style'                   => 'icon_title_label',
	'header_account_in_title'                   => __( 'My Account', 'templatemela-plugin-wooti' ),
	'header_account_in_label'                   => __( 'Logout', 'templatemela-plugin-wooti' ),
	'header_account_in_icon_size'               => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_account_in_title_typography' => array(
		'size' => array(
			'desktop' => 12,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'header_account_in_title_typography_color' => array(
		'color' => 'palette3',
	),
	'header_account_in_typography' => array(
		'size' => array(
			'desktop' => 15,
		),
		'weight'  => '600',
		'variant' => '600',
	),
	'header_account_in_typography_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// header mobile account 
	'header_mobile_account_icon_size'               => array(
		'size' => 20,
		'unit' => 'px',
	),
	'header_mobile_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// header mobile account in 
	'header_mobile_account_in_icon_size'               => array(
		'size' => 20,
		'unit' => 'px',
	),
	'header_mobile_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// html 2 
	'header_html2_content'    =>  __( 'Free Shipping on orders over $100!', 'templatemela-plugin-wooti' ),
	'header_html2_typography' => array(
		'color'   => 'palette9'
	),
	// Header Contact.
	'header_contact_items' => array(
		'items' => array(
			array(
				'id' => 'phone',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'link' => '',
				'icon' => 'phoneAlt2',
				'title' => 'Need Help?',
				'label' => __( '+00 123-456-789', 'templatemela-plugin-wooti' ),
			),
		),
	),
	'header_contact_icon_size' => array(
		'size' => 25,
		'unit' => 'px',
	),
	'header_contact_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_contact_typography' => array(
		'size' => array(
			'desktop' => 15,
		),
		'weight'  => '600',
		'variant' => '600',
	),
	// Widget Toggle.
	'header_toggle_widget_label'  => 'Top Offers!',
	'header_toggle_widget_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_toggle_widget_typography'            => array(
		'weight'  => 500,
	),
	'header_toggle_widget_close_color'  => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_toggle_widget_padding' => array(
		'size'   => array( 0, 0, 0, 0 ),
		'unit'   => 'em',
		'locked' => false,
	),
	// Header toggle Widget Area.
	'header_widget2_link_colors'       => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
	),
	'header_toggle_widget_pop_background' => array(
		'desktop' => array(
			'color' => 'palette9',
		),
	),
	'header_widget2_title'        => array(
		'size' => array(
			'desktop' => 20,
		),
		'color'   => 'palette3',
	),
	'header_widget2_content'        => array(
		'size' => array(
			'desktop' => 15,
		),
		'weight'  => '500',
		'color'   => 'palette3',
	),
);
$more_addons = array(
	// Header Search Advanced.
	'header_search_advanced_width' => array(
		'size' => 620,
		'unit' => 'px',
	),
	'header_search_advanced_border_color'       => array(
		'color'  => 'transparent',
	),
	'header_search_advanced_border_radius' => array(
		'size'   => array( 30, 30, 30, 30 ),
		'unit'   => 'px',
		'locked' => true,
	),
	// Category-Box
	'header_search_advanced_category_typography' => array(
		'size' => array(
			'desktop' => 14,
		),
	),
	'header_search_advanced_category_color' => array(
		'color'  => 'palette3',
	),
	// Input
	'header_search_advanced_typography'        => array(
		'size' => array(
			'desktop' => 14,
		),
	),
	'header_search_advanced_background'       => array(
		'color'  => 'palette7',
	),
	// Button
	'header_search_advanced_buttons_background' => array(
		'color'  => 'transparent',
		'hover'  => 'transparent',
	),
	'header_search_advanced_buttons_color' => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
	),
	'header_search_advanced_button_typography'        => array(
		'size' => array(
			'desktop' => 18,
		),
	),
);
$woo_addons = array(
	'product_filter_widget_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);
$dark_mode_addons = array(
	'dark_mode_custom_logo' => true,
);