<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Theme
 * @since 1.0
 */

$default_options = array(
	// container 
	'content_width'   => array(
		'size' => 1710,
		'unit' => 'px',
	),
	// Links.
	'link_color'                     => array(
		'highlight'      => 'palette1',
		'highlight-alt'  => 'palette2',
		'highlight-alt2' => 'palette9',
		'style'          => 'no-underline',
	),	
	// sidebar 
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 20,
		),
		'weight'  => '500',
		'variant' => '500',
	),
	'sidebar_width'   => array(
		'size' => 285,
		'unit' => 'px',
	),
	'sidebar_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'sidebar_link_style' => 'plain',
	// Typography.
	'base_font' => array(
		'size' => array(
			'desktop' => 16,
			'tablet' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'letterSpacing' => array(
			'desktop' => 0.15,
		),
		'spacingType'  => 'px',
		'family'  => 'Jost',
		'google'  => true,	
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette4',
	),
	'heading_font' => array(
		'family' => 'Jost',
	),
	'h1_font' => array(
		'size' => array(
			'desktop' => 32,
			'tablet' => 28,
			'mobile' => 26,
		),
		'lineHeight' => array(
			'desktop' => 1.25,
			'mobile' => 1.2,
		),
		'letterSpacing' => array(
			'desktop' => 0,
		),
		'spacingType'  => 'px',
		'family'  => 'Jost',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'desktop' => 28,
			'tablet' => 26,
			'mobile' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.35,
			'mobile' => 1.33,
		),
		'letterSpacing' => array(
			'desktop' => 0.15,
		),
		'family'  => 'Jost',
		'spacingType'  => 'px',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'desktop' => 26,
			'tablet' => 24,
			'mobile' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.38,
			'mobile' => 1.4,
		),
		'letterSpacing' => array(
			'desktop' => 0.15,
		),
		'spacingType'  => 'px',
		'family'  => 'Jost',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'desktop' => 24,
			'tablet' => 22,
			'mobile' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
			'mobile' => 1.3,	
		),
		'letterSpacing' => array(
			'desktop' => 0,
		),
		'spacingType'  => 'px',
		'family'  => 'Jost',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'desktop' => 22,
			'tablet' => 20,
			'mobile' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
			'mobile' => 1.4,
		),
		'letterSpacing' => array(
			'desktop' => 0.15,
		),
		'spacingType'  => 'px',
		'family'  => 'Jost',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'desktop' => 18,
			'tablet' => 16,
			'mobile' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'google'  => true,
		'family'  => 'Jost',
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'title_above_breadcrumb_font' => array(
		'color'   => 'palette3',
	),
	// scroll up
	'scroll_up_icon'          => 'chevron-up',
	'scroll_up_padding' => array(
		'size'   => array( 
			'desktop' => array( 8, 8, 8, 8 ),
		),
		'unit'   => array(
			'desktop' => 'px',
		),
	),
	'scroll_up_icon_size'   => array(
		'size' => array(
			'mobile'  => 16,
			'desktop' =>  20,
		),
		'unit' => array(
			'mobile'  => 'px',
			'desktop' => 'px',
		),
	),
	'scroll_up_color'                     => array(
		'color'  => 'palette9',
		'hover'  => 'palette9',
	),
	'scroll_up_background'                     => array(
		'color'  => 'palette1',
		'hover'  => 'palette2',
	),
	'scroll_up_border_colors'         => array(
		'color'  => 'palette1',
		'hover'  => 'palette2',
	),
	// Buttons.
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => 5,
		),
	),
	'buttons_typography'    => array(
		'size' => array(
			'desktop' => 16,
			'tablet' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.7,
			'tablet' => 1.9,
			'mobile' => 1.8,
		),
		'transform' => 'capitalize',
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'  => 'px',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	'buttons_padding'        => array(
		'size'   => array( 
			'desktop' => array( 7, 22, 7, 22 ),
			'tablet' => array( 8, 20, 8, 20 ),
			'mobile' => array( 5, 20, 5, 20 ),
		),
	),
	'search_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'page_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_archive_sidebar_id'         => 'sidebar-woocommerce-shop',
	// product 
	'product_title_font'   => array(
		'size' => array(
			'tablet' => 20,
			'desktop' => 26,
		),
		'lineHeight' => array(
			'tablet' => 1.2,
			'desktop' => 1.4,
		),
		'lineType' => 'em',
	),
	// product archive 
	'product_related_columns'    => '6',
	'product_upsell_columns'    => '6',
	'product_above_title_font'   => array(
		'size' => array(
			'desktop' => 25,
		),
		'lineHeight' => array(
			'desktop' => 1.36,
		),
		'lineType' => 'em',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	'product_archive_style'  => 'action-visible',
	'product_archive_button_style'       => 'button',
	'product_archive_title_font'   => array(
		'size' => array(
			'desktop' => 16,
			'tablet' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
			'mobile' => 1.5,
		),
		'lineType' => 'em',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'product_archive_price_font'   => array(
		'size' => array(
			'desktop' => 16,
			'tablet' => 14,
			'mobile' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.33,
			'mobile' => 1.53,
		),
		'lineType' => 'em',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	// Archive Product Button.
	'product_archive_button_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette9',
	),
	'product_archive_button_background'              => array(
		'color' => 'palette9',
		'hover' => 'palette2',
	),
	'product_archive_button_border_colors'              => array(
		'color' => 'palette2',
		'hover' => 'palette2',
	),
	'product_archive_button_border'              => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
	),
	// Header.
	'header_desktop_items'       => array(
		'top' => array(
			'top_left'         => array( 'navigation-2' ),
			'top_center'       => array( 'html' ),
			'top_right'        => array( 'html2' ),
		),
		'main' => array(
			'main_left'         => array( 'logo', 'search-advanced'),
			'main_right'        => array('contact', 'divider', 'account', 'divider2', 'cart'),
		),
		'bottom' => array(
			'bottom_left'         => array( 'navigation'),
			'bottom_right'        => array('toggle-widget'),
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_center' => array( 'mobile-html' ),
		),
		'main' => array(
			'main_left'   => array( 'popup-toggle', 'mobile-logo'),
			'main_right'  => array('mobile-account', 'mobile-cart'),
		),
		'bottom' => array(
			'bottom_center'   => array('search-advanced'),
		),
	),
	// Header Top.
	'header_top_height'       => array(
		'size' => array(
			'desktop' => 40,
		),
	),
	'header_top_background'    => array(
		'desktop' => array(
			'color' => 'palette2',
		),
	),
	// Header Main.
	'header_main_height' => array(
		'size' => array(
			'mobile'  => 60,
			'tablet'  => 80,
			'desktop' => 90,
		),
	),
	// Header Bottom.
	'header_bottom_height'       => array(
		'size' => array(
			'desktop' => 60,
		),
	),
	'header_bottom_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	),
	// Mobile Trigger.
	'mobile_trigger_icon_size'   => array(
		'size' => 22,
		'unit' => 'px',
	),
	'mobile_trigger_color'              => array(
		'color' => 'palette3',
	),
	// Header HTML.
	'header_html_content'    =>  __( 'Save up to 20% on all Toys & Accessories with “FLAT26OFF” code', 'templatemela-plugin-wooti' ),
	'header_html_typography' => array(
		'color'   => 'palette9',
	),
	'header_html_wpautop' => false,
	// Mobile Header HTML.
	'mobile_html_typography' => array(
		'color'   => 'palette9',
	),
	'mobile_html_wpautop' => false,
	// Header Cart.
	'header_cart_title' =>  __( 'Cart', 'templatemela-plugin-wooti' ),
	'header_cart_label' =>  __( 'Item', 'templatemela-plugin-wooti' ),
	'header_cart_icon' => 'shopping-cart',
	'header_cart_icon_size'   => array(
		'size' => 25,
		'unit' => 'px',
	),
	'header_cart_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_cart_total_background'              => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	'header_cart_title_typography'            => array(
		'size' => array(
			'desktop' => 13,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'header_cart_typography'            => array(
		'size' => array(
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'weight'  => '600',
		'variant' => '600',
	),
	'header_cart_title_color'              => array(
		'color' => 'palette3',
	),
	// Mobile Header Cart.
	'header_mobile_cart_icon' => 'shopping-cart',
	'header_mobile_cart_icon_size'   => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_cart_color'              => array(
		'color' => 'palette3',
	),
	'header_mobile_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_mobile_cart_total_background'              => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	// logo 
	'logo_layout'     => array(
		'include' => array(
			'mobile'  => 'logo_only',
			'tablet'  => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	// Navigation.
	'primary_navigation_typography'            => array(
		'size' => array(
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'primary_navigation_spacing'            => array(
		'size' => 40,
		'unit' => 'px',
	),
	'primary_navigation_vertical_spacing'   => array(
		'size' => 18,
		'unit' => 'px',
	),
	'primary_navigation_color'   => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
		'active' => 'palette1',
	),
	// dropdown
	'dropdown_navigation_color'              => array(
		'color'  => 'palette4',
		'hover'  => 'palette1',
		'active' => 'palette1',
	),
	// Secondary Navigation.
	'secondary_navigation_typography'            => array(
		'size' => array(
			'desktop' => 14,
		),
		'color'   => 'palette9',
	),
	'secondary_navigation_spacing'            => array(
		'size' => 36,
		'unit' => 'px',
	),
	'secondary_navigation_color'   => array(
		'color'  => 'palette9',
		'hover'  => 'palette9',
		'active' => 'palette9',
	),
	// mobile navigation 
	'mobile_navigation_color'              => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
		'active' => 'palette1',
	),
	// Footer.
	'footer_items'       => array(
		'top' => array(
			'top_1' => array('footer-widget1'),
		),
		'middle' => array(
			'middle_1' => array('footer-widget2', 'footer-widget3'),
			'middle_2' => array('footer-widget4', 'footer-widget5', 'footer-widget6'),
		),
		'bottom' => array(
			'bottom_1' => array('footer-html'),
			'bottom_2' => array('footer-widget7'),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette9',
		),
	),
	// Footer Top.
	'footer_top_columns' => '1',
	'footer_top_background' => array(
		'desktop' => array(
			'color' => 'palette2',
		),
	),
	'footer_top_top_spacing' => array(
		'size' => array(
			'mobile'  => 20,
			'tablet'  => 30,
			'desktop' => 40,
		),
	),
	'footer_top_bottom_spacing' => array(
		'size' => array(
			'mobile'  => 25,
			'tablet'  => 30,
			'desktop' => 40,
		),
	),
	'footer_top_widget_title'  => array(
		'size' => array(
			'desktop' => 24,
			'tablet' => 22,
			'mobile' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.45,
			'mobile' => 1.3,
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette9',
	),
	'footer_top_widget_content' => array(
		'lineHeight' => array(
			'desktop' => 1.8,
			'mobile' => 1.5,
		),
		'color'   => 'palette9',
	),
	// footer middle 
	'footer_middle_link_style' => 'noline',
	'footer_middle_direction'         => array(
		'desktop' => 'row',
		'mobile' => 'column',
	),
	'footer_middle_layout'  => array(
		'mobile'  => 'row',
		'tablet'  => 'row',
		'desktop' => 'equal',
	),
	'footer_middle_widget_spacing' => array(
		'size' => array(
			'desktop' => 0,
		),
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'desktop' => 100,
			'tablet' => 30,
			'mobile' => 30,
		),
	),
	'footer_middle_top_spacing' => array(
		'size' => array(
			'desktop' => 60,
			'tablet'  => 50,
			'mobile'  => 30,
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'desktop' => 60,
			'tablet'  => 50,
			'mobile'  => 30,
		),
	),
	'footer_middle_columns' => '2',
	'footer_middle_widget_title'  => array(
		'size' => array(
			'desktop' => 22,
			'mobile' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'footer_middle_widget_content' => array(
		'color'   => 'palette3',
	),
	'footer_middle_link_colors' => array( 
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	),
	// Footer Bottom.
	'footer_bottom_link_style' => 'noline',
	'footer_bottom_bottom_spacing' => array(
		'size' => array(
			'mobile'  => '',
			'tablet'  => '80',
			'desktop' => '90',
		),
		'unit' => array(
			'mobile'  => 'px',
			'tablet'  => 'px',
			'desktop' => 'px',
		),
	),
	'footer_bottom_background' => array(
		'desktop' => array(
			'color' => 'palette7',
		),
	),
	'footer_bottom_columns' => '2',
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'desktop' => 0,
			'tablet' => 15,
		),
	),
	'footer_bottom_top_spacing' => array(
		'size' => array(
			'desktop' => 20,
		),
	),
	// footer html 
	'footer_html_margin' => array(
		'size'   => array( '0', '', '0', '' ),
	),
	'footer_html_typography' => array(
		'size' => array(
			'desktop' => 14,
		),
		'color'   => 'palette3',
	),
	'footer_html_link_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'footer_html_align'         => array(
		'tablet'  => 'center',
	),
	'footer_html_vertical_align'         => array(
		'desktop' => 'middle',
	),
	// footer widget7
	'footer_widget7_align'         => array(
		'desktop'  => 'right',
		'tablet'  => 'center',
	),
	'footer_widget7_vertical_align'         => array(
		'desktop' => 'middle',
	),
);

$header_addons = array(
	// Header Divider.
	'header_divider_border' => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
		'color' => 'var(--global-gray-400)',
	),
	'header_divider_margin' => array(
		'size'   => array( 0, 5, 0, 5 ),
		'unit'   => 'px',
		'locked' => false,
	),
	// Header Divider2.
	'header_divider2_border' => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
		'color' => 'var(--global-gray-400)',
	),
	'header_divider2_margin' => array(
		'size'   => array( 0, 5, 0, 5 ),
		'unit'   => 'px',
		'locked' => false,
	),
	// header account
	'header_account_style'                   => 'icon_title_label',
	'header_account_title'                   => __( 'My Account', 'templatemela-plugin-wooti' ),
	'header_account_label'                   => __( 'Log In', 'templatemela-plugin-wooti' ),
	'header_account_icon_size'               => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_account_title_typography' => array(
		'size' => array(
			'desktop' => 13,
		),
		'lineHeight' => array(
			'desktop' => 1.1,
		),
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'header_account_title_typography_color' => array(
		'color' => 'palette3',
	),
	'header_account_typography' => array(
		'size' => array(
			'desktop' => 16,
		),
		'weight'  => '600',
		'variant' => '600',
	),
	'header_account_typography_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// hedare account in 
	'header_account_in_style'                   => 'icon_title_label',
	'header_account_in_title'                   => __( 'My Account', 'templatemela-plugin-wooti' ),
	'header_account_in_label'                   => __( 'Log Out', 'templatemela-plugin-wooti' ),
	'header_account_in_icon_size'               => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_account_in_title_typography' => array(
		'size' => array(
			'desktop' => 13,
		),
		'lineHeight' => array(
			'desktop' => 1.1,
		),
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'header_account_in_title_typography_color' => array(
		'color' => 'palette3',
	),
	'header_account_in_typography' => array(
		'size' => array(
			'desktop' => 16,
		),
		'weight'  => '600',
		'variant' => '600',
	),
	'header_account_in_typography_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// header mobile account 
	'header_mobile_account_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// header mobile account in 
	'header_mobile_account_in_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// html 2 
	'header_html2_content'    =>  __( 'Free Shipping on orders over $100!', 'templatemela-plugin-wooti' ),
	'header_html2_typography' => array(
		'color'   => 'palette9'
	),
	// Header Contact.
	'header_contact_items' => array(
		'items' => array(
			array(
				'id' => 'phone',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'link' => '',
				'icon' => 'phoneAlt2',
				'title' => 'Need Help?',
				'label' => __( '+00 123-456-789', 'templatemela-plugin-wooti' ),
			),
		),
	),
	'header_contact_icon_size' => array(
		'size' => 25,
		'unit' => 'px',
	),
	'header_contact_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_contact_typography' => array(
		'size' => array(
			'desktop' => 16,
		),
		'weight'  => '600',
		'variant' => '600',
	),
	// header mobile serach bar 
	'header_mobile_search_bar_width' => array(
		'size' => 680,
		'unit' => 'px',
	),
	'header_mobile_search_bar_border' => array(
		'width' => 2,
		'unit'  => 'px',
		'style' => 'solid',
		'color' => 'palette1',
	),
	'header_mobile_search_bar_color'       => array(
		'color'  => 'palette3',
	),
	'header_mobile_search_bar_typography'        => array(
		'size' => array(
			'desktop' => 13,
		),
	),
	// Widget Toggle.
	'header_toggle_widget_label'  => 'Top Offers!',
	'header_toggle_widget_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_toggle_widget_typography'            => array(
		'weight'  => 500,
	),
	'header_toggle_widget_close_color'  => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_toggle_widget_padding' => array(
		'size'   => array( 0, 0, 0, 0 ),
		'unit'   => 'em',
		'locked' => false,
	),
	// Header toggle Widget Area.
	'header_widget2_link_colors'       => array(
		'color'  => 'palette3',
		'hover'  => 'palette3',
	),
	'header_toggle_widget_pop_background' => array(
		'desktop' => array(
			'color' => 'palette9',
		),
	),
	'header_widget2_title'        => array(
		'size' => array(
			'desktop' => 20,
		),
		'color'   => 'palette3',
	),
	'header_widget2_content'        => array(
		'size' => array(
			'desktop' => 15,
		),
		'weight'  => '500',
		'color'   => 'palette3',
	),
);
$more_addons = array(
	// Header Search Advanced.
	'header_search_advanced_label'        => 'Search',
	// Header Search Advanced.
	'header_search_advanced_width' => array(
		'size' => array(
			'mobile'  => 510,
			'desktop' => 620,
		),
	),
	// Search-Box

	'header_search_advanced_input_padding' => array(
		'size'   => array( '8', '10', '8', '17' ),
		'unit'   => 'px',
		'locked' => false,
	),
	'header_search_advanced_border' => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
	),
	'header_search_advanced_border_color'       => array(
		'color' =>  'var(--global-gray-400)',
	),
	'header_search_advanced_border_radius' => array(
		'size'   => array( 5, 5, 5, 5),
		'unit'   => 'px',
		'locked' => true,
	),
	// Category-Box
	'header_search_advanced_category_typography' => array(
		'size' => array(
			'desktop' => 14,
		),
	),
	'header_search_advanced_category_color' => array(
		'color'  => 'palette3',
	),
	// Input
	'header_search_advanced_typography'        => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 28,
		),
		'lineType'=> 'px',
	),
	'header_search_advanced_background'       => array(
		'color'  => 'palette8',
	),
	// Button
	'header_search_advanced_button_typography'        => array(
		'size' => array(
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.7,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'  => 'px',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	'header_search_advanced_button_padding' => array(
		'size'   => array( 8, 28, 8, 28 ),
		'unit'   => 'px',
		'locked' => false,
	),
	'header_search_advanced_button_radius' => array(
		'size'   => array( 0, 5, 5, 0 ),
		'unit'   => 'px',
		'locked' => true,
	),
);
$woo_addons = array(
	'product_filter_widget_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);


$dark_mode_addons = array(
	'dark_mode_custom_logo'        => true,
 );