<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Theme
 * @since 1.0
 */

$default_options = array(
	'content_width' => array(
		'size' => 1430,
		'unit' => 'px',
	),
	// Logo
	'logo_layout'     => array(
		'include' => array(
			'mobile'  => 'logo_only',
			'tablet'  => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'family'  => 'Inter',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette4',
	),
	'heading_font'        => array(
		'family' => 'Inter',
	),
	'h1_font' => array(
		'size' => array(
			'mobile' => 24,
			'tablet' => 29,
			'desktop' => 38,
		),
		'lineHeight' => array(
			'desktop' => 1.17,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'mobile' => 19,
			'tablet' => 26,
			'desktop' => 28,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'mobile' => 20,
			'tablet' => 24,
			'desktop' => 26,
		),
		'lineHeight' => array(
			'desktop' => 1.25,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'mobile' => 20,
			'desktop' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'mobile' => 21,
			'tablet' => 18,
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'desktop' => 18,
		),
		'color'   => 'palette3',
	),
	'title_above_font' => array(
		'size' => array(
			'mobile' => '24',
			'desktop' => '27',
		),
	),
	'title_above_breadcrumb_font' => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 14,
		),
	),
	//buttons
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => '5',
		),
	),
	'buttons_typography'    => array(
		'size' => array(
			'desktop' => 12,
		),
		'lineHeight' => array(
			'desktop' => 2,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'transform' => 'uppercase',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
	),
	'buttons_padding'        => array(
		'size'   => array( 
			'mobile' => array( 7, 15, 7, 15 ),
			'desktop' => array( 11, 20, 11, 20 ),
		),
		'unit'   => array(
			'desktop' => 'px',
		),
		'locked' => array(
			'desktop' => false,
		),
	),
	// Header.
	'header_desktop_items'       => array(
		'top' => array(
			'top_left'         => array( 'html' ),
			'top_right'        => array( 'navigation-2' ),
		),
		'main' => array(
			'main_left'         => array( 'logo' ),
			'main_center'       => array( 'search-advanced' ),
			'main_right'        => array( 'wishlist' , 'account' , 'cart' ),
		),
		'bottom' => array(
			'bottom_left'         => array( 'vertical-menu', 'navigation' ),
			'bottom_right'        => array( 'toggle-widget' ),
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_center' => array( 'html' ),
		),
		'main' => array(
			'main_left'   => array( 'popup-toggle', 'mobile-logo' ),
			'main_right'  => array( 'search', 'mobile-account', 'mobile-cart' ),
		),
		'bottom' => array(
			'bottom_left'   => array(),
		),
	),
	// Header Top.
	'header_top_height'       => array(
		'size' => array(
			'mobile'  => 30,
			'tablet'  => 40,
			'desktop' => 50,
		),
	),
	'header_top_background'    => array(
		'desktop' => array(
			'color' => 'palette7',
		),
	),
	// Header Main.
	'header_main_height' => array(
		'size' => array(
			'mobile'  => 70,
			'desktop' => 90,
		),
	),
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'var(--global-gray-400)',
		),
		'tablet' => array(
			'width' => 0,
		),
	),
	// Header Bottom.
	'header_bottom_height'       => array(
		'size' => array(
			'desktop' => 60,
		),
	),
	// Header HTML.
	'header_html_content'    => __( 'Welcome to worldwide <a> wooti </a> store', 'templatemela-theme-wooti' ),
	'header_html_typography' => array(
		'color'   => 'palette3',
	),
	'header_html_link_style' => 'plain',
	'header_html_link_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//secondary navigation
	'secondary_navigation_color'   => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
		'active' => 'palette3',
	),
	//header cart
	'header_cart_title' => 'My cart',
	'header_cart_label' => __( 'Items', 'templatemela-theme-wooti' ),
	'header_cart_icon_size'   => array(
		'size' => '23',
		'unit' => 'px',
	),
	'header_cart_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_cart_total_background'              => array(
		'color' => 'palette1',
	),
	'header_cart_title_typography'            => array(
		'size' => array(
			'desktop' => 14,
		),
		'transform' => 'capitalize',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	'header_cart_title_color'              => array(
		'color' => 'palette4',
	),
	'header_cart_typography'            => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'transform' => 'capitalize',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
	),
	'header_cart_label_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//header cart mobile
	'header_mobile_cart_color'       => array(
		'color' => 'palette3',
		'hover'  => 'palette1',
	),
	'header_mobile_cart_icon_size' => array(
		'size' => 21,
		'unit' => 'px',
	),
	'header_mobile_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_mobile_cart_total_background'              => array(
		'color' => 'palette1',
	),
	// Navigation.
	'primary_navigation_typography'            => array(
		'size' => array(
			'desktop' => 14,
		),
		'family'  => 'Inter',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	'primary_navigation_spacing'            => array(
		'size' => 40,
		'unit' => 'px',
	),
	'primary_navigation_vertical_spacing'   => array(
		'size' => 19,
		'unit' => 'px',
	),
	'primary_navigation_color'   => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
		'active' => 'palette3',
	),
	//mobile trigger
	'mobile_trigger_color' => array(
		'color' => 'palette3',
		'hover'  => 'palette1',
	),
	'mobile_trigger_icon_size'   => array(
		'size' => 22,
		'unit' => 'px',
	),
	//header search
	'header_search_icon_size' => array(
		'size' => array(
			'tablet' => 24,
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_search_color'              => array(
		'color' => 'palette3',
		'hover'  => 'palette1',
	),
	//dropdown
	'dropdown_navigation_typography'        => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.7,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
	),
	// Footer.
	'footer_items'       => array(
		'top' => array(
			'top_1' => array( 'footer-widget1' ),
			'top_2' => array( 'footer-social' ),
		),
		'middle' => array(
			'middle_1' => array( 'footer-widget2' ),
			'middle_2' => array( 'footer-widget3' ),
			'middle_3' => array( 'footer-widget4' ),
			'middle_4' => array( 'footer-widget5' ),
		),
		'bottom' => array(
			'bottom_1' => array( 'footer-html' ),
			'bottom_2' => array( 'footer-widget6' ),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => '#1a1a1a',
		),
	),
	//footer top
	'footer_top_background' => array(
		'desktop' => array(
			'color' => 'palette7',
		),
	),
	'footer_top_widget_title'  => array(
		'size' => array(
			'mobile' => 20,
			'desktop' => 22,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'footer_top_top_spacing' => array(
		'size' => array(
			'mobile'  => '20',
			'tablet'  => '40',
			'desktop' => '40',
		),
	),
	'footer_top_bottom_spacing' => array(
		'size' => array(
			'mobile'  => '15',
			'tablet'  => '35',
			'desktop' => '40',
		),
	),
	'footer_top_column_spacing' => array(
		'size' => array(
			'tablet'  => '15',
		),
	),
	'footer_top_columns' => '2',
	//footer middle
	'footer_middle_columns' => '4',
	'footer_middle_contain'         => array(
		'desktop' => 'contained',
	),
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'rgba(255,255,255,0.1)',
		),
	),
	'footer_middle_top_spacing' => array(
		'size' => array(
			'mobile'  => '40',
			'tablet'  => '50',
			'desktop' => '55',
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'mobile'  => '40',
			'tablet'  => '50',
			'desktop' => '45',
		),
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'mobile'  => '30',
			'tablet'  => '50',
			'desktop' => '60',
		),
	),
	'footer_middle_widget_title'  => array(
		'size' => array(
			'desktop' => 20,
		),
		'family'  => 'Inter',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette9',
	),
	'footer_middle_widget_content' => array(
		'color'   => 'palette9',
	),
	'footer_middle_link_colors' => array(
		'color' => 'palette9',
		'hover' => 'palette1',
	),
	'footer_middle_layout' => array(
		'mobile' => 'row',
		'tablet' => 'two-grid',
		'desktop' => 'center-half',
	),
	'footer_middle_link_style' => 'noline',
	//footer bottom
	'footer_bottom_columns' => '2',
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'mobile' => 10,
			'tablet' => 15,
			'desktop' => 30,
		),
	),
	'footer_bottom_widget_content' => array(
		'color'   => 'palette9',
	),
	'footer_bottom_link_colors' => array(
		'color' => 'palette9',
		'hover' => 'palette1',
	),
	'footer_bottom_link_style' => 'noline',
	'footer_bottom_top_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'rgba(255,255,255,0.1)',
		),
	),
	'footer_bottom_contain'         => array(
		'desktop' => 'contained',
	),
	'footer_bottom_top_spacing' => array(
		'size' => array(
			'mobile'  => '10',
			'tablet'  => '15',
			'desktop' => '30',
		),
	),
	//footer social
	'footer_social_items' => array(
		'items' => array(
			array(
				'id'      => 'facebook',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'facebookAlt2',
				'label'   => __( 'Facebook', 'templatemela-theme-wooti' ),
			),
			array(
				'id' => 'twitter',
				'enabled' => true,
				'source' => 'svg',
				'svg' => '<svg id="Layer_1" data-name="Layer 1"  xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500.08 511.77"><path fill="currentColor" d="M10.22,512.77c11.62-13.7,23.17-27.46,34.88-41.08q78.33-91.1,156.74-182.15c1.08-1.25,2.09-2.57,3.31-4.08L9.92,1.42c1.92-.14,3.15-.31,4.38-.31q70.2,0,140.42-.1c3.33,0,5,1.24,6.76,3.8Q223,94.6,284.75,184.27c1,1.48,2.09,2.92,3.46,4.83l25.3-29.35Q379.81,82.68,446,5.54A11.69,11.69,0,0,1,456.22,1c12.25.27,24.52.09,37.95.09L307.77,217.76l29,42.16Q422,384,507.25,508.1c1,1.48,1.84,3.11,2.75,4.67H361.07c-.67-1.14-1.28-2.32-2-3.41q-65.88-95.82-131.8-191.62c-.72-1.05-1.61-2-2.61-3.2-1.78,2-3.35,3.71-4.86,5.46q-52.6,61.13-105.19,122.25Q84.34,477.47,54.2,512.77Z" transform="translate(-9.92 -1)"/></svg>',
				'imageid' => '',
				'width' => 12,
				'icon' => 'twitterAlt',
				'label' => __( 'X formerly Twitter', 'templatemela-theme-wooti' ),
			),
			array(
				'id'      => 'instagram',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'instagram',
				'label'   => __( 'Instagram', 'templatemela-theme-wooti' ),
			),
			array(
				'id'      => 'youtube',
				'enabled' => true,
				'source'  => 'icon',
				'url'     => '',
				'imageid' => '',
				'width'   => 24,
				'icon'    => 'youtube',
				'label'   => __( 'YouTube', 'templatemela-theme-wooti' ),
			),
		),
	),
	'footer_social_title' => __( 'Follow us on:', 'templatemela-theme-wooti' ),
	'footer_social_color' => array(
		'color' => 'palette3',
	),
	'footer_social_brand' => 'onhover',
	'footer_social_item_spacing' => array(
		'size' => 0.45,
		'unit' => 'em',
	),
	'footer_social_icon_size' => array(
		'size' => 17,
		'unit' => 'px',
	),
	'footer_social_align'         => array(
		'desktop' => 'left',
	),
	// Footer Widget 6.
	'footer_widget6_align'         => array(
		'tablet'  => 'center',
		'desktop' => 'right',
	),
	// Footer HTML
	'footer_html_align'         => array(
		'tablet'  => 'center',
	),
	//sidebar
	'sidebar_link_style' => 'plain',
	'sidebar_width'   => array(
		'size' => '250',
		'unit' => 'px',
	),
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 18,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'sidebar_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
	//product
	'product_archive_button_style' => 'button',
	'product_archive_title_font' => array(
		'size' => array(
			'mobile' => 13,
			'desktop' => 14,
		),
		'lineHeight' => array(
			'mobile' => 1.6,
			'desktop' => 1.37,
		),
		'letterSpacing' => array(
			'desktop' => 0,
		),
		'lineType'=> 'em',
		'spacingType'=> 'px',
		'family'  => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	'product_archive_price_font'   => array(
		'size' => array(
			'mobile' => 15,
			'tablet' => 17,
			'desktop' => 20,
		),
		'letterSpacing' => array(
			'desktop' => 0,
		),
		'spacingType'=> 'px',
		'family'  => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'product_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'product_above_category_font'   => array(
		'size' => array(
			'desktop' => '28',
		),
		'lineHeight' => array(
			'desktop' => '1.5',
		),
		'family'  => 'inherit',
		'transform' => 'capitalize',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'product_title_font'   => array(
		'size' => array(
			'mobile'  => '20',
			'tablet' => '24',
			'desktop' => '27',
		),
	),
	//post
	'post_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_title_height'       => array(
		'size' => array(
			'desktop' => 130,
		),
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//page
	'page_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//search
	'search_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);
$header_addons = array(
	//header account
	'header_account_icon_size'           => array(
		'size' => '22',
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//header account in
	'header_account_in_icon_size'           => array(
		'size' => '22',
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1'
	),
	//header mobile account
	'header_mobile_account_icon_size' => array(
		'size' => 21,
		'unit' => 'px',
	),
	'header_mobile_account_color' => array(
		'color' => 'palette3',
		'hover'  => 'palette1',
	),
	'header_mobile_account_in_icon_size' => array(
		'size' => 21,
		'unit' => 'px',
	),
	'header_mobile_account_in_color' => array(
		'color' => 'palette3',
		'hover'  => 'palette1',
	),
	// Widget Toggle.
	'header_toggle_widget_label'  => __( 'Weekly Discount', 'templatemela-theme-wooti' ),
	'header_toggle_widget_color'              => array(
		'color' => 'palette1',
		'hover' => 'palette3',
	),
	'header_toggle_widget_typography'            => array(
		'size' => array(
			'desktop' => 14,
		),
		'transform' => 'capitalize',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
	),
	'header_toggle_widget_close_color'  => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_toggle_widget_padding' => array(
		'size'   => array( 0, 0, 0, 0 ),
		'unit'   => 'em',
		'locked' => false,
	),
	// Header toggle Widget Area.
	'header_widget2_link_colors'       => array(
		'color'  => 'palette3',
	),
	'header_toggle_widget_pop_background' => array(
		'desktop' => array(
			'color' => 'palette9',
		),
	),
	'header_widget2_title'        => array(
		'size' => array(
			'desktop' => 18,
		),
		'color'   => 'palette3',
	),
);
$more_addons = array(
	//vertical navigation
	'vertical_heading_spacing'          => array(
		'size' => 50,
		'unit' => 'px',
	),
	'vertical_heading_color'            => array(
		'color'  => 'palette9',
		'hover'  => 'palette9',
		'active' => 'palette9',
	),
	'vertical_heading_background'       => array(
		'color'  => 'palette1',
	),
	'vertical_navigation_color'            => array(
		'color'  => 'palette4',
		'hover'  => 'palette1',
		'active' => 'palette1',
	),
	'vertical_navigation_background'       => array(
		'color'  => 'palette9',
	),
	'vertical_navigation_opened'           => true,
	'vertical_navigation_spacing'          => array(
		'size' =>  50,
		'unit' => 'px',
	),
	'vertical_navigation_vertical_spacing' => array(
		'size' => 10,
		'unit' => 'px',
	),
	'vertical_navigation_item_border' => array(
		'width' => 0,
		'unit'  => 'px',
		'style' => 'solid',
		'color' => 'palette7',
	),
	'vertical_navigation_border' => array(
		'width' => 1,
		'unit'  => 'px',
		'style' => 'solid',
		'color' => 'palette1',
	),
	//header search advanced
	'header_search_advanced_width' => array(
		'size' => array(
			'desktop' => 670,
		),
	),
	'header_search_advanced_background'       => array(
		'color'  => 'palette9',
	),
	'header_search_advanced_input_padding' => array(
		'size'   => array( '', 40, '', 20 ),
		'unit'   => 'px',
		'locked' => false,
	),
	'header_search_advanced_buttons_background' => array(
		'color'  => 'transparent',
		'hover'  => 'transparent',
	),
	'header_search_advanced_buttons_color' => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
	),
	'header_search_advanced_button_typography'        => array(
		'size' => array(
			'desktop' => 20,
		),
	),
	'header_search_advanced_category_color' => array(
		'color'  => 'palette3',
	),
	'header_search_advanced_border_radius' => array(
		'size'   => array( 5, 5, 5, 5 ),
		'unit'   => 'px',
		'locked' => true,
	),
	//wishlist
	'header_wishlist_show_total' => false,
	'header_wishlist_icon_size'   => array(
		'size' => array(
			'desktop' => '22',
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_wishlist_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);
$woo_addons = array(
	'product_filter_widget_link_colors'       => array(
		'color'  => 'palette4',
		'hover'  => 'palette1',
	),
	'product_filter_widget_title'        => array(
		'size' => array(
			'desktop' => '17',
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
);
$dark_mode_addons = array(
	'dark_mode_custom_logo'        => true,
 );