<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Theme
 * @since 1.0
 */

$default_options = array(
	// container 
	'content_width'   => array(
		'size' => 1770,
		'unit' => 'px',
	),
	// Sidebar.
	'sidebar_width'   => array(
		'size' => 285,
		'unit' => 'px',
	),
	'sidebar_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 16,
		),
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'sidebar_link_style' => 'plain',
	// scroll up
	'scroll_up_icon'          => 'chevron-up',
	'scroll_up_padding' => array(
		'size'   => array( 
			'desktop' => array( 8, 8, 8, 8 ),
		),
		'unit'   => array(
			'desktop' => 'px',
		),
	),
	'scroll_up_icon_size'   => array(
		'size' => array(
			'mobile'  => 16,
			'desktop' =>  20,
		),
		'unit' => array(
			'mobile'  => 'px',
			'desktop' => 'px',
		),
	),
	'scroll_up_color'                     => array(
		'color'  => 'palette9',
		'hover'  => 'palette9',
	),
	'scroll_up_background'                     => array(
		'color'  => 'palette1',
		'hover'  => 'palette2',
	),
	'scroll_up_border_colors'         => array(
		'color'  => 'palette1',
		'hover'  => 'palette2',
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.7,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'=> 'px',
		'family'  => 'Noto Sans',
		'google'  => true,	
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette4',
	),
	'heading_font' => array(
		'family' => 'Lora',
	),
	'h1_font' => array(
		'size' => array(
			'mobile' => 24,
			'tablet' => 34,
			'desktop' => 40,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'desktop' => 34,
			'tablet' => 26,
			'mobile' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.35,
			'mobile' => 1.33,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'desktop' => 30,
			'tablet' => 26,
			'mobile' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.38,
			'mobile' => 1.4,
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'desktop' => 22,
			'tablet' => 20,
			'mobile' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
			'mobile' => 1.3,	
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'desktop' => 20,
			'mobile' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
			'mobile' => 1.3,	
		),
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType' => 'px',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
			'mobile' => 1.3,	
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'title_above_font' => array(
		'size' => array(
			'mobile' => 20,
			'tablet' => 22,
			'desktop' => 26,
		),
		'lineHeight' => array(
			'desktop' => 1.3,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	'title_above_breadcrumb_font' => array(
		'color'   => 'palette3',
	),
	// Buttons.
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => 5,
		),
	),
	'buttons_typography'    => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 2,
		),
		'transform' => 'capitalize',
		'letterSpacing' => array(
			'desktop' => 0.3,
		),
		'spacingType'=> 'px',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	'buttons_padding'        => array(
		'size'   => array( 
			'desktop' => array( 6, 27, 6, 27 ),
			'mobile' => array( 5 , 20 , 5 , 20 ),
		),
	),
	// Header.
	'header_desktop_items'       => array(
		'top' => array(
			'top_left'         => array( 'html2' ),
			'top_center'       => array( 'html' ),
			'top_right'        => array( 'navigation-2' ),
		),
		'main' => array(
			'main_left'         => array( 'logo', 'navigation' ),
			'main_right'        => array( 'search-advanced', 'account', 'wishlist', 'cart' ),
		),
		'bottom' => array(
			'bottom_left'         => array( ),
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_center' => array( 'mobile-html' ),
		),
		'main' => array(
			'main_left'   => array( 'popup-toggle', 'mobile-logo'),
			'main_right'  => array('mobile-account','wishlist', 'mobile-cart'),
		),
		'bottom' => array(
			'bottom_center'   => array('search-advanced'),
		),
	),
	// Header Top.
	'header_top_height'       => array(
		'size' => array(
			'mobile' => 26,
			'desktop' => 44,
		),
	),
	'header_top_background'    => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	'header_top_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit'  => 'px',
			'style' => 'solid',
			'color'  => 'rgba(255,255,255,0.1)',
		),
	),
	// Header Main.
	'header_main_height' => array(
		'size' => array(
			'mobile'  => 50,
			'tablet'  => 80,
			'desktop' => 120,
		),
	),
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	),
	// Mobile Trigger.
	'mobile_trigger_icon_size'   => array(
		'size' => 22,
		'unit' => 'px',
	),
	'mobile_trigger_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// Header HTML.
	'header_html_content'    =>  __( 'Celebrate mum with amazing gifts with amazing range.', 'templatemela-plugin-wooti' ),
	'header_html_typography' => array(
		'size' => array(
			'desktop' => 15,
		),
		'color'   => 'palette9',
	),
	'header_html_wpautop' => false,
	// Mobile Header HTML.
	'mobile_html_content'    => __( 'Free shipping on orders over $100!', 'templatemela-plugin-wooti' ),
	'mobile_html_typography' => array(
		'color'   => 'palette9',
	),
	'mobile_html_wpautop' => false,
	// Header Cart.
	'header_cart_icon' => 'shopping-cart',
	'header_cart_icon_size'   => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_cart_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_cart_total_background'              => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	// Mobile Header Cart.
	'header_mobile_cart_icon' => 'shopping-cart',
	'header_mobile_cart_icon_size'   => array(
		'size' => 24,
		'unit' => 'px',
	),
	'header_mobile_cart_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_mobile_cart_total_color'              => array(
		'color' => 'palette9',
	),
	'header_mobile_cart_total_background'              => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	// logo 
	'logo_layout'     => array(
		'include' => array(
			'mobile'  => 'logo_only',
			'tablet'  => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	'header_logo_padding' => array(
		'size'   => array( 
			'desktop' => array( 0,30,0,0),
		),
	),
	// Navigation.
	'primary_navigation_typography'            => array(
		'weight'  => '500',
		'variant' => '500',
	),
	'primary_navigation_spacing'            => array(
		'size' => 40,
		'unit' => 'px',
	),
	'primary_navigation_vertical_spacing'   => array(
		'size' => 46,
		'unit' => 'px',
	),
	'primary_navigation_color'   => array(
		'color'  => 'palette3',
		'hover'  => 'palette1',
		'active' => 'palette3',
	),
	// Secondary Navigation.
	'secondary_navigation_typography'            => array(
		'size' => array(
			'desktop' => 15,
		),
		'color'   => 'palette9',
	),
	'secondary_navigation_spacing'            => array(
		'size' => 36,
		'unit' => 'px',
	),
	'secondary_navigation_color'   => array(
		'color'  => 'palette9',
		'hover'  => 'palette3',
		'active' => 'palette3',
	),
	// Dropdown.
	'dropdown_navigation_typography'            => array(
		'size' => array(
			'desktop' => 14,
		),
	),
	'dropdown_navigation_color'              => array(
		'color'  => 'palette4',
		'hover'  => 'palette1',
		'active' => 'palette1',
	),
	// mobile navigation 
	'mobile_navigation_color'              => array(
		'color'  => 'palette3',
		'hover'  => 'palette3',
		'active' => 'palette3',
	),
	// Footer.
	'footer_items'       => array(
		'top' => array(
			'top_1' => array('footer-widget1'),
		),
		'middle' => array(
			'middle_1' => array('footer-widget2'),
			'middle_2' => array('footer-widget3' ),
			'middle_3' => array('footer-widget4' , 'footer-widget5','footer-widget6'),
		),
		'bottom' => array(
			'bottom_1' => array('footer-html'),
			'bottom_2' => array('footer-widget7'),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	// Footer Top.
	'footer_top_columns' => '1',
	'footer_top_background' => array(
		'desktop' => array(
			'color' => 'transparent',
			'image' => array(
				'url' => __(TMTHEME_URL.'layouts/artcrafts/img/footer-bg.jpg'),
				'size'=> 'auto',
				'repeat'=> 'no-repeat',				
			),
			'type' => 'image',
		),
	),
	'footer_top_top_spacing' => array(
		'size' => array(
			'mobile'  => 20,
			'tablet'  => 30,
			'desktop' => 64,
		),
	),
	'footer_top_bottom_spacing' => array(
		'size' => array(
			'mobile'  => 25,
			'tablet'  => 30,
			'desktop' => 64,
		),
	),
	'footer_top_contain'         => array(
		'desktop' => 'contained',
	),
	'footer_top_widget_title'  => array(
		'size' => array(
			'mobile' => 24,
			'tablet' => 30,
			'desktop' => 38,
		),
		'lineHeight' => array(
			'desktop' => '1.2',
		),
		'weight'  => '400',
		'variant' => '400',
		'color'   => '#000000',
	),
	'footer_top_widget_content' => array(
		'size' => array(
			'desktop' => 14,
		),
		'weight'  => '500',
		'variant' => '500',
		'color'   => '#000',
	),
	//footer middle
	'footer_middle_columns' => '3',
	'footer_middle_top_spacing' => array(
		'size' => array(
			'mobile' => '20',
			'tablet' => '50',
			'desktop' => '70',
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'mobile' => '40',
			'tablet' => '50',
			'desktop' => '75',
		),
	),
	'footer_middle_layout'  => array(
		'mobile'  => 'row',
		'tablet'  => 'row',
		'desktop' => 'right-half',
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'mobile' => '30',
			'tablet' => '40',
			'desktop' => '50',
		),
	),
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 1,
			'unit' => 'px',
			'style' => 'dashed',
			'color' => '#fff',
		),
	),
	'footer_middle_widget_title'  => array(
		'size' => array(
			'desktop' => 20,
			'mobile' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.2,
		),
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => '#fff',
	),
	'footer_middle_widget_content' => array(
		'lineHeight' => array(
			'desktop' => 2,
		),
		'color'   => '#fff',
	),
	'footer_middle_link_colors' => array( 
		'color' => '#fff',
		'hover' => 'palette3',
	),
	'footer_middle_link_style' => 'noline',
	// Footer Bottom.
	'footer_bottom_columns' => '2',
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'desktop' => 0,
			'tablet' => 15,
		),
	),
	'footer_bottom_top_spacing' => array(
		'size' => array(
			'desktop' => 20,
		),
	),
	'footer_bottom_link_style' => 'noline',
	// footer html 
	'footer_html_typography' => array(
		'color'   => '#fff',
	),
	'footer_html_link_color'              => array(
		'color' => '#fff',
		'hover' => 'palette3',
	),
	'footer_html_align'         => array(
		'tablet'  => 'center',
	),
	'footer_html_vertical_align'         => array(
		'desktop' => 'middle',
	),
	// footer widget7
	'footer_widget7_align'         => array(
		'desktop'  => 'right',
		'tablet'  => 'center',
	),
	'footer_widget7_vertical_align'         => array(
		'desktop' => 'middle',
	),
	// product 
	'product_archive_title_font'   => array(
		'size' => array(
			'mobile' => 14,
			'desktop' => 16,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'lineType' => 'em',
		'family'  => 'Noto Sans',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	'product_archive_price_font'   => array(
		'size' => array(
			'desktop' => 16,
			'tablet' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.33,
			'mobile' => 1.53,
		),
		'lineType'=> 'em',
		'family'  => 'Noto Sans',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette1',
	),
	'product_title_font'   => array(
		'size' => array(
			'tablet' => 18,
			'tablet' => 20,
			'desktop' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'lineType' => 'em',
		'family'  => 'Noto Sans',
		'google'  => true,
		'weight'  => '600',
		'variant' => '600',
		'color'   => 'palette3',
	),
	// product archive 
	'product_above_title_font'   => array(
		'size' => array(
			'desktop' => 25,
		),
		'lineHeight' => array(
			'desktop' => 1.36,
		),
		'lineType' => 'em',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
	),
	// Breadcrumbs
	'product_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'product_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'page_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'page_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'post_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'post_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'search_archive_title_height'       => array(
		'size' => array(
			'mobile'  => 70,
			'tablet'  => 100,
			'desktop' => 130,
		),
	),
	'search_archive_title_breadcrumb_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);

$header_addons = array(
	'header_html2_content'    => __( '<span><img src="'.TMTHEME_URL.'layouts/artcrafts/img/location.svg"> Find a Store</span><span><img src="'.TMTHEME_URL.'layouts/artcrafts/img/truck.svg"> Order Traking</span>', 'templatemela-plugin-wooti'  ),
	'header_html2_wpautop'    => false,
	'header_html2_typography' => array(
		'size' => array(
			'desktop' => 15,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette9',
	),
	// header account
	'header_account_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// hedare account in 
	'header_account_in_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// header mobile account 
	'header_mobile_account_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// header mobile account in 
	'header_mobile_account_in_icon_size'               => array(
		'size' => 22,
		'unit' => 'px',
	),
	'header_mobile_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	// Header Contact.
	'header_contact_items' => array(
		'items' => array(
			array(
				'id' => 'phone',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'link' => '',
				'icon' => 'phoneAlt2',
				'title' => 'Need Help?',
				'label' => __( '+00 123-456-789', 'templatemela-plugin-wooti' ),
			),
		),
	),
	'header_contact_icon_size' => array(
		'size' => 25,
		'unit' => 'px',
	),
	'header_contact_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette1',
	),
	'header_contact_typography' => array(
		'size' => array(
			'desktop' => 16,
		),
		'weight'  => '600',
	),
);
$more_addons = array(
	'header_wishlist_icon_size'   => array(
		'size' => array(
			'desktop' => '24',
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_wishlist_color'              => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_wishlist_total_color'              => array(
		'color' => 'palette9',
	),
	'header_wishlist_total_background'              => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	// Header Search Advanced.
	'header_search_advanced_margin' => array(
		'size'   => array( 0,20,0,0 ),
		'unit'   => 'px',
		'locked' => false,
	), 
	'header_search_advanced_background'       => array(
		'color'  => 'palette7',
	),
	'header_search_advanced_width' => array(
		'size' => array(
			'desktop' => 310,
		),
	),
	// Search-Box
	'header_search_advanced_border' => array(
		'width' => 0,
		'unit'  => 'px',
		'style' => 'solid',
	),
	'header_search_advanced_border_radius' => array(
		'size'   => array( 50,50,50,50 ),
		'unit'   => 'px',
		'locked' => true,
	),
	// Input
	'header_search_advanced_color'       => array(
		'color'  => 'palette4',
		'hover'  => 'palette3',
	),
	'header_search_advanced_typography'        => array(
		'size' => array(
			'desktop' => 15,
		),
	),
	'header_search_advanced_input_padding' => array(
		'size'   => array( 10,13,10,20 ),
		'unit'   => 'px',
		'locked' => false,
	),
	// Button
	'header_search_advanced_buttons_background' => array(
		'color'  => 'transparent',
		'hover'  => 'transparent',
	),
	'header_search_advanced_buttons_color' => array(
		'color'  => 'palette3',
		'hover'  => 'palette3',
	),
	'header_search_advanced_button_typography'        => array(
		'size' => array(
			'desktop' => 20,
		),
	),
	'header_search_advanced_button_padding' => array(
		'size'   => array( 10, 20, 10, 13 ),
		'unit'   => 'px',
		'locked' => false,
	),
	'header_search_advanced_button_radius' => array(
		'size'   => array( 0 , 50 , 50 , 0 ),
		'unit'   => 'px',
		'locked' => true,
	),
);
$woo_addons = array(
	'product_filter_widget_link_colors' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'product_filter_widget_title' => array(
		'size' => array(
			'desktop' => 16,
			'mobile' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
			'tablet' => 1.7,
		),
		'family' => 'Noto Sans',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	'product_filter_widget_content'        => array(
		'size' => array(
			'desktop' => 14,
		),
	),
);


$dark_mode_addons = array(
	'dark_mode_custom_logo'        => true,
 );