<?php
/**
 * Shortcode Class to display contents.
 *
 * @author     TemplateMela
 * @copyright  (c) Copyright by TemplateMela
 * @link       https://templatemela.com
 * @package    TemplateMela Theme
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

/**
 * Shortcode class.
 */
if ( ! class_exists( 'TemplateMela_Shortcode_Example' ) ) {
	
class TemplateMela_Shortcode_Example {

	/**
	 * Constructor.
	 *
	 * @access public
	 * @since 1.0.0
	 */
	public function __construct() {
		add_shortcode( 'scode_example', [ $this, 'render' ] );
	}

	/**
	 * Render the element.
	 *
	 * @access public
	 * @since 1.0.0
	 * @param array  $args    Shortcode parameters.
	 * @param string $content Content between shortcode.
	 * @return void|string     HTML output.
	 */
	public function render( $args, $content = '' ) {

		$args = shortcode_atts(
			[
				'size'   => 'normal',
				'style'  => '',
				'class'  => '',
			],
			$args,
			'scode_example'
		);

		$classes	= array( 'example-wrapper' , 'scode-example', 'relative' );
		
		extract($args);
		if( $class ) $classes[] = $class;
		if( $visibility ) $classes[] = $visibility;
		if( $style ) $classes[] = 'form-'.$style;
		if( $size ) $classes[] = 'is-'.$size;
		$classes = implode(' ', $classes);
	
		ob_start();

		echo '<div class="'. $classes. '">';
		$this->get_example_contents();
		echo '</div>';

		$html = apply_filters( 'scode_example_content', ob_get_clean(), $args );

		return $html;
	}

	/**
	 * Output the contents.
	 *
	 * @access public
	 * @since 1.0.0
	 * @return void
	 */
	public function get_example_contents() {
		echo 'Example';
	}

}

new TemplateMela_Shortcode_Example();

}