<?php
/**
 * Bootstrap the plugin.
 *
 * @since 6.0
 * @package TemplateMela
 * @subpackage Core
 */

// Load the instance of the plugin.
if ( ! class_exists( 'TemplateMela_Plugin' ) ) {
	require_once TMTHEME_PATH . '/includes/class-templatemela-plugin.php';
}
add_action( 'plugins_loaded', [ 'TemplateMela_Plugin', 'get_instance' ] );


register_activation_hook( TMTHEME_MAIN_PLUGIN_FILE, 'templatemela_plugin_activation' );
register_deactivation_hook( TMTHEME_MAIN_PLUGIN_FILE, 'templatemela_plugin_deactivation' );

/**
 * Runs on tmc core activation hook.
 */
function templatemela_plugin_activation() {

	// Redirect on activation.
	templatemela_plugin_reset_redirect();
}

/**
 * Runs on tmc core deactivation hook.
 */
function templatemela_plugin_deactivation() {
	// Reset on deactivation.
	templatemela_plugin_reset_redirect();

}

/**
 * Resets the Redirect Value.
 */
function templatemela_plugin_reset_redirect() {
	// Redirect on activation.
	add_option('templatemela_plugin_do_activation_redirect', true);
}

/**
 * Do redirect after plugin activation.
 *
 */
function templatemela_plugin_do_redirect_setup() {
	if ( get_option('templatemela_plugin_do_activation_redirect', false) ) {
		delete_option('templatemela_plugin_do_activation_redirect');
		exit( wp_redirect("admin.php?page=templatemela-setup") );
	}
}
if ( in_array( 'templatemela-core/templatemela-core.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
	add_action('admin_init', 'templatemela_plugin_do_redirect_setup');
}