<?php
/**
 * @package TemplateMela
 */
 
/**
 * Define the demo import files (remote files).
 *
 * To define imports, you just have to add the following code structure,
 * with your own values to your theme (using the 'tmsetup_import_files' filter).
 */
function prefix_tmsetup_import_files() {
	return array(
		array(
			'import_file_name'           => 'Default',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/default/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/default/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/default/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/default/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/default/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/default/',
		),
		array(
			'import_file_name'           => 'Electronics',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/electronics/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/electronics/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/electronics/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/electronics/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/electronics/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/electronics/',
		),
		array(
			'import_file_name'           => 'Electronics02',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/electronics02/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/electronics02/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/electronics02/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/electronics02/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/electronics02/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/electronics02/',
		),
		array(
			'import_file_name'           => 'Books',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/books/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/books/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/books/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/books/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/books/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/books/',
		),
		array(
			'import_file_name'           => 'Cosmetic',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/cosmetic/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/cosmetic/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/cosmetic/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/cosmetic/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/cosmetic/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/cosmetic/',
		),		
		array(
			'import_file_name'           => 'Tools',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/tools/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/tools/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/tools/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/tools/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/tools/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/tools/',
		),
		array(
			'import_file_name'           => 'Movie',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/movie/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/movie/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/movie/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/movie/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/movie/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/movie/',
		),
		array(
			'import_file_name'           => 'Organic',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/organic/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/organic/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/organic/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/organic/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/organic/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/organic/',
		),		
		array(
			'import_file_name'           => 'Autoparts',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/autoparts/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/autoparts/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/autoparts/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/autoparts/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/autoparts/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/autoparts/',
		),
		array(
			'import_file_name'           => 'Ceramic',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/ceramic/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/ceramic/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/ceramic/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/ceramic/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/ceramic/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/ceramic/',
		),
		array(
			'import_file_name'           => 'Coffee',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/coffee/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/coffee/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/coffee/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/coffee/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/coffee/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/coffee/',
		),
		array(
			'import_file_name'           => 'Fashion',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/fashion/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/fashion/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/fashion/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/fashion/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/fashion/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/fashion/',
		),
		array(
			'import_file_name'           => 'Flower',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/flower/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/flower/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/flower/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/flower/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/flower/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/flower/',
		),
		array(
			'import_file_name'           => 'Food',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/food/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/food/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/food/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/food/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/food/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/food/',
		),
		array(
			'import_file_name'           => 'Food02',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/food02/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/food02/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/food02/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/food02/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/food02/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/food02/',
		),
		array(
			'import_file_name'           => 'Furniture',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/furniture/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/furniture/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/furniture/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/furniture/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/furniture/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/furniture/',
		),
		array(
			'import_file_name'           => 'Grocery',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/grocery/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/grocery/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/grocery/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/grocery/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/grocery/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/grocery/',
		),
		array(
			'import_file_name'           => 'Gym',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/gym/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/gym/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/gym/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/gym/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/gym/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/gym/',
		),
		array(
			'import_file_name'           => 'Kids',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/kids/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/kids/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/kids/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/kids/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/kids/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/kids/',
		),
		array(
			'import_file_name'           => 'Medical',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/medical/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/medical/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/medical/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/medical/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/medical/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/medical/',
		),
		array(
			'import_file_name'           => 'Megashop',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/megashop/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/megashop/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/megashop/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/megashop/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/megashop/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/megashop/',
		),
		array(
			'import_file_name'           => 'Museum',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/museum/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/museum/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/museum/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/museum/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/museum/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/museum/',
		),
		array(
			'import_file_name'           => 'Pets',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/pets/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/pets/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/pets/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/pets/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/pets/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/pets/',
		),
		array(
			'import_file_name'           => 'Plants',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/plants/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/plants/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/plants/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/plants/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/plants/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/plants/',
		),
		array(
			'import_file_name'           => 'Shoes',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/shoes/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/shoes/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/shoes/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/shoes/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/shoes/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/shoes/',
		),

		array(
			'import_file_name'           => 'Handbag',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/handbag/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/handbag/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/handbag/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/handbag/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/handbag/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/handbag/',
		),

		array(
			'import_file_name'           => 'SpareParts',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/spareparts/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/spareparts/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/spareparts/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/spareparts/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/spareparts/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/spareparts/',
		),

		array(
			'import_file_name'           => 'Artcrafts',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/artcrafts/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/artcrafts/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/artcrafts/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/artcrafts/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/artcrafts/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/artcrafts/',
		),

		array(
			'import_file_name'           => 'Furniture02',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/furniture02/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/furniture02/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/furniture02/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/furniture02/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/furniture02/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-wooti' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG8/WCM187_wooti/furniture02/',
		),

	);
}
add_filter( 'tmsetup_import_files', 'prefix_tmsetup_import_files' );


/**
 * Define the demo import files (local files).
 */
function prefix_tmsetup_local_import_files() {
	return array(
		array(
			'import_file_name'             => 'Default',
			'local_import_file'            => TMTHEME_PATH . '/admin/demo-data/default/content.xml',
			'local_import_widget_file'     => TMTHEME_PATH . '/admin/demo-data/default/widgets.wie',
			'local_import_customizer_file' => TMTHEME_PATH . '/admin/demo-data/default/customizer.dat',
			'local_import_rev_slider_file' => TMTHEME_PATH . '/admin/demo-data/default/slider.zip',
			'import_preview_image_url'     => TMTHEME_URL . 'admin/demo-data/default/preview.png',
			'import_notice'                => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-plugin-wooti' ),
			'preview_url'                  => 'https://templatemela.com/demo/' . TMTHEME_ID,
		),
	);
}
//add_filter( 'tmsetup_import_files', 'prefix_tmsetup_local_import_files' );

/**
 * Execute custom code after the whole import has finished.
 */
function prefix_tmsetup_after_import_setup( $selected_import_index ) {

	// Grab the selected import file.
	$selected_import_file = $GLOBALS['wizard']->import_files[ $selected_import_index ];
	if ( isset( $selected_import_file['import_file_name'] ) && 'default' != sanitize_title( strtolower( $selected_import_file['import_file_name'] ) ) ) {
        update_option( 'wooti_selected_layout', sanitize_title( strtolower( $selected_import_file['import_file_name'] ) ) );
    }

	// Assign menus to their locations.
	$main_menu = get_term_by( 'name', 'Primary Navigation', 'nav_menu' );
	$secondary_menu = get_term_by( 'name', 'Secondary Menu', 'nav_menu' );
	$vertical_menu = get_term_by( 'name', 'Shop By Categories', 'nav_menu' );
	$mobile_secondary_menu = get_term_by( 'name', 'Shop By Categories', 'nav_menu' );
	$footer_menu = get_term_by( 'name', 'Footer Navigation', 'nav_menu' );

	set_theme_mod(
		'nav_menu_locations',
		array(
			'primary'  => $main_menu->term_id,
			'secondary' => $secondary_menu->term_id,
			'vertical' => $vertical_menu->term_id,
			'mobile-secondary' => $mobile_secondary_menu->term_id,
			'footer-menu' => $footer_menu->term_id,
		)
	);

	// Assign front page and posts page (blog page).
	$front_page_id = get_page_by_title( 'Home' );
	$blog_page_id  = get_page_by_title( 'Blog' );

	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', $front_page_id->ID );
	update_option( 'page_for_posts', $blog_page_id->ID );

	$woocommerce_shop = get_page_by_path( 'shop' );
	$woocommerce_checkout = get_page_by_path( 'checkout' );
	$woocommerce_cart = get_page_by_path( 'cart' );
	$woocommerce_myaccount = get_page_by_path( 'my-account' );

	update_option( 'woocommerce_cart', $woocommerce_cart->ID );
	update_option( 'woocommerce_checkout_page_id', $woocommerce_checkout->ID );
	update_option( 'woocommerce_cart_page_id', $woocommerce_cart->ID );
	update_option( 'woocommerce_myaccount_page_id', $woocommerce_myaccount->ID );
	update_option( 'woocommerce_shop_page_id', $woocommerce_shop->ID );

	$layout = sanitize_title( strtolower( $selected_import_file['import_file_name'] ) );
	if( ! empty( $layout ) &&  'default' != $layout ) {
		require_once TMTHEME_PATH . '/layouts/'.$layout.'/import-settings.php';
	} else {
		require_once TMTHEME_PATH . '/layouts/default/import-settings.php';
	}
	update_option( 'bt_woo_extras', json_encode( $import_settings ) );

	if ( class_exists( '\Elementor\Plugin' ) ) {
		// Default Pages
		$cpt_support = get_option( 'elementor_cpt_support' );
		if ( ! $cpt_support ) {
			$cpt_support = array( 'page', 'post', 'base_element' );
			update_option( 'elementor_cpt_support', $cpt_support );
		} else if ( ! in_array( 'base_element', $cpt_support ) ) {
			$cpt_support[] = 'base_element';
			update_option( 'elementor_cpt_support', $cpt_support );
		}
		// Disable Default Colors
		update_option( 'elementor_disable_color_schemes', 'yes' );
		update_option( 'elementor_disable_typography_schemes', 'yes' );

		update_option( 'elementor_experiment-block_editor_assets_optimize', 'inactive' );
		
		\Elementor\Plugin::$instance->files_manager->clear_cache();

	}
	// compare settings
	update_option('woosc_settings', array('button_icon' => 'left' , 'quick_table_label' => 'yes', 'perfect_scrollbar' => 'no' ) );
	// quick view settings
	update_option('woosq_settings', array('button_icon' => 'left' , 'button_position' => '0', 'perfect_scrollbar' => 'no'));
	// wishlist settings
	update_option('woosw_settings', array('button_icon' => 'left', 'perfect_scrollbar' => 'no'));

	update_option('woosq_button_position', '0');
	update_option('_wooscp_button_archive', '0');
	update_option('woosw_button_position_archive', '0');

}
add_action( 'tmsetup_after_all_import', 'prefix_tmsetup_after_import_setup' );