<?php

class PxlVideoPlayer_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_video_player';
    protected $title = 'Case Video Play';
    protected $icon = 'eicon-play';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"section_content","label":"Content","tab":"content","controls":[{"name":"video_link","label":"Link","type":"text","default":"https:\/\/www.youtube.com\/watch?v=SF4aHwxHtZ0"},{"name":"video_icon","label":"Video Icon","type":"icons","fa4compatibility":"icon"},{"name":"image_type","label":"Image Type","type":"select","options":{"none":"None","img":"Image","bg":"Background"},"default":"none"},{"name":"image","label":"Image","type":"media","condition":{"image_type":["img","bg"]}},{"name":"img_size","label":"Image Size","type":"text","description":"Enter image size (Example: \"thumbnail\", \"medium\", \"large\", \"full\" or other sizes defined by theme). Alternatively enter size in pixels (Example: 200x100 (Width x Height).","condition":{"image_type":"img"}},{"name":"img_border_radius","label":"Image Border Radius","type":"dimensions","size_units":["px"],"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video--imagebg, {{WRAPPER}} .pxl-video-player .pxl-video--holder img":"border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};"},"condition":{"image_type":["img","bg"]}},{"name":"image_height","label":"Image Height","type":"slider","description":"Enter number.","condition":{"image_type":"bg"},"range":{"px":{"min":0,"max":3000}},"control_type":"responsive","selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video--imagebg":"height: {{SIZE}}{{UNIT}};"}},{"name":"style_img","label":"Style Image","type":"select","options":{"style-img1":"Style Image1"},"default":"style-img1"},{"name":"btn_video_style","label":"Button Video Style","type":"select","options":{"style1":"Style White","style2":"Style Blur","style3":"Style Primary"},"default":"style1"},{"name":"btn_video_position","label":"Button Video Position","type":"select","options":{"p-center":"Center","p-top-left":"Top Left","p-top-right":"Top Right","p-bottom-left":"Bottom Left","p-bottom-right":"Bottom Right"},"default":"p-center","condition":{"image_type":["img","bg"]}},{"name":"icon_color","label":"Icon Color","type":"color","selectors":{"{{WRAPPER}} .pxl-video-player .pxl-btn-video":"color: {{VALUE}} !important;"}},{"name":"icon_color_hover","label":"Icon Color Hover","type":"color","selectors":{"{{WRAPPER}} .pxl-video-player .pxl-btn-video:hover":"color: {{VALUE}} !important;"}},{"name":"icon_size","label":"Icon Size","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-btn-video":"font-size: {{SIZE}}{{UNIT}};"}},{"name":"btn_width","label":"Button Width","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-btn-video":"width: {{SIZE}}{{UNIT}};"}},{"name":"btn_height","label":"Button Height","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-btn-video":"height: {{SIZE}}{{UNIT}};"}},{"name":"top_positioon","label":"Top Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"size":0,"unit":"%"},"range":{"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-left, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-right":"top: {{SIZE}}{{UNIT}};"},"condition":{"btn_video_position":["p-top-left","p-top-right"]}},{"name":"right_positioon","label":"Right Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"size":0,"unit":"%"},"range":{"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-right, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-right":"right: {{SIZE}}{{UNIT}};"},"condition":{"btn_video_position":["p-top-right","p-bottom-right"]}},{"name":"bottom_positioon","label":"Bottom Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"size":0,"unit":"%"},"range":{"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-left, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-right":"bottom: {{SIZE}}{{UNIT}};"},"condition":{"btn_video_position":["p-bottom-left","p-bottom-right"]}},{"name":"left_positioon","label":"Left Position","type":"slider","size_units":["px","%"],"control_type":"responsive","default":{"size":0,"unit":"%"},"range":{"%":{"min":0,"max":100}},"selectors":{"{{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-top-left, {{WRAPPER}} .pxl-video--holder + .btn-video-wrap.p-bottom-left":"left: {{SIZE}}{{UNIT}};"},"condition":{"btn_video_position":["p-top-left","p-bottom-left"]}},{"name":"t_width","label":"Max Width","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-video-player .pxl-video--inner":"max-width: {{SIZE}}{{UNIT}};"}},{"name":"overlay_color","label":"Overlay Color","type":"color","selectors":{"{{WRAPPER}} .pxl-video-player .pxl-overlay-color":"background-color: {{VALUE}};"}}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Case Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipCase":"flipCase","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateBg":"rotateBg","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollRight":"rollRight","wow rollOut":"rollOut","wow zoomInSmall":"zoomInSmall","wow zoomIn":"zoomInBig","wow zoomOut":"zoomOut","wow skewIn":"skewInLeft","wow skewInRight":"skewInRight","wow skewInBottom":"skewInBottom","wow RotatingY":"RotatingY","wow PXLfadeInUp":"PXLfadeInUp","fadeInPopup":"fadeInPopup","wow pxl-bounce-animation":"Pxl Bounce Animation","fadeInLeftJs":"fadeInLeftJs","fadeInRightJs":"fadeInRightJs","fadeInupJs":"fadeInupJs","fadeIndownJs":"fadeIndownJs","fadeInZoomJs":"fadeInZoomJs"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'tilt' );
}