<?php
/**
 * @package Case-Themes
 */
$archive_readmore = maxcare()->get_theme_opt( 'archive_readmore', true );
$archive_readmore_text = maxcare()->get_theme_opt('archive_readmore_text', esc_html__('Read More', 'maxcare'));
$featured_img_size = maxcare()->get_theme_opt('featured_img_size', '1204x900');
$post_video_link = get_post_meta( $post->ID, 'post_video_link', true );
$archive_date = maxcare()->get_theme_opt( 'archive_date', true );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('pxl---post pxl-item--archive pxl-item--standard'); ?>>
    <div class="pxl-item-inner pxl-post--inner">
        <?php
        if (has_post_thumbnail()) {
            $img = pxl_get_image_by_size(array(
                'attach_id'  => get_post_thumbnail_id($post->ID),
                'thumb_size' => $featured_img_size,
            ));

            $thumbnail = $img['thumbnail'];

            if (!empty($thumbnail)) {
                echo '<div class="pxl-item--image">'; ?>
                    <a class="pxl-link-image hover-imge-effect3" href="<?php echo esc_url(get_permalink()); ?>">
                        <?php echo pxl_print_html($thumbnail); ?>
                    </a>

                    <div class="pxl-post-video pxl-video-player">
                        <?php if (!empty($post_video_link)) : ?>
                            <a class="pxl-btn-video pxl-action-popup btn-text-parallax" href="<?php echo esc_url($post_video_link); ?>">
                                <i class="caseicon-play1"></i>
                            </a>
                        <?php endif; ?>
                    </div>

                <?php echo '</div>';
            }
        }
        ?>
        <div class="pxl-item--holder">
            <?php maxcare()->blog->get_archive_meta(); ?>
            <h6 class="pxl-item--title">
                <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                    <?php the_title(); ?>
                </a>
            </h6>
            <div class="pxl-item--excerpt">
                <?php
                    maxcare()->blog->get_excerpt();
                    wp_link_pages( array(
                        'before'      => '<div class="page-links">',
                        'after'       => '</div>',
                        'link_before' => '<span>',
                        'link_after'  => '</span>',
                    ) );
                ?>
            </div>
            <div class="pxl-item-bottom">
                <?php if($archive_readmore) : ?>
                    <div class="pxl-item--readmore">
                        <a class="btn-archive" href="<?php echo esc_url( get_permalink()); ?>">
                            <span class="pxl--btn-text">
                                <?php echo maxcare_html($archive_readmore_text); ?>
                            </span>
                            <span class="pxl-btn-icon">
                                <svg width="13" height="14" viewBox="0 0 13 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M10.7573 4.35698L2.04775 13.0665L0.616943 11.6356L9.32539 2.92612H1.65011V0.902344H12.781V12.0333H10.7573V4.35698Z" fill="#00B4D8"></path>
                            </span>
                        </svg>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</article>