<?php
 
add_action( 'pxl_post_metabox_register', 'maxcare_page_options_register' );
function maxcare_page_options_register( $metabox ) {
 
	$panels = [
		'post' => [
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post Options', 'maxcare' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Header', 'maxcare' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        maxcare_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						maxcare_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'header_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Header Display', 'maxcare'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'maxcare'),
				                    'hide'  => esc_html__('Hide', 'maxcare'),
				                ),
				                'default'  => 'show',
				            ),
				            array(
				           		'id'       => 'logo_m',
					            'type'     => 'media',
					            'title'    => esc_html__('Mobile Logo', 'maxcare'),
					            'default'  => '',
					            'url'      => false,
					        ),
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'maxcare' ),
				                'options'  => maxcare_get_nav_menu_slug(),
				                'default' => '',
				            ),
					    ),
					    array(
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'maxcare'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'maxcare'),
				                    'pxl-sticky-stt' => esc_html__('Scroll To Top', 'maxcare'),
				                    'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'maxcare'),
				                ),
				                'default'  => '-1',
				            ),
				            array(
				                'id'       => 'header_margin',
				                'type'     => 'spacing',
				                'mode'     => 'margin',
				                'title'    => esc_html__('Margin', 'maxcare'),
				                'width'    => false,
				                'unit'     => 'px',
				                'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
				            ),
				        )
				    )
					 
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'maxcare' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        maxcare_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'post_settings' => [
					'title'  => esc_html__( 'Post Options', 'maxcare' ),
					'icon'   => 'el el-cog',
					'fields' => array_merge(
						maxcare_sidebar_pos_opts(['prefix' => 'post_', 'default' => true, 'default_value' => '-1']),
						array(
							array(
								'id'=>'custom_post_heading',
								'type' => 'text',
								'title'    => esc_html__('Custom Heading For Post', 'maxcare'),
							),
							
							array(
					            'id'=> 'post_video_link',
					            'type' => 'text',
					            'title' => esc_html__('Video Link', 'maxcare'),
					            'validate' => 'url',
					            'default' => '',
					        ),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'margin',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'maxcare' ),
								'default'        => array(
									'margin-top'    => '',
									'margin-bottom' => '',
									'units'          => 'px',
								)
							),
					    )
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'maxcare' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        maxcare_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'footer_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Display', 'maxcare'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'maxcare'),
				                    'hide'  => esc_html__('Hide', 'maxcare'),
				                ),
				                'default'  => 'show',
				            ),
							array(
				                'id'       => 'p_footer_fixed',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Fixed', 'maxcare'),
				                'options'  => array(
				                    'inherit' => esc_html__('Inherit', 'maxcare'),
				                    'on' => esc_html__('On', 'maxcare'),
				                    'off' => esc_html__('Off', 'maxcare'),
				                ),
				                'default'  => 'inherit',
				            ),
				            array(
				                'id'       => 'back_top_top_style',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Back to Top Style', 'maxcare'),
				                'options'  => array(
				                    'style-default' => esc_html__('Default', 'maxcare'),
				                    'style-round' => esc_html__('Round', 'maxcare'),
				                ),
				                'default'  => 'style-default',
				            ),
						)
				    )
				],
			]
		],
		'page' => [
			'opt_name'            => 'pxl_page_options',
			'display_name'        => esc_html__( 'Page Options', 'maxcare' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Header', 'maxcare' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        maxcare_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						maxcare_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'header_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Header Display', 'maxcare'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'maxcare'),
				                    'hide'  => esc_html__('Hide', 'maxcare'),
				                ),
				                'default'  => 'show',
				            ),
				            array(
				           		'id'       => 'logo_m',
					            'type'     => 'media',
					            'title'    => esc_html__('Mobile Logo', 'maxcare'),
					            'default'  => '',
					            'url'      => false,
					        ),
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'maxcare' ),
				                'options'  => maxcare_get_nav_menu_slug(),
				                'default' => '',
				            ),
					    ),
					    array(
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'maxcare'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'maxcare'),
				                    'pxl-sticky-stt' => esc_html__('Scroll To Top', 'maxcare'),
				                    'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'maxcare'),
				                ),
				                'default'  => '-1',
				            ),
				            array(
				                'id'       => 'header_margin',
				                'type'     => 'spacing',
				                'mode'     => 'margin',
				                'title'    => esc_html__('Margin', 'maxcare'),
				                'width'    => false,
				                'unit'     => 'px',
				                'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
				            ),
				        )
				    )
					 
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'maxcare' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        maxcare_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'maxcare' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						maxcare_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'margin',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'maxcare' ),
								'default'        => array(
									'margin-top'    => '',
									'margin-bottom' => '',
									'units'          => 'px',
								)
							), 
					    )
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'maxcare' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        maxcare_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'footer_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Display', 'maxcare'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'maxcare'),
				                    'hide'  => esc_html__('Hide', 'maxcare'),
				                ),
				                'default'  => 'show',
				            ),
							array(
				                'id'       => 'p_footer_fixed',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Fixed', 'maxcare'),
				                'options'  => array(
				                    'inherit' => esc_html__('Inherit', 'maxcare'),
				                    'on' => esc_html__('On', 'maxcare'),
				                    'off' => esc_html__('Off', 'maxcare'),
				                ),
				                'default'  => 'inherit',
				            ),
				            array(
				                'id'       => 'back_top_top_style',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Back to Top Style', 'maxcare'),
				                'options'  => array(
				                    'style-default' => esc_html__('Default', 'maxcare'),
				                    'style-round' => esc_html__('Round', 'maxcare'),
				                ),
				                'default'  => 'style-default',
				            ),
						)
				    )
				],
				'colors' => [
					'title'  => esc_html__( 'Colors', 'maxcare' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        array(
				        	array(
					            'id'          => 'body_bg_color',
					            'type'        => 'color',
					            'title'       => esc_html__('Body Background Color', 'maxcare'),
					            'transparent' => false,
					            'default'     => ''
					        ),
				        	array(
					            'id'          => 'primary_color',
					            'type'        => 'color',
					            'title'       => esc_html__('Primary Color', 'maxcare'),
					            'transparent' => false,
					            'default'     => ''
					        ),
					        array(
					            'id'          => 'gradient_color',
					            'type'        => 'color_gradient',
					            'title'       => esc_html__('Gradient Color', 'maxcare'),
					            'transparent' => false,
					            'default'  => array(
					                'from' => '',
					                'to'   => '', 
					            ),
					        ),
					    )
				    )
				],
				'extra' => [
					'title'  => esc_html__( 'Extra', 'maxcare' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        array(
				        	array(
					            'id' => 'body_custom_class',
					            'type' => 'text',
					            'title' => esc_html__('Body Custom Class', 'maxcare'),
					        ),
					    )
				    )
				]
			]
		],
		'portfolio' => [
			'opt_name'            => 'pxl_portfolio_options',
			'display_name'        => esc_html__( 'Portfolio Options', 'maxcare' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header_portfolio' => [
					'title'  => esc_html__( 'General', 'maxcare' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						maxcare_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						maxcare_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'       => 'header_display',
								'type'     => 'button_set',
								'title'    => esc_html__('Header Display', 'maxcare'),
								'options'  => array(
									'show' => esc_html__('Show', 'maxcare'),
									'hide'  => esc_html__('Hide', 'maxcare'),
								),
								'default'  => 'show',
							),
							array(
								'id'       => 'p_menu',
								'type'     => 'select',
								'title'    => esc_html__( 'Menu', 'maxcare' ),
								'options'  => maxcare_get_nav_menu_slug(),
								'default' => '',
							),
						),
						array(
							array(
								'id'       => 'sticky_scroll',
								'type'     => 'button_set',
								'title'    => esc_html__('Sticky Scroll', 'maxcare'),
								'options'  => array(
									'-1' => esc_html__('Inherit', 'maxcare'),
									'pxl-sticky-stt' => esc_html__('Scroll To Top', 'maxcare'),
									'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'maxcare'),
								),
								'default'  => '-1',
							),
							array(
								'id'       => 'header_margin',
								'type'     => 'spacing',
								'mode'     => 'margin',
								'title'    => esc_html__('Margin', 'maxcare'),
								'width'    => false,
								'unit'     => 'px',
								'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
							),
						),
						array(
							array(
                                'id'          => 'location',
                                'type'        => 'text',
                                'title'       => esc_html__( 'Location', 'maxcare' ),
                            ),
                            array(
                                'id'          => 'area_project',
                                'type'        => 'text',
                                'title'       => esc_html__( 'Area Project', 'maxcare' ),
                            ),
                            array(
                                'id'          => 'date_finish',
                                'type'        => 'text',
                                'title'       => esc_html__( 'Date Finish', 'maxcare' ),
                            ),
							array(
					            'id'=> 'portfolio_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'maxcare'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
								'id'=>'custom_portfolio_number_carousel',
								'type' => 'text',
								'title'    => esc_html__('Custom Number For Portfolio', 'maxcare'),
							),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'margin',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'maxcare' ),
								'default'        => array(
									'margin-top'    => '',
									'margin-bottom' => '',
									'units'          => 'px',
								)
							),
						),
						maxcare_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'maxcare' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        maxcare_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'colors' => [
					'title'  => esc_html__( 'Portfolio Colors', 'maxcare' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        array(
				        	array(
					            'id'          => 'body_bg_color',
					            'type'        => 'color',
					            'title'       => esc_html__('Body Background Color', 'maxcare'),
					            'transparent' => false,
					            'default'     => ''
					        ),
				        	array(
					            'id'          => 'primary_color',
					            'type'        => 'color',
					            'title'       => esc_html__('Primary Color', 'maxcare'),
					            'transparent' => false,
					            'default'     => ''
					        ),
					        array(
					            'id'          => 'gradient_color',
					            'type'        => 'color_gradient',
					            'title'       => esc_html__('Gradient Color', 'maxcare'),
					            'transparent' => false,
					            'default'  => array(
					                'from' => '',
					                'to'   => '', 
					            ),
					        ),
					    )
				    )
				],
			]
		],

		'service' => [
			'opt_name'            => 'pxl_service_options',
			'display_name'        => esc_html__( 'Service Options', 'maxcare' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header_service' => [
					'title'  => esc_html__( 'General', 'maxcare' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						maxcare_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						maxcare_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
								'id'       => 'header_display',
								'type'     => 'button_set',
								'title'    => esc_html__('Header Display', 'maxcare'),
								'options'  => array(
									'show' => esc_html__('Show', 'maxcare'),
									'hide'  => esc_html__('Hide', 'maxcare'),
								),
								'default'  => 'show',
							),
							array(
								'id'       => 'p_menu',
								'type'     => 'select',
								'title'    => esc_html__( 'Menu', 'maxcare' ),
								'options'  => maxcare_get_nav_menu_slug(),
								'default' => '',
							),
						),
						array(
							array(
								'id'       => 'sticky_scroll',
								'type'     => 'button_set',
								'title'    => esc_html__('Sticky Scroll', 'maxcare'),
								'options'  => array(
									'-1' => esc_html__('Inherit', 'maxcare'),
									'pxl-sticky-stt' => esc_html__('Scroll To Top', 'maxcare'),
									'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'maxcare'),
								),
								'default'  => '-1',
							),
							array(
								'id'       => 'header_margin',
								'type'     => 'spacing',
								'mode'     => 'margin',
								'title'    => esc_html__('Margin', 'maxcare'),
								'width'    => false,
								'unit'     => 'px',
								'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
							),
						),

						array(
							array(
					            'id'=> 'service_external_link',
					            'type' => 'text',
					            'title' => esc_html__('External Link', 'maxcare'),
					            'validate' => 'url',
					            'default' => '',
					        ),
							array(
					            'id'=> 'service_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'maxcare'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
					            'id'       => 'service_icon_type',
					            'type'     => 'button_set',
					            'title'    => esc_html__('Icon Type', 'maxcare'),
					            'options'  => array(
					                'icon'  => esc_html__('Icon', 'maxcare'),
					                'image'  => esc_html__('Image', 'maxcare'),
					            ),
					            'default'  => 'icon'
					        ),
					        array(
					            'id'       => 'service_icon_font',
					            'type'     => 'pxl_iconpicker',
					            'title'    => esc_html__('Icon', 'maxcare'),
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'icon' ),
            					'force_output' => true
					        ),
					        array(
					            'id'       => 'service_icon_img',
					            'type'     => 'media',
					            'title'    => esc_html__('Icon Image', 'maxcare'),
					            'default' => '',
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'image' ),
				            	'force_output' => true
					        ),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'margin',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'maxcare' ),
								'default'        => array(
									'margin-top'    => '',
									'margin-bottom' => '',
									'units'          => 'px',
								)
							),
							array(
								'id'=>'custom_service_title_carousel',
								'type' => 'text',
								'title'    => esc_html__('Custom Title For service', 'maxcare'),
							),
							array(
								'id'=>'button_text',
								'type' => 'text',
								'title'    => esc_html__('Custom button text For service', 'maxcare'),
							),
						),
						maxcare_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'maxcare' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        maxcare_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'colors' => [
					'title'  => esc_html__( 'Service Colors', 'maxcare' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        array(
				        	array(
					            'id'          => 'body_bg_color',
					            'type'        => 'color',
					            'title'       => esc_html__('Body Background Color', 'maxcare'),
					            'transparent' => false,
					            'default'     => ''
					        ),
				        	array(
					            'id'          => 'primary_color',
					            'type'        => 'color',
					            'title'       => esc_html__('Primary Color', 'maxcare'),
					            'transparent' => false,
					            'default'     => ''
					        ),
					        array(
					            'id'          => 'gradient_color',
					            'type'        => 'color_gradient',
					            'title'       => esc_html__('Gradient Color', 'maxcare'),
					            'transparent' => false,
					            'default'  => array(
					                'from' => '',
					                'to'   => '', 
					            ),
					        ),
					    )
				    )
				],
			]
		],

		'career' => [
			'opt_name'            => 'pxl_career_options',
			'display_name'        => esc_html__( 'Career Options', 'maxcare' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'maxcare' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
					            'id'=> 'career_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'maxcare'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'margin',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'maxcare' ),
								'default'        => array(
									'margin-top'    => '',
									'margin-bottom' => '',
									'units'          => 'px',
								)
							),
							array(
								'id'=>'custom_career_title_carousel',
								'type' => 'text',
								'title'    => esc_html__('Custom Title For career', 'maxcare'),
							),
							array(
								'id'=>'button_text',
								'type' => 'text',
								'title'    => esc_html__('Custom button text For career', 'maxcare'),
							),
						)
				    )
				],
				'career_page_title' => [
					'title'  => esc_html__( 'Career Page Title', 'maxcare' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        maxcare_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
			]
		],

		'pxl-template' => [ //post_type
			'opt_name'            => 'pxl_hidden_template_options',
			'display_name'        => esc_html__( 'Template Options', 'maxcare' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'maxcare' ),
					'icon'   => 'el-icon-website',
					'fields' => array(
						array(
							'id'    => 'template_type',
							'type'  => 'select',
							'title' => esc_html__('Type', 'maxcare'),
				            'options' => [
				            	'df'       	   => esc_html__('Select Type', 'maxcare'), 
								'header'       => esc_html__('Header Desktop', 'maxcare'),
								'header-mobile'       => esc_html__('Header Mobile', 'maxcare'),
								'footer'       => esc_html__('Footer', 'maxcare'), 
								'mega-menu'    => esc_html__('Mega Menu', 'maxcare'), 
								'page-title'   => esc_html__('Page Title', 'maxcare'), 
								'tab' => esc_html__('Tab', 'maxcare'),
								'hidden-panel' => esc_html__('Hidden Panel', 'maxcare'),
								'popup' => esc_html__('Popup', 'maxcare'),
								'page' => esc_html__('Page', 'maxcare'),
								'slider' => esc_html__('Slider', 'maxcare'),
								'wgaboutauthor' => esc_html__('Widget Sidebar', 'maxcare'),
				            ],
				            'default' => 'df',
				        ),
				        array(
							'id'    => 'header_type',
							'type'  => 'select',
							'title' => esc_html__('Header Type', 'maxcare'),
				            'options' => [
				            	'px-header--default'       	   => esc_html__('Default', 'maxcare'), 
								'px-header--transparent'       => esc_html__('Transparent', 'maxcare'),
								'px-header--fixed'       => esc_html__('Fixed', 'maxcare'),
				            ],
				            'default' => 'px-header--default',
				            'indent' => true,
                			'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header' ),
				        ),

				        array(
							'id'    => 'header_mobile_type',
							'type'  => 'select',
							'title' => esc_html__('Header Type', 'maxcare'),
				            'options' => [
				            	'px-header--default'       	   => esc_html__('Default', 'maxcare'), 
								'px-header--transparent'       => esc_html__('Transparent', 'maxcare'),
				            ],
				            'default' => 'px-header--default',
				            'indent' => true,
                			'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header-mobile' ),
				        ),

				        array(
							'id'    => 'hidden_panel_position',
							'type'  => 'select',
							'title' => esc_html__('Hidden Panel Position', 'maxcare'),
				            'options' => [
				            	'top'       	   => esc_html__('Top', 'maxcare'),
				            	'right'       	   => esc_html__('Right', 'maxcare'),
				            ],
				            'default' => 'right',
				            'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
				        ),
				        array(
				            'id'          => 'hidden_panel_height',
				            'type'        => 'text',
				            'title'       => esc_html__('Hidden Panel Height', 'maxcare'),
				            'subtitle'       => esc_html__('Enter number.', 'maxcare'),
				            'transparent' => false,
				            'default'     => '',
				            'force_output' => true,
				            'required' => array( 0 => 'hidden_panel_position', 1 => 'equals', 2 => 'top' ),
				        ),
				        array(
				            'id'          => 'hidden_panel_boxcolor',
				            'type'        => 'color',
				            'title'       => esc_html__('Box Color', 'maxcare'),
				            'transparent' => false,
				            'default'     => '',
				            'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
				        ),
					),
				    
				],
			]
		],
	];
 
	$metabox->add_meta_data( $panels );
}
 