<?php if(!function_exists('maxcare_configs')){
    function maxcare_configs($value){
        $configs = [
            'theme_colors' => [
                'primary'   => [
                    'title' => esc_html__('Primary', 'maxcare'), 
                    'value' => maxcare()->get_opt('primary_color', '#00B4D8')
                ],
                'secondary'   => [
                    'title' => esc_html__('Secondary', 'maxcare'), 
                    'value' => maxcare()->get_opt('secondary_color', '#686877')
                ],
                'third'   => [
                    'title' => esc_html__('Third', 'maxcare'), 
                    'value' => maxcare()->get_opt('third_color', '#687799')
                ],
                'dark'   => [
                    'title' => esc_html__('Dark', 'maxcare'), 
                    'value' => maxcare()->get_opt('dark_color', '#00194C')
                ],
                'body-bg'   => [
                    'title' => esc_html__('Body Background Color', 'maxcare'), 
                    'value' => maxcare()->get_page_opt('body_bg_color', '#fff')
                ]
            ],
            'link' => [
                'color' => maxcare()->get_opt('link_color', ['regular' => '#000137'])['regular'],
                'color-hover'   => maxcare()->get_opt('link_color', ['hover' => '#00B4D8'])['hover'],
                'color-active'  => maxcare()->get_opt('link_color', ['active' => '#00B4D8'])['active'],
            ],
            'gradient' => [
                'color-from' => maxcare()->get_opt('gradient_color', ['from' => '#fff'])['from'],
                'color-to' => maxcare()->get_opt('gradient_color', ['to' => '#00B4D8'])['to'],
            ],
               
        ];
        return $configs[$value];
    }
}
if(!function_exists('maxcare_inline_styles')) {
    function maxcare_inline_styles() {  
        
        $theme_colors      = maxcare_configs('theme_colors');
        $link_color        = maxcare_configs('link');
        $gradient_color    = maxcare_configs('gradient');
        ob_start();
        echo ':root{';
            
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color-rgb: %2$s;', str_replace('#', '',$color),  maxcare_hex_rgb($value['value']));
            }
            foreach ($link_color as $color => $value) {
                printf('--link-%1$s: %2$s;', $color, $value);
            }
            foreach ($gradient_color as $color => $value) {
                printf('--gradient-%1$s: %2$s;', $color, $value);
            }
        echo '}';

        return ob_get_clean();
         
    }
}
 