( function( $ ) {

    "use strict";

    var pxl_widget_tabs_handler = function( $scope, $ ) {
        $scope.find(".pxl-tabs.tab-effect-slide .pxl-tab--title").on("click", function(e){
            e.preventDefault();
            var target = $(this).data("target");
            var parent = $(this).parents(".pxl-tabs");
            parent.find(".pxl-tabs--content .pxl-tab--content").slideUp(300);
            parent.find(".pxl-tabs--title .pxl-tab--title").removeClass('active');
            $(this).addClass("active");
            $(target).slideDown(300);

            var iconContent = $(this).find('.pxl-item--icon').html() || '';
            var textContent = $(this).find('.pxl-title--text').html() || '';
            parent.find('.pxl-inner-change').html(`
                <div class="pxl-item--icon">${iconContent}</div>
                <div class="pxl-title--text">${textContent}</div>
            `);
        });

        $scope.find(".pxl-tabs.tab-effect-fade .pxl-tab--title").on("click", function(e){
            e.preventDefault();
            var target = $(this).data("target");
            var parent = $(this).parents(".pxl-tabs");
            parent.find(".pxl-tabs--content .pxl-tab--content").removeClass("active");
            parent.find(".pxl-tabs--title .pxl-tab--title").removeClass('active');
            $(this).addClass("active");
            $(target).addClass("active");

            var iconContent = $(this).find('.pxl-item--icon').html() || '';
            var textContent = $(this).find('.pxl-title--text').html() || '';
            parent.find('.pxl-inner-change').html(`
                <div class="pxl-item--icon">${iconContent}</div>
                <div class="pxl-title--text">${textContent}</div>
            `);
        });

        var firstTab = $scope.find('.pxl-tabs.style-3 .pxl-tabs--title .pxl-tab--title, .pxl-tabs.style-5 .pxl-tabs--title .pxl-tab--title').eq(0);
        if (firstTab.length > 0) {
            var iconContent = firstTab.find('.pxl-item--icon').html() || '';
            var textContent = firstTab.find('.pxl-title--text').html() || '';

            $scope.find('.pxl-tabs.style-3 .pxl-inner-change, .pxl-tabs.style-5 .pxl-inner-change').html(`
                <div class="pxl-item--icon">${iconContent}</div>
                <div class="pxl-title--text">${textContent}</div>
            `);
        }
    };

    $( window ).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_tabs.default', pxl_widget_tabs_handler );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_tabs_pricing.default', pxl_widget_tabs_handler );
    } );

} )( jQuery );