(function ($) {
  "use strict";

  function pxl_swiper_handler($scope) {
    $scope.find(".pxl-swiper-slider").each(function () {
      const $this = $(this);
      const $container = $this.find(".pxl-swiper-container");
      const settings = $container.data("settings");
      const allSlides = $this.find(".pxl-swiper-slide").clone();

      const uniqueId = "swiper-" + Math.random().toString(36).substr(2, 9);
      $container.attr("data-id", uniqueId);

      if ($container[0].swiper) {
        $container[0].swiper.destroy(true, true);
      }

      const carousel_settings = {
        direction: settings.slide_direction,
        effect: settings.slide_mode,
        wrapperClass: "pxl-swiper-wrapper",
        slideClass: "pxl-swiper-slide",
        slidesPerView: settings.slides_to_show,
        slidesPerGroup: settings.slides_to_scroll,
        slidesPerColumn: settings.slide_percolumn,
        spaceBetween: 0,
        observer: true,
        observeParents: true,
        navigation: {
          nextEl: $this.find(".pxl-swiper-arrow-next")[0],
          prevEl: $this.find(".pxl-swiper-arrow-prev")[0],
        },
        pagination: {
          type: settings.pagination_type,
          el: $this.find(".pxl-swiper-dots")[0],
          clickable: true,
          modifierClass: "pxl-swiper-pagination-",
          bulletClass: "pxl-swiper-pagination-bullet",
          renderBullet: function (index, className) {
            return '<span class="' + className + '"><span></span></span>';
          },
        },
        speed: settings.speed,
        watchSlidesProgress: true,
        watchSlidesVisibility: true,
        touchRatio: 1,
        simulateTouch: true,
        keyboard: false,
        mousewheel: $this.hasClass("pxl-portfolio-carousel4"),
        breakpoints: {
          0: {
            slidesPerView: settings.slides_to_show_xs,
            slidesPerGroup: settings.slides_to_scroll,
          },
          576: {
            slidesPerView: settings.slides_to_show_sm,
            slidesPerGroup: settings.slides_to_scroll,
          },
          768: {
            slidesPerView: settings.slides_to_show_md,
            slidesPerGroup: settings.slides_to_scroll,
          },
          992: {
            slidesPerView: settings.slides_to_show_lg,
            slidesPerGroup: settings.slides_to_scroll,
          },
          1200: {
            slidesPerView: settings.slides_to_show,
            slidesPerGroup: settings.slides_to_scroll,
          },
          1400: {
            slidesPerView: settings.slides_to_show_xxl,
            slidesPerGroup: settings.slides_to_scroll,
          },
        },
        on: {
          
        },
      };

      if (settings.center_slide === true || settings.center_slide === 'true') {
        carousel_settings.centeredSlides = true;
        carousel_settings.initialSlide = Math.floor(allSlides.length / 2);
      }

      if (settings.loop === true || settings.loop === 'true') {
        carousel_settings.loop = true;
      }

      if (settings.autoplay === true || settings.autoplay === 'true') {
        carousel_settings.autoplay = {
          delay: settings.delay,
          disableOnInteraction: settings.pause_on_interaction,
        };
      }

      if (settings.parallax === 'true') {
        carousel_settings.parallax = true;
      }

      // Thumbnail Swiper Setup
      if ($this.find(".pxl-swiper-thumbs").length > 0) {
        const $thumbContainer = $this.find(".pxl-swiper-thumbs");
        const thumb_settings = $thumbContainer.data("settings");

        const thumb_carousel_settings = {
          effect: thumb_settings.slide_mode,
          direction: thumb_settings.slide_direction,
          spaceBetween: 0,
          slidesPerView: thumb_settings.slides_to_show,
          centeredSlides: false,
          loop: thumb_settings.loop === true || thumb_settings.loop === 'true',
          watchSlidesProgress: true,
          slideToClickedSlide: true,
        };

        if (thumb_settings["creative-effect"] === "effect2") {
          thumb_carousel_settings.creativeEffect = {
            prev: {
              opacity: 0,
              translate: [0, "0%", 0],
            },
            next: {
              opacity: 0,
              translate: [0, "100%", 0],
            },
          };
        }

        const slide_thumbs = new Swiper($thumbContainer[0], thumb_carousel_settings);
        carousel_settings.thumbs = { swiper: slide_thumbs };
      }

      const swiper = new Swiper(`[data-id="${uniqueId}"]`, carousel_settings);

      if (settings.autoplay === 'true' && settings.pause_on_hover === 'true') {
        $container.on({
          mouseenter: function () {
            this.swiper.autoplay.stop();
          },
          mouseleave: function () {
            this.swiper.autoplay.start();
          },
        });
      }

      // Filter
      $this.find(".pxl--filter-inner .filter-item").on("click", function () {
        const target = $(this).attr("data-filter-target");
        $(this).addClass("active").siblings().removeClass("active");

        const $wrapper = $this.find(".pxl-swiper-wrapper").empty();

        if (target === "all") {
          allSlides.each(function () {
            $wrapper.append($(this).clone());
          });
        } else {
          allSlides.each(function () {
            const $el = $(this);
            if (
              $el.is(`[data-filter^='${target}']`) ||
              $el.is(`[data-filter*='${target}']`)
            ) {
              $wrapper.append($el.clone());
            }
          });
        }

        if ($container[0].swiper) $container[0].swiper.destroy(true, true);
        new Swiper(`[data-id="${uniqueId}"]`, carousel_settings);
      });
    });
  }

  // Hover Active Image
  $(".pxl-image-carousel1 .pxl-item--inner").first().addClass("active");

  $(".pxl-image-carousel1").on("mouseenter", ".pxl-swiper-slide .pxl-item--inner", function () {
    $(".pxl-item--inner").removeClass("active");
    $(this).addClass("active");
  });

  $(".pxl-portfolio-carousel2").on("mouseenter", ".pxl-swiper-slide .pxl-post--inner", function () {
      $(".pxl-post--inner").removeClass("active"); 
      $(this).addClass("active");
  });

  // Elementor Init
  $(window).on("elementor/frontend/init", function () {
    [
      "pxl_post_carousel",
      "pxl_testimonial_carousel",
      "pxl_slider",
      "pxl_team_carousel",
      "pxl_thumbs_carousel",
      "pxl_gallery_carousel",
      "pxl_image_carousel",
      "pxl_carousel_custom",
      "pxl_case_carousel",
      "pxl_instagram_carousel",
    ].forEach(function (widget) {
      elementorFrontend.hooks.addAction(
        `frontend/element_ready/${widget}.default`,
        pxl_swiper_handler
      );
    });
  });
})(jQuery);
