<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);

$show_star = $widget->get_setting('show_star');

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); 

?>
<?php if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])): 
    $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '1000x1153'; ?>
    <div class="pxl-swiper-slider pxl-testimonial-carousel pxl-testimonial-carousel1" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'maxcare'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['testimonial'] as $key => $value):
                        $title = isset($value['title']) ? $value['title'] : '';
                        $desc = isset($value['desc']) ? $value['desc'] : '';
                        $sub_title = isset($value['sub_title']) ? $value['sub_title'] : '';
                        $image = isset($value['image']) ? $value['image'] : '';
                        $style_star = isset($value['style_star']) ? $value['style_star'] : '';
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item-inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                                <div class="pxl-section-img">
                                    <?php if(!empty($image['id'])) { 
                                        $img = pxl_get_image_by_size( array(
                                            'attach_id'  => $image['id'],
                                            'thumb_size' => $image_size,
                                            'class' => 'no-lazyload',
                                        ));
                                        $thumbnail = $img['thumbnail'];
                                        ?>
                                        <div class="pxl-item--img">
                                            <?php echo wp_kses_post($thumbnail); ?>
                                        </div>
                                    <?php } ?>
                                    <?php if ( !empty($value['pxl_icon']) && !empty($value['pxl_icon']['value']) ) : ?>
                                        <div class="pxl-item--icon">
                                            <?php \Elementor\Icons_Manager::render_icon(
                                                $value['pxl_icon'],
                                                [ 'aria-hidden' => 'true', 'class' => '' ],
                                                'i'
                                            ); ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="pxl-item-content">
                                    <div class="pxl-item-quote">
                                        <svg width="136" height="115" viewBox="0 0 136 115" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path d="M62.7273 15.6818V73.1818C62.7273 78.8447 61.6246 84.2489 59.4194 89.3945C57.2141 94.5401 54.233 98.9915 50.4758 102.749C46.7187 106.506 42.2674 109.487 37.1218 111.692C31.9762 113.897 26.572 115 20.9091 115H15.6818C14.2661 115 13.041 114.483 12.0064 113.448C10.9718 112.414 10.4545 111.188 10.4545 109.773V99.3182C10.4545 97.9025 10.9718 96.6773 12.0064 95.6428C13.041 94.6082 14.2661 94.0909 15.6818 94.0909H20.9091C26.6809 94.0909 31.6087 92.049 35.6925 87.9652C39.7763 83.8814 41.8182 78.9536 41.8182 73.1818V70.5682C41.8182 68.3902 41.0559 66.5388 39.5312 65.0142C38.0066 63.4896 36.1553 62.7273 33.9773 62.7273H15.6818C11.3258 62.7273 7.62311 61.2026 4.57386 58.1534C1.52462 55.1042 0 51.4015 0 47.0455V15.6818C0 11.3258 1.52462 7.62311 4.57386 4.57386C7.62311 1.52462 11.3258 0 15.6818 0H47.0455C51.4015 0 55.1042 1.52462 58.1534 4.57386C61.2026 7.62311 62.7273 11.3258 62.7273 15.6818ZM135.909 15.6818V73.1818C135.909 78.8447 134.806 84.2489 132.601 89.3945C130.396 94.5401 127.415 98.9915 123.658 102.749C119.901 106.506 115.449 109.487 110.304 111.692C105.158 113.897 99.7538 115 94.0909 115H88.8636C87.4479 115 86.2228 114.483 85.1882 113.448C84.1536 112.414 83.6364 111.188 83.6364 109.773V99.3182C83.6364 97.9025 84.1536 96.6773 85.1882 95.6428C86.2228 94.6082 87.4479 94.0909 88.8636 94.0909H94.0909C99.8627 94.0909 104.79 92.049 108.874 87.9652C112.958 83.8814 115 78.9536 115 73.1818V70.5682C115 68.3902 114.238 66.5388 112.713 65.0142C111.188 63.4896 109.337 62.7273 107.159 62.7273H88.8636C84.5076 62.7273 80.8049 61.2026 77.7557 58.1534C74.7064 55.1042 73.1818 51.4015 73.1818 47.0455V15.6818C73.1818 11.3258 74.7064 7.62311 77.7557 4.57386C80.8049 1.52462 84.5076 0 88.8636 0H120.227C124.583 0 128.286 1.52462 131.335 4.57386C134.384 7.62311 135.909 11.3258 135.909 15.6818Z" fill="#DFF9FF"/>
                                        </svg>
                                    </div>
                                    <?php if( $show_star == 'true' ) : ?>
                                        <span class="pxl-item--star pxl-item--<?php echo esc_attr( $style_star ); ?>-star">
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                            <i class="fa fa-star"></i>
                                        </span>
                                    <?php endif; ?>
                                    <div class="pxl-item--desc"><?php echo pxl_print_html($desc); ?></div>
                                    <div class="pxl-inner-title">
                                        <h5 class="pxl-item-heading"><?php echo pxl_print_html($title); ?></h5>
                                        <div class="pxl-sub-title"><?php echo pxl_print_html($sub_title); ?></div>
                                    </div>
                                </div>
                           </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            
            <?php if($pagination !== false): ?>
                <div class="pxl-swiper-dots style-1"></div>
            <?php endif; ?>

            <?php if($arrows !== false): ?>
                <div class="pxl-swiper-arrow-wrap style-1">
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev">
                        <svg width="10" height="16" viewBox="0 0 10 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M9 1L2 8L9 14.5" stroke="#000" stroke-width="1.5"/>
                        </svg>
                    </div>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next">
                        <svg width="10" height="16" viewBox="0 0 10 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                          <path d="M1 1L8 8L1 14.5" stroke="#000" stroke-width="1.5"/>
                        </svg>
                    </div>
                </div>
            <?php endif; ?>
            
        </div>
    </div>
<?php endif; ?>
