<?php
$html_id = pxl_get_element_id($settings);
?>
<div class="pxl-table pxl-table1 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-table-inner">
        <table class="pxl-spotify-table pxl-songs-table">
            <thead class="pxl-item-thead">
              <tr class="pxl-item-tr">
                <?php if(!empty($settings['number'])) : ?>
                    <th class="pxl-title-name"><?php echo esc_html($settings['number']); ?></th>
                <?php endif; ?>
                <?php if(!empty($settings['title_day'])) : ?>
                    <th class="pxl-title-day highlight-list">
                        <span class="day1">
                            <?php echo esc_html($settings['title_day']); ?>
                            <i class="caseicon-long-arrow-right-two"></i>
                        </span>
                        <?php if(!empty($settings['title_day2'])) : ?>
                            <span class="day2">
                                <?php echo esc_html($settings['title_day2']); ?>
                                <i class="caseicon-long-arrow-right-two"></i>
                            </span>
                        <?php endif; ?>
                    </th>
                <?php endif; ?>
                <?php if(!empty($settings['title_monday'])) : ?>
                    <th class="pxl-title-monday"><?php echo esc_html($settings['title_monday']); ?></th>
                <?php endif; ?>
                <?php if(!empty($settings['title_tuesday'])) : ?>
                    <th class="pxl-title-tuesday"><?php echo esc_html($settings['title_tuesday']); ?></th>
                <?php endif; ?>
                <?php if(!empty($settings['title_wednesday'])) : ?>
                    <th class="pxl-title-wednesday"><?php echo esc_html($settings['title_wednesday']); ?></th>
                <?php endif; ?>
                <?php if(!empty($settings['title_thursday'])) : ?>
                    <th class="pxl-title-thursday"><?php echo esc_html($settings['title_thursday']); ?></th>
                <?php endif; ?>
                <?php if(!empty($settings['title_friday'])) : ?>
                    <th class="pxl-title-friday"><?php echo esc_html($settings['title_friday']); ?></th>
                <?php endif; ?>
                <?php if(!empty($settings['title_saturday'])) : ?>
                    <th class="pxl-title-saturday"><?php echo esc_html($settings['title_saturday']); ?></th>
                <?php endif; ?>
                <?php if(!empty($settings['title_sunday'])) : ?>
                    <th class="pxl-title-sunday"><?php echo esc_html($settings['title_sunday']); ?></th>
                <?php endif; ?>
              </tr>
            </thead>

            <?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): 
                $is_new = \Elementor\Icons_Manager::is_migration_allowed(); ?>
                <tbody class="pxl-list">
                    <?php foreach ($settings['lists'] as $key => $value): ?>
                        <tr class="pxl--item">
                            <?php if(!empty($value['list_number'])) : ?>
                                <td class="pxl-text-name" data-label="<?php echo esc_attr($settings['number']); ?>">
                                    <?php echo pxl_print_html($value['list_number'])?>
                                </td>
                            <?php endif; ?>
                            <?php if(!empty($value['list_day'])) : ?>
                                <td class="pxl-text-day highlight" data-label="<?php echo esc_attr($settings['title_day']); ?>">
                                    <?php echo pxl_print_html($value['list_day'])?>
                                </td>
                            <?php endif; ?>
                            <?php if(!empty($value['list_monday'])) : ?>
                                <td class="pxl-text-monday highlight-list" data-label="<?php echo esc_attr($settings['title_monday']); ?>">
                                    <span class="monday1">
                                        <?php echo pxl_print_html($value['list_monday'])?>
                                    </span>
                                    <?php if(!empty($value['list_monday2'])) : ?>
                                        <span class="monday2">
                                            <?php echo pxl_print_html($value['list_monday2'])?>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            <?php endif; ?>
                            <?php if(!empty($value['list_tuesday'])) : ?>
                                <td class="pxl-text-tuesday highlight-list" data-label="<?php echo esc_attr($settings['title_tuesday']); ?>">
                                    <span class="tuesday1">
                                        <?php echo pxl_print_html($value['list_tuesday'])?>
                                    </span>
                                    <?php if(!empty($value['list_tuesday2'])) : ?>
                                        <span class="tuesday2">
                                            <?php echo pxl_print_html($value['list_tuesday2'])?>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            <?php endif; ?>
                            <?php if(!empty($value['list_wednesday'])) : ?>
                                <td class="pxl-text-wednesday highlight-list" data-label="<?php echo esc_attr($settings['title_wednesday']); ?>">
                                    <span class="wednesday1">
                                        <?php echo pxl_print_html($value['list_wednesday'])?>
                                    </span>
                                    <?php if(!empty($value['list_wednesday2'])) : ?>
                                        <span class="wednesday2">
                                            <?php echo pxl_print_html($value['list_wednesday2'])?>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            <?php endif; ?>
                            <?php if(!empty($value['list_thursday'])) : ?>
                                <td class="pxl-text-thursday highlight-list" data-label="<?php echo esc_attr($settings['title_thursday']); ?>">
                                    <span class="thursday1">
                                        <?php echo pxl_print_html($value['list_thursday'])?>
                                    </span>
                                    <?php if(!empty($value['list_thursday2'])) : ?>
                                        <span class="thursday2">
                                            <?php echo pxl_print_html($value['list_thursday2'])?>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            <?php endif; ?>
                            <?php if(!empty($value['list_friday'])) : ?>
                                <td class="pxl-text-friday highlight-list" data-label="<?php echo esc_attr($settings['title_friday']); ?>">
                                    <span class="friday1">
                                        <?php echo pxl_print_html($value['list_friday'])?>
                                    </span>
                                    <?php if(!empty($value['list_friday2'])) : ?>
                                        <span class="friday2">
                                            <?php echo pxl_print_html($value['list_friday2'])?>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            <?php endif; ?>
                            <?php if(!empty($value['list_saturday'])) : ?>
                                <td class="pxl-text-saturday highlight-list" data-label="<?php echo esc_attr($settings['title_saturday']); ?>">
                                    <span class="saturday1">
                                        <?php echo pxl_print_html($value['list_saturday'])?>
                                    </span>
                                    <?php if(!empty($value['list_saturday2'])) : ?>
                                        <span class="saturday2">
                                            <?php echo pxl_print_html($value['list_saturday2'])?>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            <?php endif; ?>
                            <?php if(!empty($value['list_sunday'])) : ?>
                                <td class="pxl-text-sunday highlight-list" data-label="<?php echo esc_attr($settings['title_sunday']); ?>">
                                    <span class="sunday1">
                                        <?php echo pxl_print_html($value['list_sunday'])?>
                                    </span>
                                    <?php if(!empty($value['list_sunday2'])) : ?>
                                        <span class="sunday2">
                                            <?php echo pxl_print_html($value['list_sunday2'])?>
                                        </span>
                                    <?php endif; ?>
                                </td>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            <?php endif; ?>
        </table>
    </div>
</div>