<?php
$html_id = pxl_get_element_id($settings);
if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link_text', 'href', $settings['link']['url'] );

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link_text', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link_text', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-service-box pxl-service-box1">
	<div class="pxl-item-inner">
        <div class="pxl-hover-bg-boxes" style="background-image: url(<?php echo esc_attr($settings['bg_image']['url']); ?>);"></div>
		<div class="pxl-meta-content <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
            <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
                <div class="pxl-item--icon">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                </div>
            <?php endif; ?>
            <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
                <div class="pxl-item--icon">
                    <?php $img_icon  = pxl_get_image_by_size( array(
                            'attach_id'  => $settings['icon_image']['id'],
                            'thumb_size' => 'full',
                        ) );
                        $thumbnail_icon    = $img_icon['thumbnail'];
                    echo pxl_print_html($thumbnail_icon); ?>
                </div>
            <?php endif; ?>
            <div class="pxl-item-title">
                <?php echo esc_attr($settings['title']); ?>
            </div>
            <div class="pxl-item-desc">
                <?php echo esc_attr($settings['desc']); ?>
            </div>
            <div class="pxl-sevice--btn">
                <a class="pxl-item-btn" <?php pxl_print_html($widget->get_render_attribute_string( 'link_text' )); ?>>
                    <span class="pxl-btn-title pxl--btn-text">
                        <?php echo esc_attr($settings['title_btn'])?>
                    </span>
                    <span class="pxl-icon-button">
                        <svg width="23" height="20" viewBox="0 0 23 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                          <path d="M21.6011 10.2021L21.6401 9.57715H21.6206C21.6206 9.57715 21.6141 9.57715 21.6011 9.57715C21.5881 9.57715 21.575 9.57715 21.562 9.57715C21.5229 9.56413 21.4806 9.55436 21.4351 9.54785C21.3895 9.54134 21.3407 9.53158 21.2886 9.51855C21.1714 9.49251 21.0314 9.45996 20.8687 9.4209C20.7059 9.38184 20.5203 9.32975 20.312 9.26465C19.9214 9.14746 19.4852 8.98796 19.0034 8.78613C18.5216 8.58431 18.0464 8.32715 17.5776 8.01465C17.1479 7.72819 16.7606 7.36361 16.4155 6.9209C16.0705 6.47819 15.7808 6.03548 15.5464 5.59277C15.4292 5.37142 15.325 5.16634 15.2339 4.97754C15.1427 4.78874 15.0711 4.62272 15.019 4.47949C14.993 4.40137 14.967 4.33626 14.9409 4.28418C14.9149 4.2321 14.8953 4.18652 14.8823 4.14746C14.8823 4.12142 14.8791 4.10189 14.8726 4.08887C14.866 4.07585 14.8563 4.06283 14.8433 4.0498V4.03027C14.8433 4.03027 14.8172 4.04004 14.7651 4.05957C14.7131 4.0791 14.5438 4.13444 14.2573 4.22559C13.9578 4.32975 13.7821 4.38835 13.73 4.40137C13.6779 4.41439 13.6519 4.4209 13.6519 4.4209L13.6714 4.45996C13.6714 4.47298 13.6746 4.48926 13.6812 4.50879C13.6877 4.52832 13.6974 4.55111 13.7104 4.57715C13.7235 4.61621 13.743 4.66829 13.769 4.7334C13.7951 4.7985 13.8276 4.87012 13.8667 4.94824C13.9318 5.10449 14.0132 5.29004 14.1108 5.50488C14.2085 5.71973 14.3224 5.94434 14.4526 6.17871C14.7131 6.66048 15.0451 7.16829 15.4487 7.70215C15.8524 8.236 16.3341 8.69173 16.894 9.06934C17.0373 9.16048 17.1805 9.24837 17.3237 9.33301C17.467 9.41764 17.6102 9.49902 17.7534 9.57715H1.64014V10.8271H17.7534C17.6102 10.9053 17.467 10.9867 17.3237 11.0713C17.1805 11.1559 17.0373 11.2438 16.894 11.335C16.3341 11.7126 15.8524 12.1683 15.4487 12.7021C15.0451 13.236 14.7131 13.7438 14.4526 14.2256C14.3224 14.46 14.2085 14.6813 14.1108 14.8896C14.0132 15.098 13.9318 15.2868 13.8667 15.4561C13.8276 15.5342 13.7951 15.6058 13.769 15.6709C13.743 15.736 13.7235 15.7881 13.7104 15.8271C13.6974 15.8532 13.6877 15.876 13.6812 15.8955C13.6746 15.915 13.6714 15.9248 13.6714 15.9248L13.6519 15.9639V15.9834C13.6519 15.9834 13.6779 15.9899 13.73 16.0029C13.7821 16.016 13.9578 16.0745 14.2573 16.1787C14.5438 16.2699 14.7131 16.3252 14.7651 16.3447C14.8172 16.3643 14.8433 16.374 14.8433 16.374V16.3545C14.8563 16.3415 14.866 16.3285 14.8726 16.3154C14.8791 16.3024 14.8823 16.2829 14.8823 16.2568C14.8953 16.2178 14.9149 16.1722 14.9409 16.1201C14.967 16.068 14.993 16.0029 15.019 15.9248C15.0711 15.7816 15.1427 15.6156 15.2339 15.4268C15.325 15.238 15.4292 15.0329 15.5464 14.8115C15.7808 14.3688 16.0705 13.9261 16.4155 13.4834C16.7606 13.0407 17.1479 12.6761 17.5776 12.3896C18.0464 12.0771 18.5216 11.82 19.0034 11.6182C19.4852 11.4163 19.9214 11.2568 20.312 11.1396C20.5203 11.0745 20.7059 11.0225 20.8687 10.9834C21.0314 10.9443 21.1714 10.9118 21.2886 10.8857C21.3407 10.8727 21.3895 10.863 21.4351 10.8564C21.4806 10.8499 21.5229 10.8402 21.562 10.8271C21.575 10.8271 21.5881 10.8271 21.6011 10.8271C21.6141 10.8271 21.6206 10.8271 21.6206 10.8271H21.6401L21.6011 10.2021Z" fill="#000"/>
                        </svg>
                    </span>
                </a>
            </div>
		</div>
	</div>
</div>