<?php
$html_id = pxl_get_element_id($settings);
$editor_title = $widget->get_settings_for_display( 'title' );
$editor_title = $widget->parse_text_editor( $editor_title ); 

$sg_post_title = maxcare()->get_theme_opt('sg_post_title', 'default');
$sg_post_title_text = maxcare()->get_theme_opt('sg_post_title_text');

$sg_product_ptitle = maxcare()->get_theme_opt('sg_product_ptitle', 'default');
$sg_product_ptitle_text = maxcare()->get_theme_opt('sg_product_ptitle_text');

$sg_service_title = maxcare()->get_theme_opt('sg_service_title', 'default');
$sg_service_title_text = maxcare()->get_theme_opt('sg_service_title_text');

$sg_portfolio_title = maxcare()->get_theme_opt('sg_portfolio_title', 'default');
$sg_portfolio_title_text = maxcare()->get_theme_opt('sg_portfolio_title_text');

$sg_career_title = maxcare()->get_theme_opt('sg_career_title', 'default');
$sg_career_title_text = maxcare()->get_theme_opt('sg_career_title_text');
?>

<div id="pxl-<?php echo esc_attr($html_id) ?>" class="pxl-heading <?php echo esc_attr($settings['sub_title_style']); ?>-style <?php if(!empty($settings['highlight_text_image']['id'])) { echo 'highlight-text-image'; } ?>">
	<div class="pxl-heading--inner">
		<div class="pxl-heading-content">
			<?php if(!empty($settings['sub_title'])) : ?>
				<div class="pxl-item--subtitle <?php echo esc_attr($settings['sub_title_style'].' '.$settings['pxl_animate_sub']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay_sub']); ?>ms">
					<?php if(!empty($settings['sub_title_style']) && $settings['sub_title_style'] === 'px-sub-title-icon') : ?>
						<span class="pxl-sub-icon">
							<svg class="pxl-copy-svg1" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
							  <path d="M11.7181 23.7125C13.4838 23.7378 15.231 23.3503 16.8205 22.581C16.9258 22.5397 17.0215 22.4773 17.1015 22.3974C17.1816 22.3175 17.2443 22.222 17.2857 22.1168C17.3272 22.0116 17.3465 21.899 17.3425 21.786C17.3385 21.673 17.3112 21.562 17.2624 21.46C17.2136 21.3581 17.1442 21.2672 17.0587 21.1933C16.9732 21.1193 16.8733 21.0637 16.7654 21.0301C16.6574 20.9965 16.5437 20.9854 16.4313 20.9977C16.3189 21.01 16.2102 21.0454 16.1121 21.1015C14.5994 21.8286 12.9263 22.1579 11.2509 22.0582C9.57549 21.9585 7.95321 21.4332 6.5374 20.5319C5.1216 19.6306 3.95906 18.3831 3.1597 16.9073C2.36034 15.4315 1.95058 13.7763 1.96914 12.098C2.0106 8.0851 4.21131 3.63391 7.81887 3.11194C8.20231 3.0245 8.60029 3.02248 8.98459 3.10605C9.3689 3.18961 9.73011 3.3567 10.0426 3.59547C10.7501 4.39363 11.1197 5.43545 11.0735 6.50101C9.70262 6.68444 8.44361 7.35531 7.5268 8.39089C6.60999 9.42647 6.09668 10.7575 6.08077 12.1405L6.02979 17.0745C6.02754 17.2926 6.11201 17.5026 6.26464 17.6584C6.41726 17.8142 6.62553 17.903 6.84362 17.9053L9.31059 17.9308C9.52869 17.933 9.73874 17.8486 9.89455 17.6959C10.0504 17.5433 10.1392 17.335 10.1414 17.1169C10.1437 16.8989 10.0592 16.6888 9.90657 16.533C9.75395 16.3772 9.54568 16.2884 9.32758 16.2861L7.68294 16.2691L7.72542 12.1575C7.73668 11.067 8.18067 10.0257 8.95972 9.2626C9.73876 8.49949 10.789 8.0771 11.8795 8.08837C12.97 8.09964 14.0113 8.54363 14.7744 9.32267C15.5375 10.1017 15.9599 11.152 15.9487 12.2425L15.9062 16.3541L14.2615 16.3371C14.0434 16.3348 13.8334 16.4193 13.6776 16.5719C13.5218 16.7246 13.433 16.9328 13.4307 17.1509C13.4285 17.369 13.5129 17.5791 13.6656 17.7349C13.8182 17.8907 14.0264 17.9795 14.2445 17.9818L16.7115 18.0072C16.9296 18.0095 17.1397 17.925 17.2955 17.7724C17.4513 17.6198 17.5401 17.4115 17.5423 17.1934L17.5933 12.2595C17.606 10.8764 17.1203 9.53506 16.2251 8.48076C15.3298 7.42646 14.085 6.72972 12.7182 6.518C12.6308 4.62555 12.1107 3.22208 11.1653 2.3899C10.4276 1.7604 9.47908 1.43329 8.51017 1.47426C8.20773 1.47085 7.90538 1.48695 7.60502 1.52248C2.94369 2.1487 0.372497 7.43491 0.324495 12.081C0.292949 15.1344 1.47562 18.0752 3.61234 20.2565C5.74905 22.4378 8.66478 23.681 11.7181 23.7125Z" fill="#000"/>
							  <path d="M19.2889 7.34249C19.6418 7.34082 19.9921 7.28338 20.3269 7.17229C21.435 9.04239 21.8946 11.226 21.6343 13.3841C21.3741 15.5422 20.4086 17.554 18.8878 19.1071C18.8029 19.1818 18.7343 19.2733 18.6864 19.3758C18.6385 19.4783 18.6122 19.5896 18.6092 19.7027C18.6063 19.8158 18.6267 19.9282 18.6692 20.0331C18.7117 20.1379 18.7754 20.2329 18.8562 20.312C18.9371 20.3911 19.0334 20.4527 19.1392 20.4929C19.2449 20.5331 19.3578 20.551 19.4708 20.5456C19.5838 20.5402 19.6945 20.5115 19.7959 20.4613C19.8973 20.4112 19.9873 20.3406 20.0602 20.2541C21.8404 18.4367 22.9686 16.0809 23.2685 13.5546C23.5683 11.0283 23.023 8.47385 21.7177 6.29023C22.2312 5.73672 22.5386 5.02342 22.5884 4.27006C22.6382 3.51669 22.4274 2.76913 21.9912 2.15284C21.5551 1.53655 20.9202 1.08905 20.1932 0.885451C19.4661 0.681853 18.6912 0.734553 17.9984 1.0347C17.3056 1.33485 16.7372 1.86418 16.3885 2.53384C16.0398 3.2035 15.9321 3.97273 16.0834 4.71241C16.2347 5.4521 16.6359 6.11721 17.2196 6.59611C17.8033 7.07501 18.5339 7.33855 19.2889 7.34249ZM19.3399 2.40855C19.6652 2.41191 19.9822 2.51165 20.2508 2.69516C20.5194 2.87867 20.7275 3.13771 20.8489 3.43951C20.9703 3.74132 20.9994 4.07234 20.9327 4.39072C20.8659 4.70909 20.7062 5.00052 20.4739 5.22815C20.2415 5.45579 19.9468 5.6094 19.6271 5.66956C19.3074 5.72972 18.9771 5.69374 18.6778 5.56615C18.3786 5.43857 18.1239 5.22512 17.946 4.95279C17.7681 4.68046 17.6749 4.36149 17.6783 4.0362C17.6828 3.60002 17.8604 3.18348 18.172 2.87824C18.4836 2.573 18.9037 2.40404 19.3399 2.40855Z" fill="#000"/>
							</svg>
						</span>
					<?php endif; ?>
					<span class="pxl-item--subtext">
						<?php echo esc_attr($settings['sub_title']); ?>
					</span>
				</div>
			<?php endif; ?>

			<<?php echo esc_attr($settings['title_tag']); ?> class="pxl-item--title clip <?php echo esc_attr($settings['h_title_style'].' '.$settings['highlight_style'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
				
				<?php if($settings['h_title_style'] == 'style-shape') : ?>
					<span class="pxl-heading--shape pxl-mr-16"></span>
				<?php endif; ?>

				<?php if(is_singular('post') && $sg_post_title == 'custom_text' && !empty($sg_post_title_text) && $settings['source_type'] == 'title') { ?>
					<?php echo pxl_print_html($sg_post_title_text); ?>
				
				<?php } elseif(is_singular('portfolio') && $sg_portfolio_title == 'custom_text' && !empty($sg_portfolio_title_text) && $settings['source_type'] == 'title') { ?>
					<?php echo pxl_print_html($sg_portfolio_title_text); ?>
				
				<?php } elseif(is_singular('service') && $sg_service_title == 'custom_text' && !empty($sg_service_title_text) && $settings['source_type'] == 'title') { ?>
					<?php echo pxl_print_html($sg_service_title_text); ?>

				<?php } elseif(is_singular('product') && $sg_product_ptitle == 'custom_text' && !empty($sg_product_ptitle_text) && $settings['source_type'] == 'title') { ?>
					<?php echo pxl_print_html($sg_product_ptitle_text); ?>

				<?php } elseif(is_singular('career') && $sg_career_title == 'custom_text' && !empty($sg_career_title_text) && $settings['source_type'] == 'title') { ?>
					<?php echo pxl_print_html($sg_career_title_text); ?>
				
				<?php } else { ?>
					<?php if($settings['source_type'] == 'text' && !empty($editor_title)) {
						if($settings['h_title_style'] == 'style-outline') { ?>
							<span class="pxl-text-line-backdrop">
								<span><?php echo wp_kses_post($editor_title); ?></span>
								<svg stroke-width="2" class="svg-text-line"><text dominant-baseline="middle" text-anchor="middle" x="50%" y="50%"><?php echo wp_kses_post($editor_title); ?></text></svg>		
							</span>
						<?php } else {
							echo wp_kses_post($editor_title);
						}
					} elseif($settings['source_type'] == 'title') {
						$titles = maxcare()->page->get_title();
						if(!empty($_GET['blog_title'])) {
							$blog_title = $_GET['blog_title'];
							$custom_title = explode('_', $blog_title);
							foreach ($custom_title as $index => $value) {
			                    $arr_str_b[$index] = $value;
			                }
			                $str = implode(' ', $arr_str_b);
			                echo wp_kses_post($str);
						} else {
							pxl_print_html($titles['title']);
						}
					}?>	
				<?php } ?>	
			</<?php echo esc_attr($settings['title_tag']); ?>>
		</div>
	</div>
</div>