<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);  
$center = $widget->get_setting('center', 'false');
$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed,
    'center_slide'                         => $center,
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);
$default_settings = [
    'img_size_popup' => '',
];
$settings = array_merge($default_settings, $settings);

?>
<?php if(isset($settings['gallery']) && !empty($settings['gallery']) && count($settings['gallery'])):
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : '1500x1000';
$image_size_popup = !empty($img_size_popup) ? $img_size_popup : '1500x1000';
extract($settings);
$pxl_g_id = uniqid();
?>
    <div class="pxl-swiper-slider pxl-gallery-<?php echo esc_attr($pxl_g_id); ?> pxl-gallery-carousel pxl-gallery-carousel1" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'maxcare'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" data-center="<?php echo esc_attr($center); ?>">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['gallery'] as $key => $value):
                        $image = isset($value['image']) ? $value['image'] : null;
                        ?>
                         <div class="pxl-swiper-slide wa_magnetic_btn_2">
                            <div class="pxl-item--inner">
                                <?php if(!empty($image['id'])) { 
                                    $img = pxl_get_image_by_size( array(
                                        'attach_id'  => $image['id'],
                                        'thumb_size' => $image_size,
                                        'class' => 'no-lazyload',
                                    ));
                                    $thumbnail = $img['thumbnail'];

                                    $img_popup = pxl_get_image_by_size([
                                        'attach_id'  => $image['id'],
                                        'thumb_size' => $image_size_popup,
                                        'class'      => 'no-lazyload',
                                    ]);
                                    $thumbnail_popup = $img_popup['url'];
                                    ?>
                                    <div class="pxl-item--img">
                                        <span class="pxl-item-overlay"></span>
                                        <?php echo wp_kses_post($thumbnail); ?>
                                        <a href="<?php echo esc_url($thumbnail_popup); ?>" data-elementor-lightbox-slideshow="pxl-gallery-<?php echo esc_attr($pxl_g_id); ?>">
                                            <span class="pxl-item-icon wa_magnetic_btn_2_elm d-block">
                                                <i aria-hidden="true" class="far fa-eye"></i>
                                            </span>
                                        </a>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <?php if($pagination !== false): ?>
                <div class="pxl-swiper-dots style-2"></div>
            <?php endif; ?>

            <?php if($arrows !== false): ?>
                <div class="pxl-swiper-arrow-wrap style-1">
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev">
                        <svg width="10" height="16" viewBox="0 0 10 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M9 1L2 8L9 14.5" stroke="#000" stroke-width="1.5"/>
                        </svg>
                    </div>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next">
                        <svg width="10" height="16" viewBox="0 0 10 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                          <path d="M1 1L8 8L1 14.5" stroke="#000" stroke-width="1.5"/>
                        </svg>
                    </div>
                </div>
            <?php endif; ?>
            
        </div>
    </div>
<?php endif; ?>
