<?php
$html_id = pxl_get_element_id($settings);
if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link_text', 'href', $settings['link']['url'] );

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link_text', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link_text', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-banner-box pxl-banner-box2 <?php echo esc_attr($settings['pxl_animate'].' '.$settings['popular']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-item--inner">
        <?php if(!empty($settings['image']['id'])) : 
            $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '510x607'; 
            $img = pxl_get_image_by_size( array(
                'attach_id'  => $settings['image']['id'],
                'thumb_size' => $image_size,
            ));
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="pxl-item--img hover-imge-effect3">
                <?php echo pxl_print_html($thumbnail); ?>
            </div>
        <?php endif; ?>
        <div class="wptb-wrap-shape"> 
            <svg class="wptb-svg-1" width="422" height="328" viewBox="0 0 422 328" xmlns="http://www.w3.org/2000/svg">
                <path d="M0.287109 240.142C20.2871 205.285 96.63 135.228 242.001 133.856C385.076 132.507 421.433 46.9123 422.001 2.26061V0.14209C422.01 0.837364 422.011 1.54371 422.001 2.26061V327.571H0.287109V240.142Z"></path>
            </svg>
            <svg class="wptb-svg-2" width="422" height="329" viewBox="0 0 422 329" xmlns="http://www.w3.org/2000/svg">
                <path d="M199.142 146.428C96.2852 139.571 23.7137 193.857 0.285156 221.857V328.142H421.999V0.713623C387.714 112.142 327.714 154.999 199.142 146.428Z"></path>
            </svg>
        </div>
        <div class="pxl-item-content">
            <div class="pxl-item-title">
                <?php echo esc_attr($settings['title'])?>
            </div>
            <div class="pxl-item-phone">
                <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
                    <div class="pxl-item--icon">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                    </div>
                <?php endif; ?>
                <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
                    <div class="pxl-item--icon">
                        <?php $img_icon  = pxl_get_image_by_size( array(
                                'attach_id'  => $settings['icon_image']['id'],
                                'thumb_size' => 'full',
                            ) );
                            $thumbnail_icon    = $img_icon['thumbnail'];
                        echo pxl_print_html($thumbnail_icon); ?>
                    </div>
                <?php endif; ?>
                <div class="pxl-content-phone">
                    <div class="pxl-sub-phone">
                        <?php echo esc_attr($settings['sub_phone'])?>
                    </div>
                    <a class="pxl-title-phone" <?php pxl_print_html($widget->get_render_attribute_string( 'link_text' )); ?>>
                        <?php echo esc_attr($settings['title_phone'])?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>