<?php
/**
 * @package Case-Themes
 */

if ( post_password_required() ) {
    return;
    } ?>

    <div id="comments" class="comments-area">

        <?php
        if ( have_comments() ) : ?>
            <div class="comment-list-wrap">

                <h2 class="comments-title">
                    <span>
                        <?php
                            $comment_count = get_comments_number();
                            if ( 1 === intval($comment_count) ) {
                                echo esc_html__( '1 Comment', 'maxcare' );
                            } else {
                                echo esc_attr( $comment_count ).' '.esc_html__('Comments', 'maxcare');
                            }
                        ?>
                    </span>
                </h2>

                <?php the_comments_navigation(); ?>

                <ul class="comment-list">
                    <?php
                        wp_list_comments( array(
                            'style'      => 'ul',
                            'short_ping' => true,
                            'callback'   => 'maxcare_comment_list',
                            'max_depth'  => 3
                        ) );
                    ?>
                </ul>

                <?php the_comments_navigation(); ?>
            </div>
            <?php if ( ! comments_open() ) : ?>
                <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'maxcare' ); ?></p>
            <?php
            endif;

        endif;

        $args = array(
            'id_form'           => 'commentform',
            'id_submit'         => 'submit',
            'class_submit'      => 'btn-form-submit btn pxl-icon-active  btn-default  pxl-icon--right',
            'title_reply'       => esc_attr__( 'Leave A Comment', 'maxcare'),
            'title_reply_to'    => esc_attr__( 'Leave A Comment To ', 'maxcare') . '%s',
            'cancel_reply_link' => esc_attr__( 'Cancel Comment', 'maxcare'),
            'submit_button'     => '<button name="%1$s" type="submit" id="%2$s" class="%3$s">%4$s</button>',
            'comment_notes_before' => '',
            'fields' => apply_filters( 'comment_form_default_fields', array(
                'author' => '<div class="container"><div class="row"><div class="comment-form-author comment-input col-12 col-lg-6">'.
                            '<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) .
                            '" size="30" placeholder="'.esc_attr__('Name*', 'maxcare').'"/></div>',
                'email' => '<div class="comment-form-email comment-input col-12 col-lg-6">'.
                           '<input id="email" name="email" type="text" value="' . esc_attr( $commenter['comment_author_email'] ) .
                           '" size="30" placeholder="'.esc_attr__('E-mail*', 'maxcare').'"/></div>',
            )),
            'comment_field' => '<div class="comment-form-comment">'.
                              '<textarea id="comment" name="comment" cols="45" rows="8" placeholder="'.esc_attr__('Your Comment*', 'maxcare').'" aria-required="true"></textarea>'.
                              '</div>',
        );
        comment_form($args);
        ?>
</div>